/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.racelogtracking.impl.SmartphoneUUIDIdentifierImpl;
import com.sap.sailing.server.gateway.jaxrs.api.TrackingDeviceStatus;
import com.sap.sailing.server.gateway.jaxrs.api.TrackingDeviceStatusSerializer;
import com.sap.sailing.server.gateway.serialization.impl.DeviceIdentifierJsonSerializer;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/tracking_devices")
public class TrackingDevicesResource
extends AbstractSailingServerResource {
    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{deviceUUID}")
    public Response getDeviceStatus(@PathParam(value="deviceUUID") UUID deviceUUID) {
        TrackingDeviceStatusSerializer serializer = new TrackingDeviceStatusSerializer((JsonSerializer<DeviceIdentifier>)new DeviceIdentifierJsonSerializer(this.getServiceFinderFactory().createServiceFinder(DeviceIdentifierJsonHandler.class)));
        JSONObject result = serializer.serialize(this.calculateDeviceStatus(deviceUUID));
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getDeviceStatuses(@QueryParam(value="deviceUUIDs") Set<UUID> deviceUUIDs) {
        TrackingDeviceStatusSerializer serializer = new TrackingDeviceStatusSerializer((JsonSerializer<DeviceIdentifier>)new DeviceIdentifierJsonSerializer(this.getServiceFinderFactory().createServiceFinder(DeviceIdentifierJsonHandler.class)));
        JSONArray result = new JSONArray();
        for (UUID deviceUUID : deviceUUIDs) {
            result.add((Object)serializer.serialize(this.calculateDeviceStatus(deviceUUID)));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    private TrackingDeviceStatus calculateDeviceStatus(UUID deviceUUID) {
        SmartphoneUUIDIdentifierImpl deviceIdentifier = new SmartphoneUUIDIdentifierImpl(deviceUUID);
        return TrackingDeviceStatus.calculateDeviceStatus((DeviceIdentifier)deviceIdentifier, this.getService());
    }
}

