/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.TagAlreadyExistsException;
import com.sap.sailing.server.interfaces.TaggingService;
import com.sap.sailing.server.tagging.TagDTODeSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.AuthorizationException;
import org.json.simple.JSONArray;

@Path(value="/v1/{leaderboard}/{race_column}/{fleet}/tags")
public class TagsResource
extends AbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(TagsResource.class.getName());
    private static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    private static final String TEXT_PLAIN_UTF8 = "text/plain;charset=UTF-8";
    private final TagDTODeSerializer serializer = new TagDTODeSerializer();

    @GET
    @Produces(value={"application/json;charset=UTF-8", "text/plain;charset=UTF-8"})
    public Response getTags(@PathParam(value="leaderboard") String leaderboardName, @PathParam(value="race_column") String raceColumnName, @PathParam(value="fleet") String fleetName, @DefaultValue(value="both") @QueryParam(value="visibility") String visibility) {
        Response response;
        TaggingService taggingService = this.getService().getTaggingService();
        ArrayList tags = new ArrayList();
        boolean lookForPublic = visibility.equalsIgnoreCase("both") || visibility.equalsIgnoreCase("public");
        boolean lookForPrivate = visibility.equalsIgnoreCase("both") || visibility.equalsIgnoreCase("private");
        try {
            if (lookForPublic) {
                Util.addAll((Iterable)taggingService.getPublicTags(leaderboardName, raceColumnName, fleetName, null, false), tags);
            }
            if (lookForPrivate) {
                try {
                    Util.addAll((Iterable)taggingService.getPrivateTags(leaderboardName, raceColumnName, fleetName), tags);
                }
                catch (AuthorizationException authorizationException) {
                    // empty catch block
                }
            }
            JSONArray jsonTags = this.serializer.serialize(tags);
            response = Response.ok((Object)this.streamingOutput(jsonTags)).type(APPLICATION_JSON_UTF8).build();
        }
        catch (RaceLogNotFoundException e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(TEXT_PLAIN_UTF8).build();
        }
        catch (Exception e) {
            logger.warning("Could not load tags! " + e.getMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(TEXT_PLAIN_UTF8).build();
        }
        return response;
    }

    @POST
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response createTag(@Context UriInfo uriInfo, @PathParam(value="leaderboard") String leaderboardName, @PathParam(value="race_column") String raceColumnName, @PathParam(value="fleet") String fleetName, @FormParam(value="tag") String tag, @FormParam(value="comment") String comment, @FormParam(value="hiddenInfo") String hiddenInfo, @FormParam(value="image") String imageURL, @FormParam(value="resizedImage") String resizedImageURL, @FormParam(value="public") boolean visibleForPublic, @FormParam(value="raceTimepoint") long raceTimepoint) {
        Response response;
        TaggingService taggingService = this.getService().getTaggingService();
        try {
            if (visibleForPublic) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getService().getLeaderboardByName(leaderboardName));
            }
            taggingService.addTag(leaderboardName, raceColumnName, fleetName, tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, (TimePoint)new MillisecondsTimePoint(raceTimepoint));
            response = Response.created((URI)uriInfo.getRequestUri()).build();
        }
        catch (RaceLogNotFoundException | TagAlreadyExistsException | IllegalArgumentException e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(TEXT_PLAIN_UTF8).build();
        }
        catch (AuthorizationException e) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(TEXT_PLAIN_UTF8).build();
        }
        catch (Exception e) {
            logger.warning("Could not save tag! " + e.getMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(TEXT_PLAIN_UTF8).build();
        }
        return response;
    }

    @DELETE
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response deleteTag(@PathParam(value="leaderboard") String leaderboardName, @PathParam(value="race_column") String raceColumnName, @PathParam(value="fleet") String fleetName, @FormParam(value="tag_json") String tagJson) {
        Response response;
        TagDTO tagToRemove = this.serializer.deserializeTag(tagJson);
        TaggingService taggingService = this.getService().getTaggingService();
        try {
            taggingService.removeTag(leaderboardName, raceColumnName, fleetName, tagToRemove);
            response = Response.noContent().build();
        }
        catch (NotRevokableException | RaceLogNotFoundException | IllegalArgumentException e) {
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(TEXT_PLAIN_UTF8).build();
        }
        catch (AuthorizationException e) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(TEXT_PLAIN_UTF8).build();
        }
        catch (Exception e) {
            logger.warning("Could not remove tag! " + e.getMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(TEXT_PLAIN_UTF8).build();
        }
        return response;
    }

    @PUT
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateTag(@PathParam(value="leaderboard") String leaderboardName, @PathParam(value="race_column") String raceColumnName, @PathParam(value="fleet") String fleetName, @FormParam(value="tag_json") String tagJson, @FormParam(value="tag") String tagParam, @FormParam(value="comment") String commentParam, @FormParam(value="hiddenInfo") String hiddenInfo, @FormParam(value="image") String imageURLParam, @FormParam(value="resizedImage") String resizedImageURLParam, @FormParam(value="public") String visibleForPublicParam) {
        Response response;
        TagDTO tagToUpdate = this.serializer.deserializeTag(tagJson);
        TaggingService taggingService = this.getService().getTaggingService();
        if (tagParam != null || commentParam != null || imageURLParam != null || visibleForPublicParam != null) {
            String resizedImageURL;
            String tag = tagParam == null ? tagToUpdate.getTag() : tagParam;
            String comment = commentParam == null ? tagToUpdate.getComment() : commentParam;
            String imageURL = imageURLParam == null ? tagToUpdate.getImageURL() : imageURLParam;
            String string = resizedImageURL = resizedImageURLParam == null ? tagToUpdate.getResizedImageURL() : resizedImageURLParam;
            boolean visibleForPublic = visibleForPublicParam == null ? tagToUpdate.isVisibleForPublic() : visibleForPublicParam.equalsIgnoreCase("true");
            try {
                if (visibleForPublic) {
                    this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getService().getLeaderboardByName(leaderboardName));
                }
                taggingService.updateTag(leaderboardName, raceColumnName, fleetName, tagToUpdate, tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic);
                response = Response.noContent().build();
            }
            catch (NotRevokableException | RaceLogNotFoundException | TagAlreadyExistsException | IllegalArgumentException e) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(TEXT_PLAIN_UTF8).build();
            }
            catch (AuthorizationException e) {
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(TEXT_PLAIN_UTF8).build();
            }
            catch (Exception e) {
                logger.warning("Could not update tag! " + e.getMessage());
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(TEXT_PLAIN_UTF8).build();
            }
        } else {
            response = Response.noContent().build();
        }
        return response;
    }
}

