/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.server.gateway.serialization.impl.RemoteSailingServerReferenceJsonSerializer;
import com.sap.sailing.server.operationaltransformation.AddRemoteSailingServerReference;
import com.sap.sailing.server.operationaltransformation.RemoveRemoteSailingServerReference;
import com.sap.sailing.server.operationaltransformation.UpdateSailingServerReference;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.util.RemoteServerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/remoteserverreference")
public class RemoteServerReferenceResource
extends AbstractSailingServerResource {
    public static final String REMOVE = "/remove";
    public static final String UPDATE = "/update";
    public static final String ADD = "/add";
    public static final String V1_REMOTESERVERREFERENCE = "/v1/remoteserverreference";
    public static final Logger logger = Logger.getLogger(RemoteServerReferenceResource.class.getName());
    public static final String REMOTE_SERVER_URL = "remoteServerUrl";
    public static final String REMOTE_SERVER_NAME = "remoteServerName";
    public static final String REMOTE_SERVER_EVENT_IDS = "eventIds";
    public static final String REMOTE_SERVER_IS_INCLUDE = "include";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getRemoteServerReferences() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
        JSONArray result = new JSONArray();
        for (Map.Entry e : this.getService().getAllRemoteServerReferences().entrySet()) {
            JSONObject serverRefJson = this.serializeRemoteServerReference((RemoteSailingServerReference)e.getValue());
            result.add((Object)serverRefJson);
        }
        return Response.ok((Object)this.streamingOutput(result)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/{remoteServerName}")
    public Response getRemoteServerReferences(@PathParam(value="remoteServerName") String serverName) {
        Response response;
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
        RemoteSailingServerReference remoteServerReferenceByName = this.getService().getRemoteServerReferenceByName(serverName);
        if (remoteServerReferenceByName == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Couldn't find remote server reference named " + serverName)).build();
        } else {
            JSONObject serverRefJson = this.serializeRemoteServerReference(remoteServerReferenceByName);
            response = Response.ok((Object)this.streamingOutput(serverRefJson)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
        }
        return response;
    }

    private JSONObject serializeRemoteServerReference(RemoteSailingServerReference reference) {
        JSONObject serverRefJson = new RemoteSailingServerReferenceJsonSerializer().serialize(reference);
        return serverRefJson;
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/update")
    public Response updateRemoteServerReference(@FormParam(value="remoteServerName") String remoteServerName, @FormParam(value="include") Boolean include, @FormParam(value="eventIds") Set<String> eventIds) {
        Response response = null;
        if (!Util.hasLength((String)remoteServerName)) {
            response = this.badRequest("remoteServerName form parameter must not be empty.");
        } else {
            try {
                this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
                RemoteSailingServerReference existingReference = this.getService().getRemoteServerReferenceByName(remoteServerName);
                if (existingReference == null) {
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("No server reference by name " + StringEscapeUtils.escapeHtml((String)remoteServerName) + " found")).build();
                } else {
                    RemoteSailingServerReference serverRef = (RemoteSailingServerReference)this.getService().apply((OperationWithResult)new UpdateSailingServerReference(remoteServerName, include == null ? existingReference.isInclude() : include.booleanValue(), eventIds.stream().map(idString -> UUID.fromString(idString)).collect(Collectors.toSet())));
                    JSONObject jsonResponse = this.serializeRemoteServerReference(serverRef);
                    response = Response.ok((Object)this.streamingOutput(jsonResponse)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
                }
            }
            catch (UnauthorizedException e) {
                response = this.returnUnauthorized(e);
            }
            catch (Throwable e) {
                response = this.returnInternalServerError(e);
            }
        }
        return response;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/add")
    public Response addRemoteServerReference(@FormParam(value="remoteServerUrl") String remoteServerUrlAsString, @FormParam(value="remoteServerName") String remoteServerName, @FormParam(value="include") @DefaultValue(value="false") Boolean include) {
        Response response = null;
        if (!Util.hasLength((String)remoteServerUrlAsString) || !Util.hasLength((String)remoteServerName)) {
            response = this.badRequest("Both, remoteServerUrl and remoteServerName form parameters must not be empty.");
        } else {
            try {
                URL remoteServerUrl = RemoteServerUtil.createBaseUrl((String)remoteServerUrlAsString);
                this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
                RemoteSailingServerReference serverRef = (RemoteSailingServerReference)this.getService().apply((OperationWithResult)new AddRemoteSailingServerReference(remoteServerName, remoteServerUrl, include.booleanValue()));
                JSONObject jsonResponse = this.serializeRemoteServerReference(serverRef);
                response = Response.ok((Object)this.streamingOutput(jsonResponse)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
            }
            catch (UnauthorizedException e) {
                response = this.returnUnauthorized(e);
            }
            catch (MalformedURLException e) {
                response = this.badRequest("Malformed URL. See server logs for details.");
                logger.warning(String.valueOf(e.getMessage()) + " for URL: " + remoteServerUrlAsString);
            }
            catch (Throwable e) {
                response = this.returnInternalServerError(e);
            }
        }
        return response;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/remove")
    public Response removeRemoteServerReference(@FormParam(value="remoteServerName") String remoteServerName, @FormParam(value="remoteServerUrl") String remoteServerUrlAsString) {
        Response response = null;
        if (!Util.hasLength((String)remoteServerName) && !Util.hasLength((String)remoteServerUrlAsString)) {
            response = this.badRequest("No remote server name provided in form parameter remoteServerName nore any remote server URL provided in form parameter remoteServerUrl");
        } else {
            try {
                this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.CONFIGURE_REMOTE_INSTANCES);
                RemoteSailingServerReference serverRef = remoteServerName != null ? this.getService().getRemoteServerReferenceByName(remoteServerName) : this.getService().getRemoteServerReferenceByUrl(new URL(remoteServerUrlAsString));
                if (serverRef == null) {
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("\"remoteServerName: \\\"" + StringEscapeUtils.escapeHtml((String)remoteServerName) + "\\\", remoteServerUrl: \\\"" + StringEscapeUtils.escapeHtml((String)remoteServerUrlAsString) + "\\\" doesn't exist on this server.\"")).build();
                } else {
                    this.getService().apply((OperationWithResult)new RemoveRemoteSailingServerReference(serverRef.getName()));
                    JSONObject jsonResponse = this.serializeRemoteServerReference(serverRef);
                    response = Response.ok((Object)this.streamingOutput(jsonResponse)).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
                }
            }
            catch (UnauthorizedException e) {
                response = this.returnUnauthorized(e);
            }
            catch (Throwable e) {
                response = this.returnInternalServerError(e);
            }
        }
        return response;
    }
}

