/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl.rc;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.impl.SeriesImpl;
import com.sap.sailing.domain.base.racegroup.RaceCell;
import com.sap.sailing.domain.base.racegroup.RaceGroup;
import com.sap.sailing.domain.base.racegroup.RaceRow;
import com.sap.sailing.domain.base.racegroup.SeriesWithRows;
import com.sap.sailing.domain.base.racegroup.impl.RaceCellImpl;
import com.sap.sailing.domain.base.racegroup.impl.RaceGroupImpl;
import com.sap.sailing.domain.base.racegroup.impl.RaceRowImpl;
import com.sap.sailing.domain.base.racegroup.impl.SeriesWithRowsImpl;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.TargetTimeInfo;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class RaceGroupFactory {
    private static final Logger logger = Logger.getLogger(RaceGroupFactory.class.getName());

    public RaceGroup convert(RegattaLeaderboard leaderboard) {
        String name = leaderboard.getName();
        Regatta regatta = leaderboard.getRegatta();
        Iterable<SeriesWithRows> series = this.getSeries((Leaderboard)leaderboard);
        return new RaceGroupImpl(name, leaderboard.getDisplayName(), regatta.getBoatClass(), regatta.canBoatsOfCompetitorsChangePerRace(), series, regatta.getRegattaConfiguration());
    }

    public RaceGroup convert(FlexibleLeaderboard leaderboard) {
        String name = leaderboard.getName();
        BoatClass boatClass = null;
        RegattaConfiguration configuration = null;
        Iterable<SeriesWithRows> series = this.getSeries((Leaderboard)leaderboard);
        return new RaceGroupImpl(name, leaderboard.getDisplayName(), boatClass, false, series, configuration);
    }

    private Iterable<SeriesWithRows> getSeries(Leaderboard leaderboard) {
        Map<Series, List<RaceColumn>> seriesToRaceColumns = this.getSeriesToRaceColumns(leaderboard);
        ArrayList<SeriesWithRows> seriesWithRows = new ArrayList<SeriesWithRows>();
        for (Series series : this.getSeriesIterable(leaderboard, seriesToRaceColumns)) {
            seriesWithRows.add((SeriesWithRows)new SeriesWithRowsImpl(series.getName(), series.isMedal(), series.isFleetsCanRunInParallel(), this.getRows(series, seriesToRaceColumns.get(series), leaderboard.getScoringScheme())));
        }
        return seriesWithRows;
    }

    private Iterable<? extends Series> getSeriesIterable(Leaderboard leaderboard, Map<Series, List<RaceColumn>> seriesToRaceColumns) {
        if (leaderboard instanceof RegattaLeaderboard) {
            return ((RegattaLeaderboard)leaderboard).getRegatta().getSeries();
        }
        return seriesToRaceColumns.keySet();
    }

    private Collection<RaceRow> getRows(Series series, List<RaceColumn> raceColumns, ScoringScheme scoringScheme) {
        ArrayList<RaceRow> rows = new ArrayList<RaceRow>();
        for (Fleet fleet : series.getFleets()) {
            rows.add((RaceRow)new RaceRowImpl(fleet, this.getCells(fleet.getName(), raceColumns, this.isFirstRaceColumnVirtual(series), scoringScheme)));
        }
        return rows;
    }

    private boolean isFirstRaceColumnVirtual(Series series) {
        return series.isFirstColumnNonDiscardableCarryForward();
    }

    private List<RaceCell> getCells(String fleetName, List<RaceColumn> raceColumns, boolean isFirstRaceColumnVirtual, ScoringScheme scoringScheme) {
        boolean skippedFirst = false;
        ArrayList<RaceCell> cells = new ArrayList<RaceCell>();
        if (raceColumns != null) {
            int zeroBasedIndexOfRaceInFleet = 0;
            TimePoint now = MillisecondsTimePoint.now();
            for (RaceColumn raceColumn : raceColumns) {
                TargetTimeInfo targetTime;
                if (isFirstRaceColumnVirtual && !skippedFirst) {
                    skippedFirst = true;
                    continue;
                }
                Fleet fleet = raceColumn.getFleetByName(fleetName);
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                try {
                    targetTime = trackedRace == null ? null : trackedRace.getEstimatedTimeToComplete(now);
                }
                catch (NoWindException | NotEnoughDataHasBeenAddedException e) {
                    logger.fine(() -> "Unable to determine target time for " + trackedRace);
                    targetTime = null;
                }
                cells.add((RaceCell)new RaceCellImpl(raceColumn.getName(), raceColumn.getRaceLog(fleet), scoringScheme.getScoreFactor(raceColumn), raceColumn.getExplicitFactor(), zeroBasedIndexOfRaceInFleet++, targetTime));
            }
        }
        return cells;
    }

    private Map<Series, List<RaceColumn>> getSeriesToRaceColumns(Leaderboard leaderboard) {
        HashMap<Series, List<RaceColumn>> seriesToRaceColumns = new HashMap<Series, List<RaceColumn>>();
        Series defaultSeries = null;
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            if (raceColumn instanceof RaceColumnInSeries) {
                Series raceColumnSeries = ((RaceColumnInSeries)raceColumn).getSeries();
                this.insertSeriesIfNew(seriesToRaceColumns, raceColumnSeries).add(raceColumn);
                continue;
            }
            if (defaultSeries == null) {
                defaultSeries = this.createDefaultSeries(raceColumn.getFleets());
                this.insertSeriesIfNew(seriesToRaceColumns, defaultSeries);
            }
            ((List)seriesToRaceColumns.get(defaultSeries)).add(raceColumn);
        }
        return seriesToRaceColumns;
    }

    private Series createDefaultSeries(Iterable<? extends Fleet> fleets) {
        SeriesImpl defaultSeries = new SeriesImpl("Default", false, true, fleets, Collections.emptyList(), null);
        return defaultSeries;
    }

    private List<RaceColumn> insertSeriesIfNew(Map<Series, List<RaceColumn>> target, Series newSeries) {
        if (!target.containsKey(newSeries)) {
            target.put(newSeries, new ArrayList());
        }
        return target.get(newSeries);
    }
}

