/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.impl.data;

import com.sap.sse.datamining.data.ClusterBoundary;
import com.sap.sse.datamining.impl.data.AbstractCluster;
import com.sap.sse.datamining.impl.data.ComparisonStrategy;
import java.io.Serializable;
import java.util.Arrays;

public class ClusterWithSingleBoundary<ElementType extends Serializable>
extends AbstractCluster<ElementType> {
    private static final long serialVersionUID = -3188802475809553490L;
    private static final char INFINITE = '\u221e';

    public ClusterWithSingleBoundary(ClusterBoundary<ElementType> boundary) {
        super(Arrays.asList(boundary));
    }

    @Override
    protected String getBoundariesAsString() {
        ClusterBoundary boundary = super.getClusterBoundaries().iterator().next();
        StringBuilder builder = new StringBuilder();
        if (boundary.getStrategy() == ComparisonStrategy.LOWER_EQUALS_THAN || boundary.getStrategy() == ComparisonStrategy.LOWER_THAN) {
            builder.append("-\u221e - ");
        }
        builder.append(boundary);
        if (boundary.getStrategy() == ComparisonStrategy.GREATER_EQUALS_THAN || boundary.getStrategy() == ComparisonStrategy.GREATER_THAN) {
            builder.append(" - \u221e");
        }
        return builder.toString();
    }
}

