/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.subscription;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.subscription.ProviderSubscriptionUpdateTask;
import com.sap.sse.security.subscription.SubscriptionApiService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class SubscriptionUpdateTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(SubscriptionUpdateTask.class.getName());
    private final CompletableFuture<SecurityService> securityService;
    private final ServiceTracker<SubscriptionApiService, SubscriptionApiService> subscriptionApiServiceTracker;

    public SubscriptionUpdateTask(CompletableFuture<SecurityService> securityService, ServiceTracker<SubscriptionApiService, SubscriptionApiService> subscriptionApiServiceTracker) {
        this.securityService = securityService;
        this.subscriptionApiServiceTracker = subscriptionApiServiceTracker;
    }

    @Override
    public void run() {
        try {
            if (this.securityService.get().getMasterDescriptor() == null) {
                ServiceReference[] serviceReferenceArray = this.subscriptionApiServiceTracker.getServiceReferences();
                int n = serviceReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    SubscriptionApiService apiService = (SubscriptionApiService)this.subscriptionApiServiceTracker.getService(serviceReference);
                    if (apiService != null && apiService.isActive()) {
                        logger.info("Fetching and updating provider subscriptions for API service " + apiService.getProviderName());
                        this.fetchAndUpdateProviderSubscriptions(apiService);
                    }
                    ++n2;
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warning("Couldn't get a hold of the security service (" + e.getMessage() + "); not updating subscriptions.");
        }
    }

    private void fetchAndUpdateProviderSubscriptions(SubscriptionApiService apiService) {
        new ProviderSubscriptionUpdateTask(apiService, this.getSecurityService().getUserList(), this.securityService).run();
    }

    private SecurityService getSecurityService() {
        try {
            return this.securityService.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "Failure to get SecurityService", e);
            throw new RuntimeException(e);
        }
    }
}

