/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.SecurityService;
import com.sap.sse.security.impl.Activator;
import com.sap.sse.security.shared.impl.User;
import java.util.logging.Logger;
import org.apache.shiro.authc.AuthenticationToken;

public class BearerAuthenticationToken
implements AuthenticationToken {
    private static final long serialVersionUID = 8528031991813216585L;
    private static final Logger logger = Logger.getLogger(BearerAuthenticationToken.class.getName());
    private final String token;
    private final String clientIP;
    private final String userAgent;

    public BearerAuthenticationToken(String token, String clientIP, String userAgent) {
        this.token = token;
        this.clientIP = clientIP;
        this.userAgent = userAgent;
    }

    public Object getPrincipal() {
        SecurityService securityService = Activator.getSecurityService();
        User user = securityService.getUserByAccessToken(this.token);
        if (user == null) {
            logger.fine("Invalid bearer token did not authenticate an existing user");
        }
        return user == null ? null : user.getName();
    }

    public String getCredentials() {
        return this.token;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

