/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.mongodb.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.landscape.mongodb.impl.MongoEndpointImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

public class SimpleMongoEndpointImpl
extends MongoEndpointImpl {
    private final String hostname;
    private final int port;
    private final Optional<String> replicaSetName;

    public SimpleMongoEndpointImpl(String hostname, int port) {
        this(hostname, port, null);
    }

    public SimpleMongoEndpointImpl(String hostname, int port, String replicaSetName) {
        this.hostname = hostname;
        this.port = port;
        this.replicaSetName = Optional.ofNullable(replicaSetName);
    }

    @Override
    public URI getURI(Optional<Database> optionalDb) throws URISyntaxException {
        return this.getURI(optionalDb, this.hostname, this.port, this.replicaSetName);
    }

    @Override
    public URI getURI(Optional<Database> optionalDb, Optional<Duration> timeoutEmptyMeaningForever) throws URISyntaxException {
        return this.getURI(optionalDb);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.replicaSetName == null ? 0 : this.replicaSetName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleMongoEndpointImpl other = (SimpleMongoEndpointImpl)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.replicaSetName == null ? other.replicaSetName != null : !this.replicaSetName.equals(other.replicaSetName));
    }
}

