/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.application.impl;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.ReleaseRepository;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.impl.ProcessImpl;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import com.sap.sse.shared.util.Wait;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.LaxRedirectStrategyForAllRedirectResponseCodes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class ApplicationProcessImpl<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ProcessImpl<RotatingFileBasedLog, MetricsT>
implements ApplicationProcess<ShardingKey, MetricsT, ProcessT> {
    private static final String ENV_SH = "env.sh";
    private static final String VERSION_TXT = "configuration/jetty/version.txt";
    protected String serverDirectory;
    protected String serverName;
    private Integer telnetPortToOSGiConsole;

    public ApplicationProcessImpl(int port, Host host, String serverDirectory) {
        super(port, host);
        this.serverDirectory = serverDirectory;
    }

    public ApplicationProcessImpl(int port, Host host, String serverDirectory, Integer telnetPort, String serverName) {
        this(port, host, serverDirectory);
        this.telnetPortToOSGiConsole = telnetPort;
        this.serverName = serverName;
    }

    public int hashCode() {
        return this.getHost().hashCode() ^ this.getPort();
    }

    public boolean equals(Object o) {
        ApplicationProcess other = (ApplicationProcess)o;
        return Util.equalsWithNull((Object)this.getHost(), (Object)other.getHost()) && this.getPort() == other.getPort();
    }

    protected abstract String getDefaultApplicationUsername();

    @Override
    public Release getRelease(ReleaseRepository releaseRepository, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        Matcher matcher;
        Pattern pattern = Pattern.compile("^[^-]*-([^ ]*) System:");
        String versionTxt = this.getVersionTxt(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        Release result = versionTxt == null ? null : ((matcher = pattern.matcher(versionTxt)).find() ? releaseRepository.getRelease(matcher.group(1)) : null);
        return result;
    }

    private String getVersionTxt(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getFileContents(String.valueOf(this.getServerDirectory(optionalTimeout)) + "/" + VERSION_TXT, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    @Override
    public void tryShutdown(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws IOException, InterruptedException, JSchException, Exception {
        logger.info("Stopping application process " + this);
        SshCommandChannel sshChannel = this.getHost().createRootSshChannel(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        if (sshChannel == null) {
            logger.warning("Couldn't create an SSH connection to " + this + " for shutdown. Assuming it is already shut down.");
        } else {
            sshChannel.runCommandAndReturnStdoutAndLogStderr("cd " + this.getServerDirectory(optionalTimeout) + "; ./stop", "Shutting down " + this, Level.INFO);
        }
    }

    @Override
    public void restart(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws IOException, InterruptedException, JSchException, Exception {
        logger.info("Restarting application process " + this);
        this.getHost().createRootSshChannel(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase).runCommandAndReturnStdoutAndLogStderr("su -l " + this.getDefaultApplicationUsername() + " -c \"cd " + this.getServerDirectory(optionalTimeout) + "; ./stop; ./start\"", "Shutting down " + this, Level.INFO);
    }

    @Override
    public int getTelnetPortToOSGiConsole(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        if (this.telnetPortToOSGiConsole == null) {
            this.telnetPortToOSGiConsole = Integer.parseInt(this.getEnvShValueFor(DefaultProcessConfigurationVariables.TELNET_PORT, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase));
        }
        return this.telnetPortToOSGiConsole;
    }

    @Override
    public int[] getAllTCPPorts(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        int[] superTCPPorts = super.getAllTCPPorts(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        int[] result = new int[superTCPPorts.length + 1];
        System.arraycopy(superTCPPorts, 0, result, 0, superTCPPorts.length);
        result[result.length - 1] = this.getTelnetPortToOSGiConsole(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        return result;
    }

    @Override
    public String getEnvShValueFor(String variableName, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return ApplicationProcessImpl.getEnvShValueFor(this.getHost(), this.getServerDirectory(optionalTimeout), variableName, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    protected static String getEnvShValueFor(Host host, String serverDirectory, String variableName, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String variableValue;
        SshCommandChannel sshChannel = host.createRootSshChannel(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        String result = sshChannel == null ? null : ((variableValue = sshChannel.runCommandAndReturnStdoutAndLogStderr(". " + ApplicationProcessImpl.getEnvShPath(serverDirectory) + ">/dev/null 2>/dev/null; " + "echo \"${" + variableName + "}\"", null, null)).endsWith("\n") ? variableValue.substring(0, variableValue.length() - 1) : variableValue);
        return result;
    }

    @Override
    public String getEnvShValueFor(ProcessConfigurationVariable variable, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getEnvShValueFor(variable.name(), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    @Override
    public String getServerDirectory(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        return this.serverDirectory;
    }

    private static String getEnvShPath(String serverDirectory) {
        return String.valueOf(serverDirectory) + "/" + ENV_SH;
    }

    private String getEnvShPath(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        return ApplicationProcessImpl.getEnvShPath(this.getServerDirectory(optionalTimeout));
    }

    @Override
    public String getServerName(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        if (this.serverName == null) {
            this.serverName = this.getEnvShValueFor(DefaultProcessConfigurationVariables.SERVER_NAME, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        }
        return this.serverName;
    }

    @Override
    public String getEnvSh(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getFileContents(this.getEnvShPath(optionalTimeout), optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    protected String getFileContents(String path, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        String result;
        ChannelSftp sftpChannel = this.getHost().createRootSftpChannel(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        if (sftpChannel == null) {
            result = null;
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                sftpChannel.connect((int)optionalTimeout.orElse(Duration.NULL).asMillis());
                sftpChannel.get(path, (OutputStream)bos);
                result = bos.toString();
            }
            finally {
                sftpChannel.getSession().disconnect();
            }
        }
        return result;
    }

    @Override
    public String getHealthCheckPath() {
        return "/";
    }

    protected JSONObject getReplicationStatus(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        return this.getReplicationStatus(this.getReplicationStatusPostUrlAndQuery(optionalTimeout));
    }

    private JSONObject getReplicationStatus(URL url) throws IOException, ClientProtocolException, ParseException {
        HttpPost postRequest = new HttpPost(url.toString());
        CloseableHttpClient client = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategyForAllRedirectResponseCodes()).build();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HttpEntity entity = client.execute((HttpUriRequest)postRequest).getEntity();
        entity.writeTo((OutputStream)bos);
        return (JSONObject)new JSONParser().parse((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), HttpUrlConnectionHelper.getCharsetFromHttpEntity((HttpEntity)entity, (String)"UTF-8")));
    }

    @Override
    public String getMasterServerName(Optional<Duration> optionalTimeout) throws ClientProtocolException, IOException, ParseException, InterruptedException {
        String[] result = new String[1];
        try {
            Wait.wait(() -> {
                try {
                    JSONObject replicationStatus = this.getReplicationStatus(optionalTimeout);
                    for (Object replicable : (JSONArray)replicationStatus.get((Object)"replicables")) {
                        JSONObject replicableAsJson = (JSONObject)replicable;
                        if (replicableAsJson.get((Object)"replicatedfrom") == null) continue;
                        JSONObject replicatedFrom = (JSONObject)replicableAsJson.get((Object)"replicatedfrom");
                        String hostname = replicatedFrom.get((Object)"hostname").toString();
                        int port = ((Number)replicatedFrom.get((Object)"port")).intValue();
                        JSONObject masterReplicationStatus = this.getReplicationStatus(optionalTimeout, hostname, port);
                        stringArray[0] = masterReplicationStatus.get((Object)"servername").toString();
                        break;
                    }
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }, optionalTimeout, (Duration)Duration.ONE_SECOND.times(5L), (Level)Level.INFO, (String)("Waiting for master server name of " + this));
        }
        catch (Exception e) {
            logger.info("Exception while waiting for master server name of " + this + ": " + e.getMessage());
        }
        return result[0];
    }

    private JSONObject getReplicationStatus(Optional<Duration> optionalTimeout, String hostname, int port) throws ClientProtocolException, IOException, ParseException {
        return this.getReplicationStatus(this.getReplicationStatusPostUrlAndQuery(hostname, port));
    }

    @Override
    public void stopReplicatingFromMaster(String bearerToken, Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        URLConnection deregistrationRequestConnection = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)this.getUrl(STOP_REPLICATION_POST_URL_PATH_AND_QUERY, optionalTimeout), (String)"POST", (String)bearerToken);
        StringBuilder uuid = new StringBuilder();
        InputStream content = (InputStream)deregistrationRequestConnection.getContent();
        byte[] buf = new byte[256];
        int read = content.read(buf);
        while (read != -1) {
            uuid.append(new String(buf, 0, read));
            read = content.read(buf);
        }
        content.close();
    }

    public String toString() {
        return "ApplicationProcessImpl [serverDirectory=" + this.serverDirectory + ", serverName=" + this.serverName + ", port=" + this.getPort() + ", host=" + this.getHost() + "]";
    }
}

