/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.Math;
import smile.math.special.Beta;
import smile.stat.distribution.DiscreteDistribution;
import smile.stat.distribution.PoissonDistribution;

public class BinomialDistribution
extends DiscreteDistribution {
    private static final long serialVersionUID = 1L;
    private double p;
    private int n;
    private double entropy;
    private RandomNumberGenerator rng;

    public BinomialDistribution(int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid n: " + n);
        }
        this.n = n;
        this.p = p;
        this.entropy = Math.log(17.079468445347132 * (double)n * p * (1.0 - p)) / 2.0;
    }

    public double getProb() {
        return this.p;
    }

    public int getN() {
        return this.n;
    }

    @Override
    public int npara() {
        return 2;
    }

    @Override
    public double mean() {
        return (double)this.n * this.p;
    }

    @Override
    public double var() {
        return (double)this.n * this.p * (1.0 - this.p);
    }

    @Override
    public double sd() {
        return Math.sqrt((double)this.n * this.p * (1.0 - this.p));
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Binomial Distribution(%d, %.4f)", this.n, this.p);
    }

    @Override
    public double p(int k) {
        if (k < 0 || k > this.n) {
            return 0.0;
        }
        return Math.floor(0.5 + Math.exp(Math.logFactorial(this.n) - Math.logFactorial(k) - Math.logFactorial(this.n - k))) * Math.pow(this.p, (double)k) * Math.pow(1.0 - this.p, (double)(this.n - k));
    }

    @Override
    public double logp(int k) {
        if (k < 0 || k > this.n) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.logFactorial(this.n) - Math.logFactorial(k) - Math.logFactorial(this.n - k) + (double)k * Math.log(this.p) + (double)(this.n - k) * Math.log(1.0 - this.p);
    }

    @Override
    public double cdf(double k) {
        if (k < 0.0) {
            return 0.0;
        }
        if (k >= (double)this.n) {
            return 1.0;
        }
        return Beta.regularizedIncompleteBetaFunction((double)this.n - k, k + 1.0, 1.0 - this.p);
    }

    @Override
    public double quantile(double p) {
        int ku;
        int kl;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + p);
        }
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return this.n;
        }
        int inc = 1;
        int k = Math.max(0, Math.min(this.n, (int)((double)this.n * p)));
        if (p < this.cdf(k)) {
            do {
                k = Math.max(k - inc, 0);
                inc *= 2;
            } while (p < this.cdf(k) && k > 0);
            kl = k;
            ku = k + inc / 2;
        } else {
            do {
                k = Math.min(k + inc, this.n + 1);
                inc *= 2;
            } while (p > this.cdf(k));
            ku = k;
            kl = k - inc / 2;
        }
        return this.quantile(p, kl, ku);
    }

    @Override
    public double rand() {
        double np = (double)this.n * this.p;
        if (np < 1.0E-6) {
            return PoissonDistribution.tinyLambdaRand(np);
        }
        boolean inv = false;
        if (this.p > 0.5) {
            inv = true;
        }
        this.rng = np < 55.0 ? (this.p <= 0.5 ? new ModeSearch(this.p) : new ModeSearch(1.0 - this.p)) : (this.p <= 0.5 ? new Patchwork(this.p) : new Patchwork(1.0 - this.p));
        int x = this.rng.rand();
        if (inv) {
            x = this.n - x;
        }
        return x;
    }

    class ModeSearch
    implements RandomNumberGenerator {
        private int mode;
        private int bound;
        private double modeValue;
        private double r1;

        public ModeSearch(double p) {
            double nu = (double)(BinomialDistribution.this.n + 1) * p;
            this.bound = (int)(nu + 11.0 * (Math.sqrt(nu) + 1.0));
            if (this.bound > BinomialDistribution.this.n) {
                this.bound = BinomialDistribution.this.n;
            }
            this.mode = (int)nu;
            if ((double)this.mode == nu && p == 0.5) {
                --this.mode;
            }
            this.r1 = p / (1.0 - p);
            this.modeValue = Math.exp(Math.logFactorial(BinomialDistribution.this.n) - Math.logFactorial(this.mode) - Math.logFactorial(BinomialDistribution.this.n - this.mode) + (double)this.mode * Math.log(p) + (double)(BinomialDistribution.this.n - this.mode) * Math.log(1.0 - p));
        }

        @Override
        public int rand() {
            block0: while (true) {
                int x;
                double d;
                double d2;
                double U = Math.random();
                U -= this.modeValue;
                if (d2 <= 0.0) {
                    return this.mode;
                }
                double c = d = this.modeValue;
                for (int K = 1; K <= this.mode; ++K) {
                    double d3;
                    double d4;
                    x = this.mode - K;
                    double divisor = (double)(BinomialDistribution.this.n - x) * this.r1;
                    U *= divisor;
                    d *= divisor;
                    U -= (c *= (double)(x + 1));
                    if (d4 <= 0.0) {
                        return x;
                    }
                    x = this.mode + K;
                    divisor = x;
                    U *= divisor;
                    c *= divisor;
                    U -= (d *= (double)(BinomialDistribution.this.n - x + 1) * this.r1);
                    if (!(d3 <= 0.0)) continue;
                    return x;
                }
                x = this.mode + this.mode + 1;
                while (true) {
                    double d5;
                    if (x > this.bound) continue block0;
                    U *= (double)x;
                    U -= (d *= (double)(BinomialDistribution.this.n - x + 1) * this.r1);
                    if (d5 <= 0.0) {
                        return x;
                    }
                    ++x;
                }
                break;
            }
        }
    }

    class Patchwork
    implements RandomNumberGenerator {
        private int mode;
        private int k1;
        private int k2;
        private int k4;
        private int k5;
        private double dl;
        private double dr;
        private double r1;
        private double r2;
        private double r4;
        private double r5;
        private double ll;
        private double lr;
        private double l_pq;
        private double c_pm;
        private double f1;
        private double f2;
        private double f4;
        private double f5;
        private double p1;
        private double p2;
        private double p3;
        private double p4;
        private double p5;
        private double p6;

        public Patchwork(double p) {
            double nu = (double)(BinomialDistribution.this.n + 1) * p;
            double q = 1.0 - p;
            double W = Math.sqrt(nu * q + 0.25);
            this.mode = (int)nu;
            this.k2 = (int)Math.ceil(nu - 0.5 - W);
            this.k4 = (int)(nu - 0.5 + W);
            this.k1 = this.k2 + this.k2 - this.mode + 1;
            this.k5 = this.k4 + this.k4 - this.mode;
            this.dl = this.k2 - this.k1;
            this.dr = this.k5 - this.k4;
            this.r1 = (nu /= q) / (double)this.k1 - (p /= q);
            this.r2 = nu / (double)this.k2 - p;
            this.r4 = nu / (double)(this.k4 + 1) - p;
            this.r5 = nu / (double)(this.k5 + 1) - p;
            this.ll = Math.log(this.r1);
            this.lr = -Math.log(this.r5);
            this.l_pq = Math.log(p);
            this.c_pm = (double)this.mode * this.l_pq - Math.logFactorial(this.mode) - Math.logFactorial(BinomialDistribution.this.n - this.mode);
            this.f2 = this.f(this.k2, BinomialDistribution.this.n, this.l_pq, this.c_pm);
            this.f4 = this.f(this.k4, BinomialDistribution.this.n, this.l_pq, this.c_pm);
            this.f1 = this.f(this.k1, BinomialDistribution.this.n, this.l_pq, this.c_pm);
            this.f5 = this.f(this.k5, BinomialDistribution.this.n, this.l_pq, this.c_pm);
            this.p1 = this.f2 * (this.dl + 1.0);
            this.p2 = this.f2 * this.dl + this.p1;
            this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
            this.p4 = this.f4 * this.dr + this.p3;
            this.p5 = this.f1 / this.ll + this.p4;
            this.p6 = this.f5 / this.lr + this.p5;
        }

        @Override
        public int rand() {
            int X;
            while (true) {
                int Y;
                int Dk;
                double W;
                double V;
                double d;
                double U = Math.random() * this.p6;
                if (d < this.p2) {
                    double d2;
                    double d3;
                    double d4;
                    V = U - this.p1;
                    if (d4 < 0.0) {
                        return this.k2 + (int)(U / this.f2);
                    }
                    W = V / this.dl;
                    if (d3 < this.f1) {
                        return this.k1 + (int)(V / this.f1);
                    }
                    Dk = (int)(this.dl * Math.random()) + 1;
                    if (W <= this.f2 - (double)Dk * (this.f2 - this.f2 / this.r2)) {
                        return this.k2 - Dk;
                    }
                    V = this.f2 + this.f2 - W;
                    if (d2 < 1.0) {
                        Y = this.k2 + Dk;
                        if (V <= this.f2 + (double)Dk * (1.0 - this.f2) / (this.dl + 1.0)) {
                            return Y;
                        }
                        if (V <= this.f(Y, BinomialDistribution.this.n, this.l_pq, this.c_pm)) {
                            return Y;
                        }
                    }
                    X = this.k2 - Dk;
                } else if (U < this.p4) {
                    double d5;
                    double d6;
                    double d7;
                    V = U - this.p3;
                    if (d7 < 0.0) {
                        return this.k4 - (int)((U - this.p2) / this.f4);
                    }
                    W = V / this.dr;
                    if (d6 < this.f5) {
                        return this.k5 - (int)(V / this.f5);
                    }
                    Dk = (int)(this.dr * Math.random()) + 1;
                    if (W <= this.f4 - (double)Dk * (this.f4 - this.f4 * this.r4)) {
                        return this.k4 + Dk;
                    }
                    V = this.f4 + this.f4 - W;
                    if (d5 < 1.0) {
                        Y = this.k4 - Dk;
                        if (V <= this.f4 + (double)Dk * (1.0 - this.f4) / this.dr) {
                            return Y;
                        }
                        if (V <= this.f(Y, BinomialDistribution.this.n, this.l_pq, this.c_pm)) {
                            return Y;
                        }
                    }
                    X = this.k4 + Dk;
                } else {
                    W = Math.random();
                    if (U < this.p5) {
                        Dk = (int)(1.0 - Math.log(W) / this.ll);
                        X = this.k1 - Dk;
                        if (X < 0) continue;
                        if ((W *= (U - this.p4) * this.ll) <= this.f1 - (double)Dk * (this.f1 - this.f1 / this.r1)) {
                            return X;
                        }
                    } else {
                        Dk = (int)(1.0 - Math.log(W) / this.lr);
                        X = this.k5 + Dk;
                        if (X > BinomialDistribution.this.n) continue;
                        if ((W *= (U - this.p5) * this.lr) <= this.f5 - (double)Dk * (this.f5 - this.f5 * this.r5)) {
                            return X;
                        }
                    }
                }
                if (Math.log(W) <= (double)X * this.l_pq - Math.logFactorial(X) - Math.logFactorial(BinomialDistribution.this.n - X) - this.c_pm) break;
            }
            return X;
        }

        private double f(int k, int n, double l_pq, double c_pm) {
            return Math.exp((double)k * l_pq - Math.logFactorial(k) - Math.logFactorial(n - k) - c_pm);
        }
    }

    static interface RandomNumberGenerator {
        public int rand();
    }
}

