/*
 * Decompiled with CFR 0.152.
 */
package smile.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SparseArray
implements Iterable<Entry>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Entry> array;

    public SparseArray() {
        this(10);
    }

    private SparseArray(int initialCapacity) {
        this.array = new ArrayList<Entry>(initialCapacity);
    }

    public int size() {
        return this.array.size();
    }

    public boolean isEmpty() {
        return this.array.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.array.iterator();
    }

    public double get(int i) {
        for (Entry e : this.array) {
            if (e.i != i) continue;
            return e.x;
        }
        return 0.0;
    }

    public boolean set(int i, double x) {
        if (x == 0.0) {
            this.remove(i);
            return false;
        }
        Iterator<Entry> it = this.array.iterator();
        int k = 0;
        while (it.hasNext()) {
            Entry e = it.next();
            if (e.i == i) {
                e.x = x;
                return false;
            }
            if (e.i > i) {
                this.array.add(k, new Entry(i, x));
                return true;
            }
            ++k;
        }
        this.array.add(new Entry(i, x));
        return true;
    }

    public void append(int i, double x) {
        if (x != 0.0) {
            this.array.add(new Entry(i, x));
        }
    }

    public void remove(int i) {
        Iterator<Entry> it = this.array.iterator();
        while (it.hasNext()) {
            Entry e = it.next();
            if (e.i != i) continue;
            it.remove();
            break;
        }
    }

    public static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int i;
        public double x;

        public Entry(int i, double x) {
            this.i = i;
            this.x = x;
        }
    }
}

