/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.presentation;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.text.shared.AbstractRenderer;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.impl.CompoundGroupKey;
import com.sap.sse.datamining.shared.impl.GenericGroupKey;
import com.sap.sse.datamining.ui.client.ChartToCsvExporter;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.presentation.AbstractNumericResultsPresenter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.controls.SimpleObjectRenderer;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.ChartSubtitle;
import org.moxieapps.gwt.highcharts.client.ChartTitle;
import org.moxieapps.gwt.highcharts.client.Color;
import org.moxieapps.gwt.highcharts.client.Credits;
import org.moxieapps.gwt.highcharts.client.Exporting;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.YAxis;
import org.moxieapps.gwt.highcharts.client.events.SeriesClickEvent;
import org.moxieapps.gwt.highcharts.client.events.SeriesClickEventHandler;
import org.moxieapps.gwt.highcharts.client.labels.AxisLabelsData;
import org.moxieapps.gwt.highcharts.client.labels.AxisLabelsFormatter;
import org.moxieapps.gwt.highcharts.client.labels.DataLabels;
import org.moxieapps.gwt.highcharts.client.labels.DataLabelsData;
import org.moxieapps.gwt.highcharts.client.labels.DataLabelsFormatter;
import org.moxieapps.gwt.highcharts.client.labels.YAxisLabels;
import org.moxieapps.gwt.highcharts.client.plotOptions.SeriesPlotOptions;

public class ResultsChart
extends AbstractNumericResultsPresenter<Settings> {
    private final Comparator<GroupKey> standardKeyComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            return key1.compareTo((Object)key2);
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().groupName();
        }
    };
    private final Comparator<GroupKey> ascendingByValueKeyComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            double doubleValue1 = ((Number)ResultsChart.this.currentResultValues.get(key1)).doubleValue();
            double doubleValue2 = ((Number)ResultsChart.this.currentResultValues.get(key2)).doubleValue();
            return Double.compare(doubleValue1, doubleValue2);
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().valueAscending();
        }
    };
    private final Comparator<GroupKey> descendingByValueKeyComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            return -1 * ResultsChart.this.ascendingByValueKeyComparator.compare(key1, key2);
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().valueDescending();
        }
    };
    private final Comparator<GroupKey> ascendingByGroupAverageComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            GroupKey mainKey1 = GroupKey.Util.getMainKey((GroupKey)key1);
            GroupKey mainKey2 = GroupKey.Util.getMainKey((GroupKey)key2);
            return Double.compare((Double)ResultsChart.this.averagePerMainKey.get(mainKey1), (Double)ResultsChart.this.averagePerMainKey.get(mainKey2));
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().groupAverageAscending();
        }
    };
    private final Comparator<GroupKey> descendingByGroupAverageComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            return -1 * ResultsChart.this.ascendingByGroupAverageComparator.compare(key1, key2);
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().groupAverageDescending();
        }
    };
    private final Comparator<GroupKey> ascendingByGroupMedianComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            GroupKey mainKey1 = GroupKey.Util.getMainKey((GroupKey)key1);
            GroupKey mainKey2 = GroupKey.Util.getMainKey((GroupKey)key2);
            return Double.compare((Double)ResultsChart.this.medianPerMainKey.get(mainKey1), (Double)ResultsChart.this.medianPerMainKey.get(mainKey2));
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().groupMedianAscending();
        }
    };
    private final Comparator<GroupKey> descendingByGroupMedianComparator = new Comparator<GroupKey>(){

        @Override
        public int compare(GroupKey key1, GroupKey key2) {
            return -1 * ResultsChart.this.ascendingByGroupMedianComparator.compare(key1, key2);
        }

        public String toString() {
            return ResultsChart.this.getDataMiningStringMessages().groupMedianDescending();
        }
    };
    private final HorizontalPanel sortByPanel;
    private final ValueListBox<Comparator<GroupKey>> keyComparatorListBox;
    private final ValueListBox<Integer> decimalsListBox;
    private final CheckBox showDataLabelsCheckBox;
    private final SimpleLayoutPanel chartPanel;
    private final Chart chart;
    private final DrillDownCallback drillDownCallback;
    private final Map<GroupKey, Series> seriesMappedByGroupKey;
    private final Map<GroupKey, Series> errorSeriesMappedByGroupKey;
    private final GroupKey simpleResultSeriesKey;
    private final Map<GroupKey, Integer> mainKeyToXValueMap;
    private final Map<Integer, GroupKey> xValueToMainKeyMap;
    private Map<GroupKey, Number> currentResultValues;
    private Map<GroupKey, Util.Triple<Number, Number, Long>> currentResultErrorMargins;
    private final Map<GroupKey, Double> averagePerMainKey;
    private final Map<GroupKey, Double> medianPerMainKey;
    private final boolean showErrorBars;

    public ResultsChart(Component<?> parent, ComponentContext<?> context, boolean showErrorBars, DrillDownCallback drillDownCallback) {
        super(parent, context);
        this.showErrorBars = showErrorBars;
        this.drillDownCallback = drillDownCallback;
        this.chartPanel = new SimpleLayoutPanel(){

            public void onResize() {
                ResultsChart.this.chart.setSizeToMatchContainer();
                ResultsChart.this.chart.redraw();
            }
        };
        this.chart = this.createChart();
        this.chartPanel.setWidget((Widget)this.chart);
        this.sortByPanel = new HorizontalPanel();
        this.sortByPanel.setSpacing(5);
        this.sortByPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.sortByPanel.add((Widget)new Label(String.valueOf(this.getDataMiningStringMessages().sortBy()) + ":"));
        this.keyComparatorListBox = new ValueListBox((Renderer)new AbstractRenderer<Comparator<?>>(){

            public String render(Comparator<?> object) {
                return object.toString();
            }
        });
        this.keyComparatorListBox.addValueChangeHandler(e -> {
            this.resetChartSeries();
            this.showResultData();
        });
        this.sortByPanel.add(this.keyComparatorListBox);
        this.sortByPanel.setVisible(false);
        this.addControl((Widget)this.sortByPanel);
        HorizontalPanel decimalsPanel = new HorizontalPanel();
        decimalsPanel.setSpacing(5);
        decimalsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        decimalsPanel.add((Widget)new Label(String.valueOf(this.getDataMiningStringMessages().shownDecimals()) + ":"));
        this.decimalsListBox = new ValueListBox((Renderer)new SimpleObjectRenderer());
        decimalsPanel.add(this.decimalsListBox);
        this.decimalsListBox.setValue((Object)0);
        this.decimalsListBox.setAcceptableValues(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9));
        this.decimalsListBox.addValueChangeHandler(e -> {
            this.updateChartLabels();
            this.resetChartSeries();
            this.showResultData();
        });
        this.addControl((Widget)decimalsPanel);
        HorizontalPanel showDataLabelsPanel = new HorizontalPanel();
        showDataLabelsPanel.setSpacing(5);
        showDataLabelsPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        showDataLabelsPanel.add((Widget)new Label(String.valueOf(this.getDataMiningStringMessages().showDataLabels()) + ":"));
        this.showDataLabelsCheckBox = new CheckBox();
        showDataLabelsPanel.add((Widget)this.showDataLabelsCheckBox);
        this.showDataLabelsCheckBox.setValue(Boolean.valueOf(true));
        this.showDataLabelsCheckBox.addValueChangeHandler(e -> {
            this.resetChartSeries();
            this.showResultData();
        });
        this.addControl((Widget)showDataLabelsPanel);
        StringMessages stringMessages = this.getDataMiningStringMessages();
        ChartToCsvExporter csvExporter = new ChartToCsvExporter(stringMessages.csvCopiedToClipboard());
        Button exportButton = new Button(stringMessages.csvExport());
        exportButton.addClickHandler(e -> csvExporter.exportChartAsCsvToClipboard(this.chart));
        this.addControl((Widget)exportButton);
        this.seriesMappedByGroupKey = new HashMap<GroupKey, Series>();
        this.errorSeriesMappedByGroupKey = new HashMap<GroupKey, Series>();
        this.simpleResultSeriesKey = new GenericGroupKey((Object)this.getDataMiningStringMessages().results());
        this.mainKeyToXValueMap = new HashMap<GroupKey, Integer>();
        this.xValueToMainKeyMap = new HashMap<Integer, GroupKey>();
        this.averagePerMainKey = new HashMap<GroupKey, Double>();
        this.medianPerMainKey = new HashMap<GroupKey, Double>();
    }

    @Override
    protected Widget getPresentationWidget() {
        return this.chartPanel;
    }

    @Override
    protected void internalShowNumericResults(Map<GroupKey, Number> resultValues, Map<GroupKey, Util.Triple<Number, Number, Long>> errorMargins) {
        this.currentResultValues = resultValues;
        this.currentResultErrorMargins = errorMargins;
        this.decimalsListBox.setValue((Object)this.getCurrentResult().getValueDecimals(), false);
        this.updateKeyComparatorListBox();
        this.resetChartSeries();
        this.updateChartLabels();
        Scheduler.get().scheduleDeferred(this::showResultData);
    }

    private void updateKeyComparatorListBox() {
        boolean visible = false;
        Comparator<GroupKey> valueToBeSelected = this.standardKeyComparator;
        ArrayList<Comparator<GroupKey>> acceptableValues = new ArrayList<Comparator<GroupKey>>();
        acceptableValues.add(valueToBeSelected);
        if (this.getCurrentResult() != null) {
            if (this.isCurrentResultSimple()) {
                acceptableValues.add(this.ascendingByValueKeyComparator);
                acceptableValues.add(this.descendingByValueKeyComparator);
            } else {
                acceptableValues.add(this.ascendingByGroupAverageComparator);
                acceptableValues.add(this.descendingByGroupAverageComparator);
                acceptableValues.add(this.ascendingByGroupMedianComparator);
                acceptableValues.add(this.descendingByGroupMedianComparator);
            }
            visible = true;
        }
        this.keyComparatorListBox.setValue(valueToBeSelected);
        this.keyComparatorListBox.setAcceptableValues(acceptableValues);
        this.sortByPanel.setVisible(visible);
    }

    private void resetChartSeries() {
        this.chart.removeAllSeries(false);
        this.seriesMappedByGroupKey.clear();
        this.errorSeriesMappedByGroupKey.clear();
    }

    private void updateChartLabels() {
        this.chart.getYAxis().setAxisTitleText(this.getCurrentResult().getResultSignifier());
        this.chart.setToolTip(new ToolTip().setValueDecimals((Number)this.decimalsListBox.getValue()));
    }

    private void showResultData() {
        this.buildMainKeyMapAndSetXAxisCategories();
        this.createAndAddSeriesToChart();
        HashMap valuesPerMainKey = new HashMap();
        this.currentResultValues.entrySet().stream().sorted((e1, e2) -> this.mainKeyToXValueMap.get(GroupKey.Util.getMainKey((GroupKey)((GroupKey)e1.getKey()))).compareTo(this.mainKeyToXValueMap.get(GroupKey.Util.getMainKey((GroupKey)((GroupKey)e2.getKey()))))).forEach(resultEntry -> {
            GroupKey mainKey = GroupKey.Util.getMainKey((GroupKey)((GroupKey)resultEntry.getKey()));
            Number value = (Number)resultEntry.getValue();
            if (!this.isCurrentResultSimple()) {
                if (!valuesPerMainKey.containsKey(mainKey)) {
                    valuesPerMainKey.put(mainKey, new ArrayList());
                }
                ((List)valuesPerMainKey.get(mainKey)).add(value);
            }
            Point point = new Point((Number)this.mainKeyToXValueMap.get(mainKey), value);
            point.setName(mainKey.asString());
            this.seriesMappedByGroupKey.get(this.groupKeyToSeriesKey((GroupKey)resultEntry.getKey())).addPoint(point, false, false, false);
            if (this.showErrorBars) {
                Util.Triple<Number, Number, Long> errorMargins;
                Util.Triple<Number, Number, Long> triple = errorMargins = this.currentResultErrorMargins == null ? null : this.currentResultErrorMargins.get(mainKey);
                if (errorMargins != null) {
                    Point errorMarginsPoint = new Point((Number)this.mainKeyToXValueMap.get(mainKey), (Number)errorMargins.getA(), (Number)errorMargins.getB());
                    errorMarginsPoint.setName(String.valueOf(mainKey.asString()) + ", " + this.getDataMiningStringMessages().elements((Long)errorMargins.getC()));
                    this.errorSeriesMappedByGroupKey.get(this.groupKeyToSeriesKey((GroupKey)resultEntry.getKey())).addPoint(errorMarginsPoint, false, false, false);
                }
            }
        });
        this.averagePerMainKey.clear();
        this.medianPerMainKey.clear();
        if (!this.isCurrentResultSimple()) {
            for (GroupKey mainKey : valuesPerMainKey.keySet()) {
                List values = (List)valuesPerMainKey.get(mainKey);
                this.averagePerMainKey.put(mainKey, this.getAverageFromValues(values));
                this.medianPerMainKey.put(mainKey, this.getMedianFromValues(values));
            }
        }
        this.chart.redraw();
    }

    private Double getAverageFromValues(Collection<Number> values) {
        double sum = 0.0;
        for (Number value : values) {
            sum += value.doubleValue();
        }
        return sum / (double)values.size();
    }

    private Double getMedianFromValues(List<Number> values) {
        Collections.sort(values, new Comparator<Number>(){

            @Override
            public int compare(Number n1, Number n2) {
                return Double.compare(n1.doubleValue(), n2.doubleValue());
            }
        });
        if (values.size() % 2 == 0) {
            int index1 = values.size() / 2 - 1;
            int index2 = index1 + 1;
            return (values.get(index1).doubleValue() + values.get(index2).doubleValue()) / 2.0;
        }
        int index = (values.size() + 1) / 2 - 1;
        return values.get(index).doubleValue();
    }

    private void buildMainKeyMapAndSetXAxisCategories() {
        List<GroupKey> sortedMainKeys = this.getSortedMainKeys();
        String[] categories = new String[sortedMainKeys.size()];
        this.mainKeyToXValueMap.clear();
        this.xValueToMainKeyMap.clear();
        int i = 0;
        while (i < sortedMainKeys.size()) {
            GroupKey mainKey = sortedMainKeys.get(i);
            categories[i] = mainKey.asString();
            this.mainKeyToXValueMap.put(mainKey, i);
            this.xValueToMainKeyMap.put(i, mainKey);
            ++i;
        }
        this.chart.getXAxis().setCategories(false, categories);
    }

    private List<GroupKey> getSortedMainKeys() {
        HashSet<GroupKey> mainKeySet = new HashSet<GroupKey>();
        for (GroupKey groupKey : this.getCurrentResult().getResults().keySet()) {
            mainKeySet.add(GroupKey.Util.getMainKey((GroupKey)groupKey));
        }
        ArrayList<GroupKey> sortedKeys = new ArrayList<GroupKey>(mainKeySet);
        Collections.sort(sortedKeys, this.getKeyComparator());
        return sortedKeys;
    }

    private Comparator<GroupKey> getKeyComparator() {
        return (Comparator)this.keyComparatorListBox.getValue();
    }

    private void createAndAddSeriesToChart() {
        for (GroupKey groupKey : this.getCurrentResult().getResults().keySet()) {
            GroupKey seriesKey = this.groupKeyToSeriesKey(groupKey);
            if (this.seriesMappedByGroupKey.containsKey(seriesKey)) continue;
            this.seriesMappedByGroupKey.put(seriesKey, this.chart.createSeries().setName(seriesKey.asString()));
            if (!this.showErrorBars) continue;
            this.errorSeriesMappedByGroupKey.put(seriesKey, this.chart.createSeries().setType(Series.Type.ERRORBAR).setName(String.valueOf(seriesKey.asString()) + " " + this.getDataMiningStringMessages().dataMiningErrorMargins()));
        }
        ArrayList<GroupKey> sortedSeriesKeys = new ArrayList<GroupKey>(this.seriesMappedByGroupKey.keySet());
        Collections.sort(sortedSeriesKeys);
        for (GroupKey seriesKey : sortedSeriesKeys) {
            this.chart.addSeries(this.seriesMappedByGroupKey.get(seriesKey), false, false);
            if (!this.showErrorBars) continue;
            this.chart.addSeries(this.errorSeriesMappedByGroupKey.get(seriesKey), false, false);
        }
    }

    private GroupKey groupKeyToSeriesKey(GroupKey groupKey) {
        if (groupKey.hasSubKeys()) {
            List subKeys = GroupKey.Util.getSubKeys((GroupKey)groupKey);
            return subKeys.size() == 1 ? (GroupKey)subKeys.get(0) : new CompoundGroupKey(subKeys);
        }
        return this.simpleResultSeriesKey;
    }

    private Chart createChart() {
        Chart chart = (Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)((Chart)new Chart().setType(Series.Type.COLUMN)).setMarginLeft((Number)100)).setMarginRight((Number)45)).setWidth100()).setHeight100()).setBorderColor(new Color("#F0AB00"))).setPlotBorderWidth((Number)0)).setTitle(new ChartTitle().setText(""), new ChartSubtitle().setText(""))).setCredits(new Credits().setEnabled(false));
        chart.setExporting(new Exporting().setEnabled(false));
        chart.getXAxis().setAllowDecimals(false);
        ((YAxis)chart.getYAxis().setAxisTitleText("Result")).setLabels(new YAxisLabels().setFormatter(new AxisLabelsFormatter(){

            public String format(AxisLabelsData axisLabelsData) {
                try {
                    return String.valueOf(axisLabelsData.getValueAsDouble());
                }
                catch (Exception e) {
                    return "";
                }
            }
        }));
        chart.setSeriesPlotOptions(((SeriesPlotOptions)new SeriesPlotOptions().setDataLabels((DataLabels)((DataLabels)new DataLabels().setEnabled(true)).setFormatter(new DataLabelsFormatter(){

            public String format(DataLabelsData dataLabelsData) {
                String dataLabel = String.valueOf(BigDecimal.valueOf(dataLabelsData.getYAsDouble()).setScale((int)((Integer)ResultsChart.this.decimalsListBox.getValue()), RoundingMode.HALF_UP).doubleValue());
                return ResultsChart.this.showDataLabelsCheckBox.getValue() != false ? dataLabel : null;
            }
        }))).setSeriesClickEventHandler((SeriesClickEventHandler)new SeriesClickHandler()));
        return chart;
    }

    public void drillDown(GroupKey groupKey) {
        if (this.drillDownCallback != null) {
            this.drillDownCallback.drillDown(groupKey);
        }
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().resultsChart();
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public String getDependentCssClassName() {
        return "resultsChart";
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "rc";
    }

    @FunctionalInterface
    public static interface DrillDownCallback {
        public void drillDown(GroupKey var1);
    }

    private class SeriesClickHandler
    implements SeriesClickEventHandler {
        private SeriesClickHandler() {
        }

        public boolean onClick(SeriesClickEvent seriesClickEvent) {
            double xAxisValue = seriesClickEvent.getNearestXAsDouble();
            GroupKey groupKey = (GroupKey)ResultsChart.this.xValueToMainKeyMap.get((int)Math.round(xAxisValue));
            ResultsChart.this.drillDown(groupKey);
            return true;
        }
    }
}

