/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.hierarchy;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.hierarchy.EventHierarchyVisitor;
import com.sap.sailing.server.hierarchy.LeaderboardGroupHierarchyVisitor;
import com.sap.sailing.server.hierarchy.LeaderboardHierarchyVisitor;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SailingHierarchyWalker {
    private SailingHierarchyWalker() {
    }

    public static void walkFromEvent(Event event, boolean includeLeaderboardGroupsWithOverallLeaderboard, EventHierarchyVisitor visitor) {
        HashMap leaderboardsToLeaderboardGroups = new HashMap();
        for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
            boolean hasOverallLeaderboard = leaderboardGroup.hasOverallLeaderboard();
            boolean allLeaderboardsArePartOfEvent = true;
            boolean includeLeaderboardGroup = includeLeaderboardGroupsWithOverallLeaderboard || !hasOverallLeaderboard;
            for (Leaderboard lb : leaderboardGroup.getLeaderboards()) {
                boolean partOfEvent = lb.isPartOfEvent((EventBase)event);
                if (includeLeaderboardGroup || partOfEvent) {
                    Util.add(leaderboardsToLeaderboardGroups, (Object)lb, (Object)leaderboardGroup);
                    continue;
                }
                allLeaderboardsArePartOfEvent = false;
            }
            if (!includeLeaderboardGroup && !allLeaderboardsArePartOfEvent) continue;
            visitor.visit(leaderboardGroup);
            if (!hasOverallLeaderboard) continue;
            Util.add(leaderboardsToLeaderboardGroups, (Object)leaderboardGroup.getOverallLeaderboard(), (Object)leaderboardGroup);
        }
        for (Map.Entry entry : leaderboardsToLeaderboardGroups.entrySet()) {
            visitor.visit((Leaderboard)entry.getKey(), (Set)entry.getValue());
        }
    }

    public static void walkFromLeaderboardGroup(RacingEventService service, LeaderboardGroup leaderboardGroup, boolean includeEventsIfLeaderboardGroupHasOverallLeaderboard, LeaderboardGroupHierarchyVisitor visitor) {
        boolean visitEvents;
        boolean bl = visitEvents = includeEventsIfLeaderboardGroupHasOverallLeaderboard && leaderboardGroup.hasOverallLeaderboard();
        if (visitEvents) {
            for (Event event : service.getAllEvents()) {
                if (!Util.contains((Iterable)event.getLeaderboardGroups(), (Object)leaderboardGroup)) continue;
                visitor.visit(event);
            }
        }
        for (Leaderboard lb : leaderboardGroup.getLeaderboards()) {
            visitor.visit(lb);
        }
        if (leaderboardGroup.hasOverallLeaderboard()) {
            visitor.visit(leaderboardGroup.getOverallLeaderboard());
        }
    }

    public static void walkFromLeaderboard(Leaderboard leaderboard, LeaderboardHierarchyVisitor visitor) {
        for (TrackedRace race : leaderboard.getTrackedRaces()) {
            visitor.visit(race);
        }
        for (Competitor comp : leaderboard.getCompetitors()) {
            visitor.visit(comp);
        }
        for (Boat boat : leaderboard.getAllBoats()) {
            visitor.visit(boat);
        }
    }
}

