/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.util;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Wait {
    private static final Logger logger = Logger.getLogger(Wait.class.getName());

    public static boolean wait(Callable<Boolean> condition, Optional<Duration> optionalTimeoutEmptyMeansForever, Duration sleepBetweenAttempts) throws Exception {
        return Wait.wait(condition, optionalTimeoutEmptyMeansForever, sleepBetweenAttempts, null, null);
    }

    public static boolean wait(Callable<Boolean> condition, Optional<Duration> optionalTimeoutEmptyMeansForever, Duration sleepBetweenAttempts, Level logLevel, String retryLogMessage) throws Exception, TimeoutException {
        return Wait.wait(condition, result -> result, false, optionalTimeoutEmptyMeansForever, sleepBetweenAttempts, logLevel, retryLogMessage);
    }

    public static <T> T wait(Callable<T> callable, Predicate<T> successPredicate, boolean retryOnException, Optional<Duration> optionalTimeoutEmptyMeansForever, Duration sleepBetweenAttempts, Level logLevel, String retryLogMessage) throws Exception, TimeoutException {
        boolean timeForAnotherAttempt;
        boolean success;
        TimePoint start = TimePoint.now();
        T result = null;
        do {
            try {
                result = callable.call();
                success = successPredicate.test(result);
                if (success && logLevel != null && retryLogMessage != null) {
                    logger.log(logLevel, String.valueOf(retryLogMessage) + " succeeded.");
                }
            }
            catch (Exception e) {
                if (retryOnException) {
                    success = false;
                    if (logLevel != null && retryLogMessage != null) {
                        logger.log(logLevel, String.valueOf(retryLogMessage) + " threw exception " + e.getMessage());
                    }
                }
                throw e;
            }
            timeForAnotherAttempt = optionalTimeoutEmptyMeansForever.map(timeout -> TimePoint.now().plus(sleepBetweenAttempts).before(start.plus(timeout))).orElse(true);
            if (success) continue;
            if (logLevel != null && retryLogMessage != null) {
                logger.log(logLevel, String.valueOf(retryLogMessage) + " failed." + (timeForAnotherAttempt ? String.valueOf(optionalTimeoutEmptyMeansForever.map(timeout -> " Will time out in " + timeout.minus(start.until(TimePoint.now())).toString()).orElse("")) + " Sleeping for " + sleepBetweenAttempts + " now..." : ""));
            }
            if (!timeForAnotherAttempt) continue;
            Thread.sleep(sleepBetweenAttempts.asMillis());
        } while (!success && timeForAnotherAttempt);
        if (!success) {
            if (logLevel != null && retryLogMessage != null) {
                logger.log(logLevel, String.valueOf(retryLogMessage) + " timed out.");
            }
            throw new TimeoutException();
        }
        return result;
    }
}

