/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.concurrent;

import java.util.AbstractCollection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentHashBag<T>
extends AbstractCollection<T> {
    private ConcurrentHashMap<T, Integer> map = new ConcurrentHashMap();
    private final AtomicInteger size = new AtomicInteger();

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public int count(Object o) {
        Integer result = this.map.get(o);
        return result == null ? 0 : result;
    }

    @Override
    public boolean remove(Object o) {
        Object t = o;
        Integer oldCount = this.map.remove(t);
        if (oldCount != null && oldCount != 1) {
            this.map.put(t, oldCount - 1);
        }
        if (oldCount != null) {
            if (this.size.get() == 0) {
                throw new RuntimeException("Internal error: size==0 although we just think we found an element that we rmeoved: " + o);
            }
            this.size.decrementAndGet();
        }
        return oldCount != null;
    }

    @Override
    public boolean add(T e) {
        Integer oldCount = this.map.put(e, 1);
        if (oldCount != null && oldCount != 0) {
            this.map.put(e, oldCount + 1);
        }
        this.size.incrementAndGet();
        return true;
    }

    @Override
    public java.util.Iterator<T> iterator() {
        return new Iterator();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ConcurrentHashBag && this.map.equals(((ConcurrentHashBag)o).map);
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private class Iterator
    implements java.util.Iterator<T> {
        private final java.util.Iterator<Map.Entry<T, Integer>> iter;
        private int howManyMore;
        private boolean canRemove;
        private T lastElementOfWhichWeHaveMore;

        private Iterator() {
            this.iter = ConcurrentHashBag.this.map.entrySet().iterator();
            this.howManyMore = 0;
        }

        @Override
        public boolean hasNext() {
            return this.howManyMore > 0 || this.iter.hasNext();
        }

        @Override
        public T next() {
            Object result;
            if (this.howManyMore > 0) {
                result = this.lastElementOfWhichWeHaveMore;
                --this.howManyMore;
            } else {
                Map.Entry next = this.iter.next();
                this.howManyMore = next.getValue() - 1;
                this.lastElementOfWhichWeHaveMore = next.getKey();
                result = next.getKey();
            }
            this.canRemove = true;
            return result;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException("Can't remove through iterator without calling next");
            }
            ConcurrentHashBag.this.remove(this.lastElementOfWhichWeHaveMore);
            this.canRemove = false;
        }
    }
}

