/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.util;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.domain.tracking.impl.WindWithConfidenceImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import smile.sort.QuickSelect;

public class WindUtil {
    private WindUtil() {
    }

    public static List<WindWithConfidence<Void>> getWindFixesWithFixedConfidence(List<WindWithConfidence<Void>> windFixes, double fixedConfidence) {
        ArrayList<WindWithConfidence<Void>> result = new ArrayList<WindWithConfidence<Void>>();
        for (WindWithConfidence<Void> windWithConfidence : windFixes) {
            WindWithConfidenceImpl newWindWithConfidence = new WindWithConfidenceImpl((Wind)windWithConfidence.getObject(), fixedConfidence, (Object)((Void)windWithConfidence.getRelativeTo()), windWithConfidence.useSpeed());
            result.add((WindWithConfidence<Void>)newWindWithConfidence);
        }
        return result;
    }

    public static List<WindWithConfidence<Util.Pair<Position, TimePoint>>> getWindFixesWithMedianTws(List<WindWithConfidence<Util.Pair<Position, TimePoint>>> windFixes) {
        if (windFixes.size() <= 1) {
            return windFixes;
        }
        double[] windSpeedsInKnots = new double[windFixes.size()];
        int i = 0;
        int zerosCount = 0;
        for (WindWithConfidence<Util.Pair<Position, TimePoint>> windFix : windFixes) {
            double windSpeedInKnots = ((Wind)windFix.getObject()).getKnots();
            if (windSpeedInKnots > 0.0) {
                windSpeedsInKnots[i++] = ((Wind)windFix.getObject()).getKnots();
                continue;
            }
            ++zerosCount;
        }
        if (zerosCount == windSpeedsInKnots.length) {
            return windFixes;
        }
        if (zerosCount > 0) {
            windSpeedsInKnots = Arrays.copyOfRange(windSpeedsInKnots, 0, windSpeedsInKnots.length - zerosCount);
        }
        double avgWindSpeedInKnots = windSpeedsInKnots.length == 1 ? windSpeedsInKnots[0] : QuickSelect.median((double[])windSpeedsInKnots);
        ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>> result = new ArrayList<WindWithConfidence<Util.Pair<Position, TimePoint>>>();
        for (WindWithConfidence<Util.Pair<Position, TimePoint>> windFix : windFixes) {
            Wind wind = (Wind)windFix.getObject();
            WindWithConfidenceImpl newWindFix = new WindWithConfidenceImpl((Wind)new WindImpl(wind.getPosition(), wind.getTimePoint(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(avgWindSpeedInKnots, wind.getBearing())), windFix.getConfidence(), (Object)((Util.Pair)windFix.getRelativeTo()), avgWindSpeedInKnots > 0.0);
            result.add((WindWithConfidence<Util.Pair<Position, TimePoint>>)newWindFix);
        }
        return result;
    }
}

