/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model.store;

import com.mongodb.MongoException;
import com.mongodb.MongoGridFSException;
import com.mongodb.MongoQueryException;
import com.mongodb.ReadConcern;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.exception.ModelNotFoundException;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.AbstractModelStoreImpl;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelSerializationStrategy;
import com.sap.sailing.windestimation.model.store.PersistableModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class MongoDbModelStoreImpl
extends AbstractModelStoreImpl {
    private static final Logger logger = Logger.getLogger(MongoDbModelStoreImpl.class.getName());
    private final MongoDatabase db;

    public MongoDbModelStoreImpl(MongoDatabase db) {
        this.db = db;
    }

    @Override
    public <InstanceType, T extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, T>> ModelType loadModel(ModelType newModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(newModel);
        String fileName = this.getPersistenceKey(newModel);
        String bucketName = MongoDbModelStoreImpl.getCollectionName(((ModelContext)newModel.getModelContext()).getDomainType());
        GridFSBucket gridFs = GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName).withReadConcern(ReadConcern.MAJORITY);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (GridFSDownloadStream inputStream = gridFs.openDownloadStream(fileName);){
                Object requestedModelContext = newModel.getModelContext();
                TrainableModel loadedModel = (TrainableModel)serializationStrategy.deserializeFromStream((InputStream)inputStream);
                Object loadedModelContext = loadedModel.getModelContext();
                this.verifyRequestedModelContextIsLoaded((ModelContext<?>)requestedModelContext, loadedModelContext);
                return (ModelType)loadedModel;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (MongoException e) {
            throw new ModelNotFoundException((ModelContext<?>)newModel.getModelContext(), (Throwable)e);
        }
    }

    @Override
    public void persistModel(PersistableModel<?, ?> trainedModel) throws ModelPersistenceException {
        ModelSerializationStrategy serializationStrategy = this.checkAndGetModelSerializationStrategy(trainedModel);
        String newFileName = this.getPersistenceKey(trainedModel);
        String bucketName = MongoDbModelStoreImpl.getCollectionName(((ModelContext)trainedModel.getModelContext()).getDomainType());
        GridFSBucket gridFs = GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName).withWriteConcern(WriteConcern.MAJORITY);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (GridFSUploadStream outputStream = gridFs.openUploadStream(newFileName);){
                serializationStrategy.serializeToStream(trainedModel, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ModelPersistenceException(e);
        }
    }

    @Override
    public void deleteAll(ModelDomainType domainType) throws ModelPersistenceException {
        try {
            GridFSBuckets.create((MongoDatabase)this.db, (String)MongoDbModelStoreImpl.getCollectionName(domainType)).withWriteConcern(WriteConcern.MAJORITY).drop();
        }
        catch (Exception e) {
            throw new ModelPersistenceException(e);
        }
    }

    public static String getCollectionName(ModelDomainType domainType) {
        return "modelFor" + domainType.getDomainName();
    }

    @Override
    public Map<String, byte[]> exportAllPersistedModels(ModelDomainType domainType) throws ModelPersistenceException {
        HashMap<String, byte[]> exportedModels = new HashMap<String, byte[]>();
        String bucketName = MongoDbModelStoreImpl.getCollectionName(domainType);
        GridFSBucket gridFs = GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName).withReadConcern(ReadConcern.MAJORITY);
        for (GridFSFile gridFSFile : gridFs.find()) {
            byte[] exportedModel;
            String fileName = gridFSFile.getFilename();
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (GridFSDownloadStream downloadStream = gridFs.openDownloadStream(fileName);){
                    exportedModel = IOUtils.toByteArray((InputStream)downloadStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ModelPersistenceException("Could not read model \"" + fileName + "\" from MongoDB", e);
            }
            exportedModels.put(fileName, exportedModel);
        }
        return exportedModels;
    }

    @Override
    public void importPersistedModels(Map<String, byte[]> exportedPersistedModels, ModelDomainType domainType) throws ModelPersistenceException {
        String bucketName = MongoDbModelStoreImpl.getCollectionName(domainType);
        GridFSBucket gridFs = GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName).withWriteConcern(WriteConcern.MAJORITY);
        for (Map.Entry<String, byte[]> entry : exportedPersistedModels.entrySet()) {
            String fileName = entry.getKey();
            byte[] exportedModel = entry.getValue();
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (GridFSUploadStream outputStream = gridFs.openUploadStream(fileName);){
                    outputStream.write(exportedModel);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new ModelPersistenceException("Could not store model \"" + fileName + "\" in MongoDB", e);
            }
        }
    }

    @Override
    public List<PersistableModel<?, ?>> loadAllPersistedModels(ModelDomainType domainType) {
        ArrayList loadedModels = new ArrayList();
        String bucketName = MongoDbModelStoreImpl.getCollectionName(domainType);
        GridFSBucket gridFs = GridFSBuckets.create((MongoDatabase)this.db, (String)bucketName).withReadConcern(ReadConcern.MAJORITY);
        try {
            for (GridFSFile gridFSFile : gridFs.find()) {
                String fileName = gridFSFile.getFilename();
                ModelSerializationStrategy serializationStrategy = this.getModelSerializationStrategyFromPersistenceKey(fileName);
                if (serializationStrategy == null) {
                    throw new ModelLoadingException("Persistence support could not be determined due to invalid filename pattern: \"" + fileName + "\"");
                }
                try {
                    PersistableModel<?, ?> loadedModel;
                    try {
                        Throwable throwable = null;
                        Object var11_15 = null;
                        try (GridFSDownloadStream downloadStream = gridFs.openDownloadStream(fileName);){
                            loadedModel = serializationStrategy.deserializeFromStream((InputStream)downloadStream);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        throw new ModelLoadingException("Could not read model \"" + fileName + "\" from MongoDB", e);
                    }
                    loadedModels.add(loadedModel);
                }
                catch (MongoGridFSException e) {
                    logger.severe("Couldn't load file " + fileName + " while loading persistent models of type " + (Object)((Object)domainType) + " although the directory listing of bucket " + bucketName + " said it should be there. Ignoring. Model may be incomplete." + " If this happens while launching a replica, don't worry... the initial load from the master will fix this.");
                }
            }
        }
        catch (MongoQueryException mqe) {
            logger.severe("Couldn't list next file of bucket " + bucketName + " while loading persistent models of type " + (Object)((Object)domainType) + ". Ignoring. Model may be incomplete." + " If this happens while launching a replica, don't worry... the initial load from the master will fix this.");
        }
        return loadedModels;
    }
}

