/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.integration;

import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.windestimation.IncrementalWindEstimation;
import com.sap.sailing.domain.windestimation.WindEstimationFactoryService;
import com.sap.sailing.windestimation.integration.ExportedModels;
import com.sap.sailing.windestimation.integration.IncrementalMstHmmWindEstimationForTrackedRace;
import com.sap.sailing.windestimation.integration.ReplicableWindEstimationFactoryService;
import com.sap.sailing.windestimation.integration.WindEstimationModelsUpdateOperation;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverClassifiersCache;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverFeatures;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.regressor.twdtransition.GaussianBasedTwdTransitionDistributionCache;
import com.sap.sailing.windestimation.model.store.InMemoryModelStoreImpl;
import com.sap.sailing.windestimation.model.store.ModelDomainType;
import com.sap.sailing.windestimation.model.store.ModelStore;
import com.sap.sailing.windestimation.model.store.MongoDbModelStoreImpl;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WindEstimationFactoryServiceImpl
extends AbstractReplicableWithObjectInputStream<ReplicableWindEstimationFactoryService, WindEstimationModelsUpdateOperation>
implements ReplicableWindEstimationFactoryService {
    private static final boolean PRELOAD_ALL_MODELS = true;
    private static final boolean ENABLE_MARKS_INFORMATION = false;
    private static final boolean ENABLE_SCALED_SPEED = false;
    private static final boolean ENABLE_POLARS_INFORMATION = true;
    private static final long PRESERVE_LOADED_MODELS_MILLIS = Long.MAX_VALUE;
    private static final ManeuverFeatures MAX_MANEUVER_FEATURES = new ManeuverFeatures(true, false, false);
    public static final ModelDomainType[] modelDomainTypesRequiredByWindEstimation = new ModelDomainType[]{ModelDomainType.MANEUVER_CLASSIFIER, ModelDomainType.DURATION_BASED_TWD_DELTA_STD_REGRESSOR, ModelDomainType.DISTANCE_BASED_TWD_DELTA_STD_REGRESSOR};
    public final ModelStore MODEL_STORE;
    protected final ManeuverClassifiersCache maneuverClassifiersCache;
    protected final GaussianBasedTwdTransitionDistributionCache gaussianBasedTwdTransitionDistributionCache;
    private final List<WindEstimationFactoryService.WindEstimationModelsChangedListener> modelsChangedListeners = new ArrayList<WindEstimationFactoryService.WindEstimationModelsChangedListener>();
    private boolean modelsReady = false;
    private boolean shutdown = false;

    public WindEstimationFactoryServiceImpl() {
        this.MODEL_STORE = this.isMaster() ? new MongoDbModelStoreImpl(MongoDBService.INSTANCE.getDB()) : new InMemoryModelStoreImpl();
        this.maneuverClassifiersCache = new ManeuverClassifiersCache(this.MODEL_STORE, true, Long.MAX_VALUE, MAX_MANEUVER_FEATURES);
        this.gaussianBasedTwdTransitionDistributionCache = new GaussianBasedTwdTransitionDistributionCache(this.MODEL_STORE, true, Long.MAX_VALUE);
        this.modelsReady = this.maneuverClassifiersCache.isReady() && this.gaussianBasedTwdTransitionDistributionCache.isReady();
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstCache<Object>(is, new Object(), null, classLoaderCache){};
    }

    private boolean isMaster() {
        return this.getMasterDescriptor() == null;
    }

    public IncrementalWindEstimation createIncrementalWindEstimationTrack(TrackedRace trackedRace) {
        IncrementalMstHmmWindEstimationForTrackedRace windEstimation = new IncrementalMstHmmWindEstimationForTrackedRace(trackedRace, (WindSource)new WindSourceImpl(WindSourceType.MANEUVER_BASED_ESTIMATION), trackedRace.getPolarDataService(), trackedRace.getMillisecondsOverWhichToAverageWind(), this.maneuverClassifiersCache, this.gaussianBasedTwdTransitionDistributionCache);
        return windEstimation;
    }

    public synchronized boolean isReady() {
        return this.modelsReady;
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        ExportedModels exportedModels = (ExportedModels)is.readObject();
        this.updateWindEstimationModels(exportedModels);
    }

    @Override
    public void updateWindEstimationModels(ExportedModels exportedModels) throws ModelPersistenceException {
        ModelDomainType[] modelDomainTypeArray = modelDomainTypesRequiredByWindEstimation;
        int n = modelDomainTypesRequiredByWindEstimation.length;
        int n2 = 0;
        while (n2 < n) {
            ModelDomainType domainType = modelDomainTypeArray[n2];
            Map<String, byte[]> serializedModelsForDomainType = exportedModels.getSerializedModelsForDomainType(domainType);
            if (serializedModelsForDomainType != null) {
                this.MODEL_STORE.deleteAll(domainType);
                this.MODEL_STORE.importPersistedModels(serializedModelsForDomainType, domainType);
            }
            ++n2;
        }
        this.reloadWindEstimationModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindEstimationModelsChangedListenerAndReceiveUpdate(WindEstimationFactoryService.WindEstimationModelsChangedListener listener) {
        boolean modelsReady;
        WindEstimationFactoryServiceImpl windEstimationFactoryServiceImpl = this;
        synchronized (windEstimationFactoryServiceImpl) {
            this.modelsChangedListeners.add(listener);
            modelsReady = this.modelsReady;
        }
        listener.modelsChangedEvent(modelsReady);
    }

    public synchronized void removeWindEstimationModelsChangedListener(WindEstimationFactoryService.WindEstimationModelsChangedListener listener) {
        this.modelsChangedListeners.remove(listener);
    }

    public synchronized void removeAllWindEstimationModelsChangedListeners() {
        this.modelsChangedListeners.clear();
    }

    private void notifyModelsChangedListeners(List<WindEstimationFactoryService.WindEstimationModelsChangedListener> modelsChangedListeners, boolean modelsReady) {
        for (WindEstimationFactoryService.WindEstimationModelsChangedListener listener : modelsChangedListeners) {
            listener.modelsChangedEvent(modelsReady);
        }
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
        ExportedModels exportedModels = new ExportedModels();
        ModelDomainType[] modelDomainTypeArray = modelDomainTypesRequiredByWindEstimation;
        int n = modelDomainTypesRequiredByWindEstimation.length;
        int n2 = 0;
        while (n2 < n) {
            ModelDomainType domainType = modelDomainTypeArray[n2];
            Map<String, byte[]> exportedModelsForDomainType = this.MODEL_STORE.exportAllPersistedModels(domainType);
            exportedModels.addSerializedModelsForDomainType(domainType, exportedModelsForDomainType);
            ++n2;
        }
        objectOutputStream.writeObject(exportedModels);
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        ModelDomainType[] modelDomainTypeArray = modelDomainTypesRequiredByWindEstimation;
        int n = modelDomainTypesRequiredByWindEstimation.length;
        int n2 = 0;
        while (n2 < n) {
            ModelDomainType domainType = modelDomainTypeArray[n2];
            this.MODEL_STORE.deleteAll(domainType);
            ++n2;
        }
        this.reloadWindEstimationModels();
    }

    public void clearState() throws Exception {
        this.clearReplicaState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadWindEstimationModels() {
        List<WindEstimationFactoryService.WindEstimationModelsChangedListener> modelsChangedListeners;
        boolean modelsReady;
        this.maneuverClassifiersCache.clearCache();
        this.gaussianBasedTwdTransitionDistributionCache.clearCache();
        WindEstimationFactoryServiceImpl windEstimationFactoryServiceImpl = this;
        synchronized (windEstimationFactoryServiceImpl) {
            modelsReady = !this.shutdown && this.maneuverClassifiersCache.isReady() && this.gaussianBasedTwdTransitionDistributionCache.isReady();
            modelsChangedListeners = this.modelsChangedListeners;
            this.modelsReady = modelsReady;
        }
        this.notifyModelsChangedListeners(modelsChangedListeners, modelsReady);
    }

    public void importAllModelsFromModelStore(ModelStore modelStore) throws ModelPersistenceException {
        ModelDomainType[] modelDomainTypeArray = modelDomainTypesRequiredByWindEstimation;
        int n = modelDomainTypesRequiredByWindEstimation.length;
        int n2 = 0;
        while (n2 < n) {
            ModelDomainType domainType = modelDomainTypeArray[n2];
            Map<String, byte[]> exportedModels = modelStore.exportAllPersistedModels(domainType);
            this.MODEL_STORE.deleteAll(domainType);
            this.MODEL_STORE.importPersistedModels(exportedModels, domainType);
            ++n2;
        }
        this.reloadWindEstimationModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        List<WindEstimationFactoryService.WindEstimationModelsChangedListener> modelsChangedListeners;
        WindEstimationFactoryServiceImpl windEstimationFactoryServiceImpl = this;
        synchronized (windEstimationFactoryServiceImpl) {
            this.modelsReady = false;
            this.shutdown = true;
            modelsChangedListeners = this.modelsChangedListeners;
        }
        this.notifyModelsChangedListeners(modelsChangedListeners, false);
        this.removeAllWindEstimationModelsChangedListeners();
    }
}

