/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.data;

import com.sap.sailing.windestimation.data.CompetitorTrackWithEstimationData;
import com.sap.sailing.windestimation.data.WindQuality;
import java.util.List;

public class RaceWithEstimationData<T> {
    private final String regattaName;
    private final String raceName;
    private final List<CompetitorTrackWithEstimationData<T>> competitorTracks;
    private final WindQuality windQuality;

    public RaceWithEstimationData(String regattaName, String raceName, WindQuality windQuality, List<CompetitorTrackWithEstimationData<T>> competitorTracks) {
        this.regattaName = regattaName;
        this.raceName = raceName;
        this.windQuality = windQuality;
        this.competitorTracks = competitorTracks;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public List<CompetitorTrackWithEstimationData<T>> getCompetitorTracks() {
        return this.competitorTracks;
    }

    public String getRegattaName() {
        return this.regattaName;
    }

    public <S> RaceWithEstimationData<S> constructWithElements(List<CompetitorTrackWithEstimationData<S>> elements) {
        RaceWithEstimationData<T> newRace = new RaceWithEstimationData<T>(this.getRegattaName(), this.getRaceName(), this.getWindQuality(), elements);
        return newRace;
    }

    public WindQuality getWindQuality() {
        return this.windQuality;
    }
}

