/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.hmm;

import com.sap.sailing.windestimation.aggregator.hmm.BestNodeInfo;
import com.sap.sailing.windestimation.aggregator.hmm.GraphLevelBase;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;

public abstract class AbstractBestPathsPerLevel<GL extends GraphLevelBase<GL>> {
    public abstract BestNodeInfo getBestPreviousNodeInfo(GraphNode<GL> var1);

    public abstract GL getCurrentLevel();

    protected abstract BestNodeInfo[] getPreviousNodeInfosPerManeuverNode();

    public double getProbabilitiesFromStartSum() {
        double probabilitiesFromStartSum = 0.0;
        BestNodeInfo[] bestNodeInfoArray = this.getPreviousNodeInfosPerManeuverNode();
        int n = bestNodeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            BestNodeInfo bestNodeInfo = bestNodeInfoArray[n2];
            probabilitiesFromStartSum += bestNodeInfo.getProbabilityFromStart();
            ++n2;
        }
        return probabilitiesFromStartSum;
    }

    public double getNormalizedProbabilityToNodeFromStart(GraphNode<GL> currentNode) {
        return this.getBestPreviousNodeInfo(currentNode).getProbabilityFromStart() / this.getProbabilitiesFromStartSum();
    }

    public boolean isBackwardProbabilitiesComputed() {
        return this.getBackwardProbabilitiesSum() > 0.0;
    }

    public double getBackwardProbabilitiesSum() {
        double sumBackwardProbabilities = 0.0;
        BestNodeInfo[] bestNodeInfoArray = this.getPreviousNodeInfosPerManeuverNode();
        int n = bestNodeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            BestNodeInfo nodeInfo = bestNodeInfoArray[n2];
            sumBackwardProbabilities += nodeInfo.getBackwardProbability();
            ++n2;
        }
        return sumBackwardProbabilities;
    }

    public double getForwardProbabilitiesSum() {
        double sumForwardProbabilities = 0.0;
        BestNodeInfo[] bestNodeInfoArray = this.getPreviousNodeInfosPerManeuverNode();
        int n = bestNodeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            BestNodeInfo nodeInfo = bestNodeInfoArray[n2];
            sumForwardProbabilities += nodeInfo.getForwardProbability();
            ++n2;
        }
        return sumForwardProbabilities;
    }

    public double getNormalizedForwardProbability(GraphNode<GL> currentNode) {
        return this.getBestPreviousNodeInfo(currentNode).getForwardProbability() / this.getForwardProbabilitiesSum();
    }

    public double getNormalizedBackwardProbability(GraphNode<GL> currentNode) {
        return this.getBestPreviousNodeInfo(currentNode).getBackwardProbability() / this.getBackwardProbabilitiesSum();
    }

    public double getNormalizedForwardBackwardProbability(GraphNode<GL> currentNode) {
        double sumForwardBackwardProbabilities = 0.0;
        double currentNodeForwardBackwardProbability = -1.0;
        for (GraphNode node : ((GraphLevelBase)this.getCurrentLevel()).getLevelNodes()) {
            double forwardBackwardProbability = this.getNormalizedForwardProbability(node) * this.getNormalizedBackwardProbability(node);
            sumForwardBackwardProbabilities += forwardBackwardProbability;
            if (node != currentNode) continue;
            currentNodeForwardBackwardProbability = forwardBackwardProbability;
        }
        if (currentNodeForwardBackwardProbability < 0.0) {
            throw new IllegalArgumentException();
        }
        return currentNodeForwardBackwardProbability / sumForwardBackwardProbabilities;
    }
}

