/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.clustering;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.confidence.impl.ScalableDouble;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.polars.windestimation.AbstractManeuverBasedWindEstimationTrackImpl;
import com.sap.sailing.polars.windestimation.ManeuverClassification;
import com.sap.sailing.polars.windestimation.ScalableBearingAndScalableDouble;
import com.sap.sailing.windestimation.aggregator.clustering.ManeuverClassificationForClusteringImpl;
import com.sap.sailing.windestimation.data.CompetitorTrackWithEstimationData;
import com.sap.sailing.windestimation.data.RaceWithEstimationData;
import com.sap.sailing.windestimation.model.classifier.maneuver.ManeuverWithProbabilisticTypeClassification;
import com.sap.sailing.windestimation.model.exception.ModelOperationException;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import com.sap.sse.util.kmeans.Cluster;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;

public class ManeuverClusteringBasedWindEstimationTrackImpl
extends AbstractManeuverBasedWindEstimationTrackImpl {
    private static final long serialVersionUID = 3474387111725677525L;
    private final RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuvers;
    private final PolarDataService polarService;

    public ManeuverClusteringBasedWindEstimationTrackImpl(RaceWithEstimationData<ManeuverWithProbabilisticTypeClassification> raceWithManeuvers, BoatClass boatClass, PolarDataService polarService, long millisecondsOverWhichToAverage) {
        super(raceWithManeuvers.getRaceName(), boatClass, millisecondsOverWhichToAverage);
        this.raceWithManeuvers = raceWithManeuvers;
        this.polarService = polarService;
    }

    protected double getLikelihoodOfBeingTackCluster(Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble> cluster, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters) {
        double result;
        double averageTackLikelihood = this.getAverageLikelihoodOfBeingManeuver(ManeuverType.TACK, cluster.stream());
        Bearing upwindCog = (Bearing)this.getWeightedAverageMiddleManeuverCOGDegAndManeuverAngleDeg(cluster, ManeuverType.TACK).getA();
        if (upwindCog == null) {
            return 0.1;
        }
        Bearing averageUpwindCOG = new ScalableBearing(upwindCog).divide(1.0);
        Bearing approximateMiddleCOGForJibes = averageUpwindCOG.reverse();
        Stream jibeClusters = this.getJibeClusters(approximateMiddleCOGForJibes, clusters);
        Speed tackClusterWeightedAverageSpeed = this.getWeightedAverageSpeed(cluster.stream(), ManeuverType.TACK);
        if (tackClusterWeightedAverageSpeed != null) {
            double jibeClusterLikelihood = this.getLikelihoodOfBeingJibeCluster(tackClusterWeightedAverageSpeed, jibeClusters.map(jc -> jc.stream()).reduce(Stream::concat).orElse(Stream.empty()), this.getBoatClass(), clusters);
            result = averageTackLikelihood * (1.0 + 0.2 * jibeClusterLikelihood) / 1.2;
        } else {
            result = 0.1;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected double getLikelihoodOfBeingJibeCluster(Speed tackClusterWeightedAverageSpeed, Stream<ManeuverClassification> jibeClustersContent, BoatClass boatClass, Set<Cluster<ManeuverClassification, Util.Pair<ScalableBearing, ScalableDouble>, Util.Pair<Bearing, Double>, ScalableBearingAndScalableDouble>> clusters) {
        int[] count = new int[1];
        double[] likelihoodSum = new double[1];
        Stream<ManeuverClassification> jibeClustersContentPeeker = jibeClustersContent.peek(mc -> {
            nArray[0] = count[0] + 1;
            double likelihood = mc.getLikelihoodForManeuverType(ManeuverType.JIBE);
            dArray[0] = likelihoodSum[0] + likelihood;
        });
        Speed jibeClusterWeightedAverageSpeed = this.getWeightedAverageSpeed(jibeClustersContentPeeker, ManeuverType.JIBE);
        if (jibeClusterWeightedAverageSpeed == null) return 0.1;
        double tackJibeSpeedRatioLikelihood = this.polarService.getConfidenceForTackJibeSpeedRatio(tackClusterWeightedAverageSpeed, jibeClusterWeightedAverageSpeed, boatClass);
        if (count[0] <= 0) throw new ModelOperationException("Internal error: no maneuvers in jibe cluster candidate but still a valid weighted average speed " + jibeClusterWeightedAverageSpeed);
        double averageJibeLikelihood = likelihoodSum[0] / (double)count[0];
        return Math.min(1.0, averageJibeLikelihood * (1.0 + 0.0 * tackJibeSpeedRatioLikelihood));
    }

    protected Stream<ManeuverClassification> getManeuverClassifications() {
        ArrayList<ManeuverClassificationForClusteringImpl> maneuverClassifications = new ArrayList<ManeuverClassificationForClusteringImpl>();
        for (CompetitorTrackWithEstimationData<ManeuverWithProbabilisticTypeClassification> competitorTrack : this.raceWithManeuvers.getCompetitorTracks()) {
            for (ManeuverWithProbabilisticTypeClassification maneuver : competitorTrack.getElements()) {
                ManeuverClassificationForClusteringImpl maneuverClassification = new ManeuverClassificationForClusteringImpl(maneuver, competitorTrack.getCompetitorName(), this.polarService);
                maneuverClassifications.add(maneuverClassification);
            }
        }
        return maneuverClassifications.stream();
    }
}

