/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.nmeaconnector.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.tracking.WindListener;
import com.sap.sailing.nmeaconnector.NmeaFactory;
import com.sap.sailing.nmeaconnector.NmeaUtil;
import com.sap.sailing.nmeaconnector.impl.NMEAWindReceiverImpl;
import com.sap.sailing.nmeaconnector.impl.NmeaUtilImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import net.sf.marineapi.nmea.event.AbstractSentenceListener;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.sentence.Sentence;

public class NmeaFactoryImpl
implements NmeaFactory {
    @Override
    public NmeaUtil getUtil() {
        return new NmeaUtilImpl();
    }

    @Override
    public Iterable<Wind> readWind(InputStream inputStream) throws InterruptedException {
        final CountDownLatch finishedLatch = new CountDownLatch(1);
        final ArrayList<Wind> result = new ArrayList<Wind>();
        SentenceReader sentenceReader = new SentenceReader(inputStream);
        sentenceReader.addSentenceListener((SentenceListener)new AbstractSentenceListener<Sentence>(){

            public void readingStopped() {
                finishedLatch.countDown();
            }

            public void sentenceRead(Sentence sentence) {
            }
        });
        NMEAWindReceiverImpl receiver = new NMEAWindReceiverImpl(sentenceReader);
        receiver.addWindListener(new WindListener(){

            public void windDataReceived(Wind wind) {
                result.add(wind);
            }

            public void windDataRemoved(Wind wind) {
            }

            public void windAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
            }
        });
        sentenceReader.start();
        finishedLatch.await();
        return result;
    }
}

