/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.nmeaconnector.impl;

import com.sap.sailing.declination.Declination;
import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.MeterPerSecondSpeedImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableBearing;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableSpeedWithBearing;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixImpl;
import com.sap.sailing.domain.tracking.DynamicTrack;
import com.sap.sailing.domain.tracking.WindListener;
import com.sap.sailing.domain.tracking.impl.DynamicTrackImpl;
import com.sap.sailing.nmeaconnector.NMEAWindReceiver;
import com.sap.sailing.nmeaconnector.TimedBearing;
import com.sap.sailing.nmeaconnector.TimedSpeedWithBearing;
import com.sap.sailing.nmeaconnector.impl.DegreeBearingWithTimepoint;
import com.sap.sailing.nmeaconnector.impl.KnotSpeedWithBearingAndTimepoint;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.text.ParseException;
import java.time.ZoneId;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.marineapi.nmea.event.AbstractSentenceListener;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.sentence.DateSentence;
import net.sf.marineapi.nmea.sentence.HeadingSentence;
import net.sf.marineapi.nmea.sentence.MDASentence;
import net.sf.marineapi.nmea.sentence.MWDSentence;
import net.sf.marineapi.nmea.sentence.MWVSentence;
import net.sf.marineapi.nmea.sentence.PositionSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TimeSentence;
import net.sf.marineapi.nmea.sentence.VTGSentence;
import net.sf.marineapi.nmea.sentence.VWRSentence;
import net.sf.marineapi.nmea.util.CompassPoint;
import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.Direction;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.nmea.util.Units;

public class NMEAWindReceiverImpl
implements NMEAWindReceiver {
    private static final Logger logger = Logger.getLogger(NMEAWindReceiverImpl.class.getName());
    private final ConcurrentHashMap<WindListener, WindListener> listeners;
    private final DynamicTrack<TimedSpeedWithBearing> trueWind;
    private final DynamicTrack<TimedSpeedWithBearing> apparentWind;
    private final DynamicTrack<GPSFix> sensorPositions;
    private final DynamicTrack<TimedSpeedWithBearing> sensorSpeeds;
    private final DynamicTrack<TimedBearing> trueHeadings;
    private final GregorianCalendar utcCalendar;
    private final DeclinationService declinationService = DeclinationService.INSTANCE;
    private boolean dateReceived;
    private boolean timeReceived;

    public NMEAWindReceiverImpl(SentenceReader sentenceReader) {
        this.utcCalendar = new GregorianCalendar();
        this.utcCalendar.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        this.listeners = new ConcurrentHashMap();
        this.trueWind = new DynamicTrackImpl("trueWind in " + this.getClass().getName());
        this.apparentWind = new DynamicTrackImpl("apparentWind in " + this.getClass().getName());
        this.sensorPositions = new DynamicTrackImpl("measurementPositions in " + this.getClass().getName());
        this.sensorSpeeds = new DynamicTrackImpl("sensorSpeeds in " + this.getClass().getName());
        this.trueHeadings = new DynamicTrackImpl("trueHeadings in " + this.getClass().getName());
        sentenceReader.addSentenceListener((SentenceListener)new MWVSentenceListener(), SentenceId.MWV);
        sentenceReader.addSentenceListener((SentenceListener)new MWDSentenceListener(), SentenceId.MWD);
        sentenceReader.addSentenceListener((SentenceListener)new VWRSentenceListener(), SentenceId.VWR);
        sentenceReader.addSentenceListener((SentenceListener)new MDASentenceListener(), SentenceId.MDA);
        sentenceReader.addSentenceListener((SentenceListener)new VTGSentenceListener(), SentenceId.VTG);
        sentenceReader.addSentenceListener((SentenceListener)new HeadingSentenceListener());
        sentenceReader.addSentenceListener((SentenceListener)new DateListener());
        sentenceReader.addSentenceListener((SentenceListener)new TimeListener());
        sentenceReader.addSentenceListener((SentenceListener)new PositionListener());
    }

    private Speed createSpeed(Units speedUnit, double amount) {
        KilometersPerHourSpeedImpl result;
        switch (speedUnit) {
            case KMH: {
                result = new KilometersPerHourSpeedImpl(amount);
                break;
            }
            case KNOT: {
                result = new KnotSpeedImpl(amount);
                break;
            }
            case METER: {
                result = new MeterPerSecondSpeedImpl(amount);
                break;
            }
            default: {
                throw new RuntimeException("Unknown speed unit: " + speedUnit);
            }
        }
        return result;
    }

    private void tryToCreateWindFixFromTrueWind(TimedSpeedWithBearing trueWind) {
        Position position = this.getPosition(trueWind.getTimePoint());
        if (position != null) {
            WindImpl wind = new WindImpl(position, trueWind.getTimePoint(), (SpeedWithBearing)trueWind);
            this.notifyListeners((Wind)wind);
        }
    }

    private void tryToCreateWindFixFromApparentWind(TimedSpeedWithBearing apparentWind) {
        Bearing trueHeading;
        SpeedWithBearing sensorSpeed;
        Position position = this.getPosition(apparentWind.getTimePoint());
        if (position != null && (sensorSpeed = (SpeedWithBearing)this.sensorSpeeds.getInterpolatedValue(this.getLastTimePoint(), fix -> new ScalableSpeedWithBearing((SpeedWithBearing)fix))) != null && (trueHeading = (Bearing)this.trueHeadings.getInterpolatedValue(this.getLastTimePoint(), fix -> new ScalableBearing((Bearing)fix))) != null) {
            KnotSpeedWithBearingImpl apparentWindTrue = new KnotSpeedWithBearingImpl(apparentWind.getKnots(), apparentWind.getBearing().add(trueHeading));
            SpeedWithBearing trueWind = apparentWindTrue.add(sensorSpeed);
            WindImpl wind = new WindImpl(position, apparentWind.getTimePoint(), trueWind);
            this.notifyListeners((Wind)wind);
        }
    }

    private TimePoint getLastTimePoint() {
        MillisecondsTimePoint result = this.dateReceived && this.timeReceived ? new MillisecondsTimePoint(this.utcCalendar.getTime()) : null;
        return result;
    }

    private Position getPosition(TimePoint timePoint) {
        return (Position)this.sensorPositions.getInterpolatedValue(timePoint, gpsFix -> new ScalablePosition(gpsFix.getPosition()));
    }

    @Override
    public void addWindListener(WindListener listener) {
        this.listeners.put(listener, listener);
    }

    @Override
    public void removeWindListener(WindListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(Wind wind) {
        for (WindListener listener : this.listeners.values()) {
            listener.windDataReceived(wind);
        }
    }

    private class DateListener
    extends AbstractSentenceListener<DateSentence> {
        private DateListener() {
        }

        public void sentenceRead(DateSentence sentence) {
            try {
                Date date = sentence.getDate();
                NMEAWindReceiverImpl.this.utcCalendar.set(date.getYear(), date.getMonth() - 1, date.getDay());
                NMEAWindReceiverImpl.this.dateReceived = true;
            }
            catch (IllegalArgumentException | DataNotAvailableException throwable) {
                // empty catch block
            }
        }
    }

    private class HeadingSentenceListener
    extends AbstractSentenceListener<HeadingSentence> {
        private HeadingSentenceListener() {
        }

        public void sentenceRead(HeadingSentence sentence) {
            if (NMEAWindReceiverImpl.this.getLastTimePoint() != null) {
                if (sentence.isTrue()) {
                    try {
                        NMEAWindReceiverImpl.this.trueHeadings.add((Timed)new DegreeBearingWithTimepoint(NMEAWindReceiverImpl.this.getLastTimePoint(), sentence.getHeading()));
                    }
                    catch (DataNotAvailableException dataNotAvailableException) {}
                } else {
                    Position position = NMEAWindReceiverImpl.this.getPosition(NMEAWindReceiverImpl.this.getLastTimePoint());
                    if (position != null) {
                        try {
                            Declination declination = NMEAWindReceiverImpl.this.declinationService.getDeclination(NMEAWindReceiverImpl.this.getLastTimePoint(), position, 1000L);
                            if (declination != null) {
                                try {
                                    NMEAWindReceiverImpl.this.trueHeadings.add((Timed)new DegreeBearingWithTimepoint(NMEAWindReceiverImpl.this.getLastTimePoint(), new DegreeBearingImpl(sentence.getHeading()).add(declination.getBearingCorrectedTo(NMEAWindReceiverImpl.this.getLastTimePoint())).getDegrees()));
                                }
                                catch (DataNotAvailableException dataNotAvailableException) {}
                            }
                        }
                        catch (IOException | ParseException e) {
                            logger.log(Level.WARNING, "Error trying to obtain magnetic declination while converting magnetic heading to true heading", e);
                        }
                    }
                }
            }
        }
    }

    private class MDASentenceListener
    extends AbstractSentenceListener<MDASentence> {
        private MDASentenceListener() {
        }

        public void sentenceRead(MDASentence sentence) {
            if (!Double.isNaN(sentence.getTrueWindDirection())) {
                if (!Double.isNaN(sentence.getWindSpeed())) {
                    NMEAWindReceiverImpl.this.trueWind.add((Timed)new KnotSpeedWithBearingAndTimepoint(NMEAWindReceiverImpl.this.getLastTimePoint(), new MeterPerSecondSpeedImpl(sentence.getWindSpeed()).getKnots(), (Bearing)new DegreeBearingImpl(sentence.getTrueWindDirection())));
                } else if (!Double.isNaN(sentence.getWindSpeedKnots())) {
                    NMEAWindReceiverImpl.this.trueWind.add((Timed)new KnotSpeedWithBearingAndTimepoint(NMEAWindReceiverImpl.this.getLastTimePoint(), sentence.getWindSpeedKnots(), (Bearing)new DegreeBearingImpl(sentence.getTrueWindDirection())));
                }
            }
        }
    }

    private class MWDSentenceListener
    extends AbstractSentenceListener<MWDSentence> {
        private MWDSentenceListener() {
        }

        public void sentenceRead(MWDSentence sentence) {
            Object speed;
            Position position;
            TimePoint timePoint = NMEAWindReceiverImpl.this.getLastTimePoint();
            if (timePoint != null && (position = NMEAWindReceiverImpl.this.getPosition(timePoint)) != null && (speed = !Double.isNaN(sentence.getWindSpeed()) ? new MeterPerSecondSpeedImpl(sentence.getWindSpeed()) : (!Double.isNaN(sentence.getWindSpeedKnots()) ? new KnotSpeedImpl(sentence.getWindSpeedKnots()) : null)) != null) {
                if (!Double.isNaN(sentence.getTrueWindDirection())) {
                    DegreeBearingImpl direction = new DegreeBearingImpl(sentence.getTrueWindDirection());
                } else {
                    try {
                        Declination declination = NMEAWindReceiverImpl.this.declinationService.getDeclination(timePoint, position, 1000L);
                        Bearing direction = declination != null ? new DegreeBearingImpl(sentence.getMagneticWindDirection()).add(declination.getBearingCorrectedTo(timePoint)) : null;
                        if (direction != null) {
                            KnotSpeedWithBearingAndTimepoint fix = new KnotSpeedWithBearingAndTimepoint(timePoint, speed.getKnots(), direction);
                            NMEAWindReceiverImpl.this.trueWind.add((Timed)fix);
                            NMEAWindReceiverImpl.this.tryToCreateWindFixFromTrueWind(fix);
                        }
                    }
                    catch (IOException | ParseException e) {
                        logger.log(Level.WARNING, "Couldn't correct magnetic TWD reading by declination; ignoring", e);
                    }
                }
            }
        }
    }

    private class MWVSentenceListener
    extends AbstractSentenceListener<MWVSentence> {
        private MWVSentenceListener() {
        }

        public void sentenceRead(MWVSentence sentence) {
            TimePoint timePoint = NMEAWindReceiverImpl.this.getLastTimePoint();
            if (timePoint != null) {
                try {
                    Speed speed = NMEAWindReceiverImpl.this.createSpeed(sentence.getSpeedUnit(), sentence.getSpeed());
                    if (sentence.isTrue()) {
                        Bearing trueHeading = (Bearing)NMEAWindReceiverImpl.this.trueHeadings.getInterpolatedValue(NMEAWindReceiverImpl.this.getLastTimePoint(), f -> new ScalableBearing((Bearing)f));
                        if (trueHeading != null) {
                            KnotSpeedWithBearingAndTimepoint fix = new KnotSpeedWithBearingAndTimepoint(timePoint, speed.getKnots(), new DegreeBearingImpl(sentence.getAngle()).reverse().add(trueHeading));
                            NMEAWindReceiverImpl.this.trueWind.add((Timed)fix);
                            NMEAWindReceiverImpl.this.tryToCreateWindFixFromTrueWind(fix);
                        }
                    } else {
                        KnotSpeedWithBearingAndTimepoint fix = new KnotSpeedWithBearingAndTimepoint(timePoint, speed.getKnots(), new DegreeBearingImpl(sentence.getAngle()).reverse());
                        NMEAWindReceiverImpl.this.apparentWind.add((Timed)fix);
                        NMEAWindReceiverImpl.this.tryToCreateWindFixFromApparentWind(fix);
                    }
                }
                catch (DataNotAvailableException dataNotAvailableException) {
                    // empty catch block
                }
            }
        }
    }

    private class PositionListener
    extends AbstractSentenceListener<PositionSentence> {
        private PositionListener() {
        }

        public void sentenceRead(PositionSentence sentence) {
            if (sentence instanceof TimeSentence) {
                TimeSentence timeSentence = (TimeSentence)sentence;
                new TimeListener().sentenceRead(timeSentence);
                TimePoint timePoint = NMEAWindReceiverImpl.this.getLastTimePoint();
                if (timePoint != null) {
                    try {
                        GPSFixImpl fix = new GPSFixImpl(this.getPosition(sentence), timePoint);
                        NMEAWindReceiverImpl.this.sensorPositions.add((Timed)fix);
                    }
                    catch (DataNotAvailableException dataNotAvailableException) {
                        // empty catch block
                    }
                }
            }
        }

        private Position getPosition(PositionSentence sentence) throws DataNotAvailableException {
            return new DegreePosition(Math.abs(sentence.getPosition().getLatitude()) * (double)(sentence.getPosition().getLatitudeHemisphere() == CompassPoint.NORTH ? 1 : -1), Math.abs(sentence.getPosition().getLongitude()) * (double)(sentence.getPosition().getLongitudeHemisphere() == CompassPoint.EAST ? 1 : -1));
        }
    }

    private class TimeListener
    extends AbstractSentenceListener<TimeSentence> {
        private TimeListener() {
        }

        public void sentenceRead(TimeSentence sentence) {
            try {
                Time time = sentence.getTime();
                NMEAWindReceiverImpl.this.utcCalendar.set(NMEAWindReceiverImpl.this.utcCalendar.get(1), NMEAWindReceiverImpl.this.utcCalendar.get(2), NMEAWindReceiverImpl.this.utcCalendar.get(5), time.getHour(), time.getMinutes(), (int)time.getSeconds());
                int millisInSecond = (int)((time.getSeconds() - (double)((int)time.getSeconds())) * 1000.0);
                NMEAWindReceiverImpl.this.utcCalendar.set(14, millisInSecond);
                NMEAWindReceiverImpl.this.timeReceived = true;
            }
            catch (DataNotAvailableException dataNotAvailableException) {
                // empty catch block
            }
        }
    }

    private class VTGSentenceListener
    extends AbstractSentenceListener<VTGSentence> {
        private VTGSentenceListener() {
        }

        public void sentenceRead(VTGSentence sentence) {
            try {
                NMEAWindReceiverImpl.this.sensorSpeeds.add((Timed)new KnotSpeedWithBearingAndTimepoint(NMEAWindReceiverImpl.this.getLastTimePoint(), sentence.getSpeedKnots(), (Bearing)new DegreeBearingImpl(sentence.getTrueCourse())));
            }
            catch (DataNotAvailableException dataNotAvailableException) {
                // empty catch block
            }
        }
    }

    private class VWRSentenceListener
    extends AbstractSentenceListener<VWRSentence> {
        private VWRSentenceListener() {
        }

        public void sentenceRead(VWRSentence sentence) {
            NMEAWindReceiverImpl.this.apparentWind.add((Timed)new KnotSpeedWithBearingAndTimepoint(NMEAWindReceiverImpl.this.getLastTimePoint(), sentence.getSpeedKnots(), (Bearing)new DegreeBearingImpl(sentence.getWindAngle() * (double)(sentence.getDirectionLeftRight() == Direction.LEFT ? -1 : 1))));
        }
    }
}

