/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.PolarDiagram;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.PathGeneratorBase;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.TimedPositionImpl;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import com.sap.sailing.simulator.windfield.WindFieldGenerator;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PathGenerator1Turner
extends PathGeneratorBase {
    private SimulationParameters simulationParameters;
    private boolean leftSide;
    private result1Turn result;
    private Position evalStartPoint;
    private Position evalEndPoint;
    private TimePoint evalStartTime;
    private long evalTimeStep;
    private int evalStepMax;
    private double evalTolerance;
    private boolean upwindLeg;
    private static final double TRESHOLD_MINIMUM_DISTANCE_METERS = 10.0;

    public PathGenerator1Turner(SimulationParameters params) {
        this.simulationParameters = params;
    }

    public void setEvaluationParameters(boolean leftSideVal, Position startPoint, Position endPoint, TimePoint startTime, long timeStep, int stepMax, double tolerance, boolean upwindLeg) {
        this.leftSide = leftSideVal;
        this.evalStartPoint = startPoint;
        this.evalEndPoint = endPoint;
        this.evalStartTime = startTime;
        this.evalTimeStep = timeStep;
        this.evalStepMax = stepMax;
        this.evalTolerance = tolerance;
        this.upwindLeg = upwindLeg;
    }

    public int getMiddle() {
        return this.result.middle;
    }

    @Override
    public Path getPath() {
        this.algorithmStartTime = MillisecondsTimePoint.now();
        WindFieldGenerator windField = this.simulationParameters.getWindField();
        PolarDiagram polarDiagram = this.simulationParameters.getBoatPolarDiagram();
        Position start = this.evalStartPoint == null ? this.simulationParameters.getCourse().get(0) : this.evalStartPoint;
        Position end = this.evalEndPoint == null ? this.simulationParameters.getCourse().get(1) : this.evalEndPoint;
        TimePoint startTime = this.evalStartTime == null ? windField.getStartTime() : this.evalStartTime;
        long turnloss = polarDiagram.getTurnLoss();
        Distance courseLength = start.getDistance(end);
        Bearing bearStart2End = start.getBearingGreatCircle(end);
        Position currentPosition = start;
        TimePoint currentTime = startTime;
        double reachingTolerance = this.evalTolerance == 0.0 ? 0.03 : this.evalTolerance;
        int stepMax = this.evalStepMax == 0 ? 800 : this.evalStepMax;
        double[] reachTime = new double[stepMax];
        long timeStep = this.evalTimeStep == 0L ? windField.getTimeStep().asMillis() / 3L : this.evalTimeStep;
        double minimumDistance = courseLength.getMeters();
        double overallMinimumDistance = courseLength.getMeters();
        int stepOfOverallMinimumDistance = stepMax;
        LinkedList<TimedPositionWithSpeedImpl> path = null;
        LinkedList<TimedPositionWithSpeedImpl> allminpath = null;
        int step = 0;
        while (step < stepMax) {
            double newDistance;
            MillisecondsTimePoint nextTime;
            Bearing direction;
            currentPosition = start;
            currentTime = startTime;
            reachTime[step] = courseLength.getMeters();
            boolean targetFound = false;
            minimumDistance = courseLength.getMeters();
            path = new LinkedList<TimedPositionWithSpeedImpl>();
            path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, null));
            if (this.isTimedOut()) break;
            int stepLeft = 0;
            while (stepLeft < step && !targetFound && !this.isTimedOut()) {
                Wind currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currentWind);
                direction = this.upwindLeg ? (this.leftSide ? polarDiagram.optimalDirectionsUpwind()[0] : polarDiagram.optimalDirectionsUpwind()[1]) : (this.leftSide ? polarDiagram.optimalDirectionsDownwind()[0] : polarDiagram.optimalDirectionsDownwind()[1]);
                SpeedWithBearing currSpeed = polarDiagram.getSpeedAtBearing(direction);
                nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeStep);
                Position nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                newDistance = nextPosition.getDistance(end).getMeters();
                if (newDistance < minimumDistance) {
                    minimumDistance = newDistance;
                }
                currentPosition = nextPosition;
                currentTime = nextTime;
                path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, (SpeedWithBearing)currentWind));
                if (currentPosition.getDistance(end).getMeters() < reachingTolerance * courseLength.getMeters()) {
                    reachTime[step] = minimumDistance;
                    targetFound = true;
                }
                if (minimumDistance < overallMinimumDistance) {
                    overallMinimumDistance = minimumDistance;
                    stepOfOverallMinimumDistance = step;
                    allminpath = path;
                }
                ++stepLeft;
            }
            currentTime = new MillisecondsTimePoint(currentTime.asMillis() + turnloss);
            int stepRight = 0;
            while (stepRight < stepMax - step && !targetFound && !this.isTimedOut()) {
                Wind currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currentWind);
                direction = this.upwindLeg ? (this.leftSide ? polarDiagram.optimalDirectionsUpwind()[1] : polarDiagram.optimalDirectionsUpwind()[0]) : (this.leftSide ? polarDiagram.optimalDirectionsDownwind()[1] : polarDiagram.optimalDirectionsDownwind()[0]);
                SpeedWithBearing currSpeed = polarDiagram.getSpeedAtBearing(direction);
                nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeStep);
                Position nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                newDistance = nextPosition.getDistance(end).getMeters();
                if (newDistance < minimumDistance) {
                    minimumDistance = newDistance;
                }
                currentPosition = nextPosition;
                currentTime = nextTime;
                path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, (SpeedWithBearing)currentWind));
                if (currentPosition.getDistance(end).getMeters() < reachingTolerance * courseLength.getMeters()) {
                    Bearing bearPath2End = currentPosition.getBearingGreatCircle(end);
                    double bearDiff = bearPath2End.getDegrees() - bearStart2End.getDegrees();
                    reachTime[step] = minimumDistance * Math.signum(bearDiff);
                    if (start.getDistance(currentPosition).getMeters() > start.getDistance(end).getMeters()) {
                        targetFound = true;
                    }
                }
                if (minimumDistance < overallMinimumDistance) {
                    overallMinimumDistance = minimumDistance;
                    stepOfOverallMinimumDistance = step;
                    allminpath = new LinkedList(path);
                }
                ++stepRight;
            }
            ++step;
        }
        Path[] paths = new PathImpl[]{new PathImpl(allminpath, windField, this.algorithmTimedOut)};
        char side = this.leftSide ? (char)'L' : 'R';
        this.result = new result1Turn(paths, side, stepOfOverallMinimumDistance);
        return this.result.paths[0];
    }

    public TimedPositionWithSpeed get1Turner(WindFieldGenerator windField, PolarDiagram polarDiagram, Position start, Position end, TimePoint startTime, boolean leftSide, int stepMax, long timeStep) {
        long turnloss = polarDiagram.getTurnLoss();
        Distance courseLength = start.getDistance(end);
        Bearing bearStart2End = start.getBearingGreatCircle(end);
        Position currentPosition = start;
        TimePoint currentTime = startTime;
        double[] reachTime = new double[stepMax];
        double distanceToEnd = 0.0;
        double newDistance = 0.0;
        double minimumDistance = courseLength.getMeters();
        double overallMinimumDistance = courseLength.getMeters();
        int stepOfOverallMinimumDistance = stepMax;
        LinkedList<TimedPositionWithSpeedImpl> path = null;
        LinkedList<TimedPositionWithSpeedImpl> allminpath = null;
        Wind currentWind = null;
        SpeedWithBearing currSpeed = null;
        Position nextPosition = null;
        int step = 0;
        while (step < stepMax) {
            MillisecondsTimePoint nextTime;
            Bearing direction;
            currentPosition = start;
            currentTime = startTime;
            reachTime[step] = courseLength.getMeters();
            boolean targetFound = false;
            minimumDistance = courseLength.getMeters();
            path = new LinkedList<TimedPositionWithSpeedImpl>();
            path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, currSpeed));
            if (this.isTimedOut()) break;
            int stepLeft = 0;
            while (stepLeft < step && !targetFound && !this.isTimedOut()) {
                currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currentWind);
                direction = polarDiagram.optimalDirectionsUpwind()[leftSide ? 0 : 1];
                currSpeed = polarDiagram.getSpeedAtBearing(direction);
                nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeStep);
                nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                newDistance = nextPosition.getDistance(end).getMeters();
                if (newDistance < minimumDistance) {
                    minimumDistance = newDistance;
                }
                currentPosition = nextPosition;
                currentTime = nextTime;
                path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, currSpeed));
                distanceToEnd = currentPosition.getDistance(end).getMeters();
                if (distanceToEnd < 10.0) {
                    reachTime[step] = minimumDistance;
                    targetFound = true;
                    if (minimumDistance < overallMinimumDistance) {
                        overallMinimumDistance = minimumDistance;
                        stepOfOverallMinimumDistance = step;
                        allminpath = path;
                    }
                }
                ++stepLeft;
            }
            currentTime = new MillisecondsTimePoint(currentTime.asMillis() + turnloss);
            int stepRight = 0;
            while (stepRight < stepMax - step && !targetFound && !this.isTimedOut()) {
                currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
                polarDiagram.setWind((SpeedWithBearing)currentWind);
                direction = polarDiagram.optimalDirectionsUpwind()[leftSide ? 1 : 0];
                currSpeed = polarDiagram.getSpeedAtBearing(direction);
                nextTime = new MillisecondsTimePoint(currentTime.asMillis() + timeStep);
                nextPosition = currSpeed.travelTo(currentPosition, currentTime, (TimePoint)nextTime);
                newDistance = nextPosition.getDistance(end).getMeters();
                if (newDistance < minimumDistance) {
                    minimumDistance = newDistance;
                }
                currentPosition = nextPosition;
                currentTime = nextTime;
                path.addLast(new TimedPositionWithSpeedImpl(currentTime, currentPosition, currSpeed));
                distanceToEnd = currentPosition.getDistance(end).getMeters();
                if (distanceToEnd < 10.0) {
                    Bearing bearPath2End = currentPosition.getBearingGreatCircle(end);
                    double bearDiff = bearPath2End.getDegrees() - bearStart2End.getDegrees();
                    reachTime[step] = minimumDistance * Math.signum(bearDiff);
                    if (start.getDistance(currentPosition).getMeters() > start.getDistance(end).getMeters()) {
                        targetFound = true;
                    }
                    if (minimumDistance < overallMinimumDistance) {
                        overallMinimumDistance = minimumDistance;
                        stepOfOverallMinimumDistance = step;
                        allminpath = new LinkedList(path);
                    }
                }
                ++stepRight;
            }
            ++step;
        }
        Path[] paths = new PathImpl[]{new PathImpl(allminpath, windField, this.algorithmTimedOut)};
        this.result = new result1Turn(paths, leftSide ? (char)'L' : 'R', stepOfOverallMinimumDistance);
        TimedPositionWithSpeed oneTurnerPoint = (TimedPositionWithSpeed)allminpath.get(stepOfOverallMinimumDistance);
        if (oneTurnerPoint.getSpeed() == null) {
            currentWind = windField.getWind(new TimedPositionImpl(currentTime, currentPosition));
            oneTurnerPoint = new TimedPositionWithSpeedImpl(oneTurnerPoint.getTimePoint(), oneTurnerPoint.getPosition(), (SpeedWithBearing)currentWind);
        }
        return oneTurnerPoint;
    }

    public List<TimedPositionWithSpeed> getIntersectionOptimalTowardWind(WindFieldGenerator windField, PolarDiagram polarDiagram, Position edgeStart, Position edgeEnd, TimedPositionWithSpeed start, boolean leftSide, long timeStepMilliseconds, double minimumDistanceMeters) {
        ArrayList<TimedPositionWithSpeed> path = new ArrayList<TimedPositionWithSpeed>();
        TimedPositionWithSpeed nextPoint = start;
        double distanceToLine = 0.0;
        int maxSteps = 60;
        while (maxSteps > 0) {
            distanceToLine = PathGenerator1Turner.getDistanceToLine((nextPoint = PathGenerator1Turner.travelTo(nextPoint, windField, polarDiagram, leftSide, timeStepMilliseconds, edgeStart, edgeEnd)).getPosition(), edgeStart, edgeEnd);
            if (distanceToLine <= minimumDistanceMeters) break;
            path.add(nextPoint);
            --maxSteps;
        }
        return path;
    }

    private static TimedPositionWithSpeed travelTo(TimedPositionWithSpeed start, WindFieldGenerator windField, PolarDiagram polarDiagram, boolean leftSide, long timeStepMilliseconds, Position edgeStart, Position edgeEnd) {
        TimePoint startTimePoint = start.getTimePoint();
        Position startPosition = start.getPosition();
        Wind windSpeedWithBearing = windField.getWind(new TimedPositionImpl(startTimePoint, startPosition));
        polarDiagram.setWind((SpeedWithBearing)windSpeedWithBearing);
        Bearing bearing = polarDiagram.optimalDirectionsUpwind()[leftSide ? 0 : 1];
        SpeedWithBearing boatSpeedWithBearing = polarDiagram.getSpeedAtBearing(bearing);
        MillisecondsTimePoint endTimePoint = new MillisecondsTimePoint(startTimePoint.asMillis() + timeStepMilliseconds);
        Position endPosition = boatSpeedWithBearing.travelTo(startPosition, startTimePoint, (TimePoint)endTimePoint);
        Wind endWind = windField.getWind(new TimedPositionImpl((TimePoint)endTimePoint, endPosition));
        TimedPositionWithSpeedImpl end = new TimedPositionWithSpeedImpl((TimePoint)endTimePoint, endPosition, (SpeedWithBearing)endWind);
        return end;
    }

    public static Position getProjectionOnLine(Position point, Position segment1Start, Position segment1End) {
        double xA = segment1Start.getLatDeg();
        double yA = segment1Start.getLngDeg();
        double xB = segment1End.getLatDeg();
        double yB = segment1End.getLngDeg();
        double xC = point.getLatDeg();
        double yC = point.getLngDeg();
        double m = (yB - yA) / (xB - xA);
        double b = (xB * yA - xA * yB) / (xB - xA);
        double x = (m * yC + xC - m * b) / (m * m + 1.0);
        double y = m * x + b;
        return new DegreePosition(x, y);
    }

    public static double getDistanceToLine(Position point, Position segment1Start, Position segment1End) {
        return point.getDistance(PathGenerator1Turner.getProjectionOnLine(point, segment1Start, segment1End)).getMeters();
    }

    class result1Turn {
        Path[] paths;
        char side;
        int middle;

        public result1Turn(Path[] p, char s, int n) {
            this.paths = p;
            this.side = s;
            this.middle = n;
        }
    }
}

