/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.www;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CookieSameSiteFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Collection cookiesHeaders = httpResponse.getHeaders("Set-Cookie");
        boolean firstHeader = true;
        for (String header : cookiesHeaders) {
            if (firstHeader) {
                httpResponse.setHeader("Set-Cookie", String.format("%s; %s", header, "SameSite=None; Secure"));
                firstHeader = false;
                continue;
            }
            httpResponse.addHeader("Set-Cookie", String.format("%s; %s", header, "SameSite=None; Secure"));
        }
        chain.doFilter(request, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }
}

