/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsApplicationReplicaSet;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.AwsShard;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.impl.LoadBalancerRuleInserter;
import com.sap.sse.landscape.aws.orchestration.AbstractAwsProcedureImpl;
import com.sap.sse.landscape.aws.orchestration.ProcedureCreatingLoadBalancerMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PathPatternConditionConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;

public abstract class ShardProcedure<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends AbstractAwsProcedureImpl<ShardingKey>
implements ProcedureCreatingLoadBalancerMapping<ShardingKey> {
    private static final Logger logger = Logger.getLogger(ShardProcedure.class.getName());
    static final int NUMBER_OF_STANDARD_CONDITIONS_FOR_SHARDING_RULE = 2;
    public static final int DEFAULT_MINIMUM_AUTO_SCALING_GROUP_SIZE = 2;
    protected final ShardingKey SHARDING_KEY_UNUSED_BY_ANY_APPLICATION = "lauycaluy3cla3yrclaurlIYQL8";
    protected final String shardName;
    protected final Set<ShardingKey> shardingKeys;
    protected final AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> replicaSet;
    protected final Region region;
    private final String pathPrefixForShardingKey;

    protected ShardProcedure(BuilderImpl<?, ?, ShardingKey, MetricsT, ProcessT> builder) throws Exception {
        super(builder);
        this.shardName = builder.getShardName();
        this.replicaSet = builder.getReplicaSet();
        this.shardingKeys = builder.getShardingKeys();
        this.region = builder.getRegion();
        this.pathPrefixForShardingKey = builder.getPathPrefixForShardingKey();
    }

    protected boolean isTargetGroupNameUnique(String name) {
        Iterable targetGroups = this.getLandscape().getTargetGroups(this.region);
        return Util.isEmpty((Iterable)Util.filter(targetGroups, t -> t.getName().equals(name)));
    }

    protected Collection<RuleCondition> getShardingRuleConditions(ApplicationLoadBalancer<ShardingKey> loadBalancer, Collection<ShardingKey> shardingKeys) throws InterruptedException, ExecutionException {
        if (shardingKeys.size() > 3) {
            throw new IllegalArgumentException("too many sharding keys for the conditions of a single load balancer rule: " + shardingKeys + "; a maximum of " + 3 + " is allowed");
        }
        ArrayList<RuleCondition> ruleConditions = new ArrayList<RuleCondition>();
        ArrayList paths = Util.mapToArrayList(shardingKeys, shardingKey -> ShardProcedure.getPathConditionForShardingKey(shardingKey, this.pathPrefixForShardingKey));
        ruleConditions.add(loadBalancer.createHostHeaderRuleCondition(this.replicaSet.getHostname()));
        ruleConditions.add((RuleCondition)RuleCondition.builder().field("http-header").httpHeaderConfig(hhcb -> {
            HttpHeaderConditionConfig.Builder builder = hhcb.httpHeaderName("X-SAPSSE-Forward-Request-To").values(new String[]{(String)HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA.getB()});
        }).build());
        ruleConditions.add((RuleCondition)RuleCondition.builder().field("path-pattern").pathPatternConfig(hhcb -> {
            PathPatternConditionConfig.Builder builder = hhcb.values(paths);
        }).build());
        return ruleConditions;
    }

    protected Iterable<Rule> addShardingRules(ApplicationLoadBalancer<ShardingKey> alb, Iterable<ShardingKey> shardingKeys, TargetGroup<ShardingKey> targetGroup) throws Exception {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        HashSet shardingKeyForConsumption = new HashSet();
        Util.addAll(shardingKeys, shardingKeyForConsumption);
        int ruleIdx = alb.getFirstShardingPriority(this.replicaSet.getHostname());
        while (!shardingKeyForConsumption.isEmpty()) {
            LoadBalancerRuleInserter.create(alb, 50000, 100).shiftRulesToMakeSpaceAt(ruleIdx, 1);
            HashSet shardingKeysForNextRule = new HashSet();
            Iterator i = shardingKeyForConsumption.iterator();
            while (shardingKeysForNextRule.size() < 3 && i.hasNext()) {
                shardingKeysForNextRule.add(i.next());
                i.remove();
            }
            Collection<RuleCondition> conditions = this.getShardingRuleConditions(alb, shardingKeysForNextRule);
            rules.add((Rule)Rule.builder().priority("" + ruleIdx).conditions(conditions).actions(new Action[]{(Action)Action.builder().forwardConfig((ForwardActionConfig)ForwardActionConfig.builder().targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(targetGroup.getTargetGroupArn()).build()}).build()).type(ActionTypeEnum.FORWARD).build()}).build());
        }
        return alb.addRules((Rule[])Util.toArray(rules, (Object[])new Rule[0]));
    }

    protected ApplicationLoadBalancer<ShardingKey> getFreeLoadBalancerAndMoveReplicaSet() throws Exception {
        ApplicationLoadBalancer<ShardingKey> res;
        int existingShardingRules = 0;
        for (Map.Entry<AwsShard<ShardingKey>, Iterable<ShardingKey>> s : this.replicaSet.getShards().entrySet()) {
            existingShardingRules += Util.size(s.getKey().getRules());
        }
        int requiredRules = this.numberOfRequiredRules(Util.size(this.shardingKeys)) + (existingShardingRules + 5);
        if (Util.size(this.replicaSet.getLoadBalancer().getRules()) + this.numberOfRequiredRules(Util.size(this.shardingKeys)) < 100) {
            res = this.replicaSet.getLoadBalancer();
        } else {
            Iterable loadBalancers = this.getLandscape().getLoadBalancers(this.region);
            Iterable loadBalancersFiltered = Util.filter(loadBalancers, t -> {
                try {
                    return t.getVpcId().equals(this.replicaSet.getLoadBalancer().getVpcId()) && !t.getArn().equals(this.replicaSet.getLoadBalancer().getArn());
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.WARNING, "Exception while trying to obtain a load balancer's ARN", e);
                    throw new RuntimeException(e);
                }
            });
            ApplicationLoadBalancer<ShardingKey> alb = this.getDNSLoadbalancerWithRulesLeft(loadBalancersFiltered, requiredRules + 5);
            if (alb != null) {
                res = alb;
            } else {
                HashSet<String> loadBalancerNames = new HashSet<String>();
                for (ApplicationLoadBalancer lb : loadBalancers) {
                    loadBalancerNames.add(lb.getName());
                }
                String name = this.getAvailableDNSMappedAlbName(loadBalancerNames);
                res = this.getLandscape().createLoadBalancer(name, this.region, this.getSecurityGroupForVpc());
            }
            this.changeReplicaSetLoadBalancer(res, this.replicaSet);
        }
        return res;
    }

    private SecurityGroup getSecurityGroupForVpc() throws InterruptedException, ExecutionException {
        return this.getLandscape().getSecurityGroup(this.replicaSet.getLoadBalancer().getSecurityGroupIds().get(0), this.region);
    }

    private void changeReplicaSetLoadBalancer(ApplicationLoadBalancer<ShardingKey> targetAlb, AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> replicaSetToMove) throws Exception {
        ArrayList<TargetGroup<ShardingKey>> tempTargetGroups = new ArrayList<TargetGroup<ShardingKey>>();
        ArrayList<TargetGroup<ShardingKey>> originalTargetGroups = new ArrayList<TargetGroup<ShardingKey>>();
        HashMap<TargetGroup<ShardingKey>, Iterable<ShardingKey>> shardingKeysPerTargetGroup = new HashMap<TargetGroup<ShardingKey>, Iterable<ShardingKey>>();
        HashMap<TargetGroup<ShardingKey>, TargetGroup<ShardingKey>> targetGroupsToTempTargetgroups = new HashMap<TargetGroup<ShardingKey>, TargetGroup<ShardingKey>>();
        HashMap<AwsShard<ShardingKey>, TargetGroup<ShardingKey>> shardToTempTargetGroup = new HashMap<AwsShard<ShardingKey>, TargetGroup<ShardingKey>>();
        ArrayList<Rule> tempRules = new ArrayList<Rule>();
        this.createTargetGroupsForMoving(shardToTempTargetGroup, tempTargetGroups, replicaSetToMove, targetGroupsToTempTargetgroups, originalTargetGroups, shardingKeysPerTargetGroup);
        this.addRulesForMoving(targetAlb, shardToTempTargetGroup, tempRules, replicaSetToMove, targetGroupsToTempTargetgroups, originalTargetGroups, shardingKeysPerTargetGroup);
        String hostname = replicaSetToMove.getHostname();
        this.getLandscape().setDNSRecordToApplicationLoadBalancer(replicaSetToMove.getHostedZoneId(), hostname, targetAlb, true);
        int i = 0;
        while (i < 6) {
            Thread.sleep(60000L);
            logger.info(() -> "Still waiting for DNS record " + hostname);
            ++i;
        }
        logger.info(() -> "Done waiting for DNS record " + hostname);
        ArrayList<Rule> rulesToRemove = new ArrayList<Rule>();
        replicaSetToMove.getLoadBalancer().getRulesForTargetGroups(originalTargetGroups).forEach(t -> {
            boolean bl = rulesToRemove.add((Rule)t);
        });
        rulesToRemove.add(replicaSetToMove.getDefaultRedirectRule());
        this.getLandscape().deleteLoadBalancerListenerRules(this.region, rulesToRemove.toArray(new Rule[0]));
        for (Map.Entry entry : targetGroupsToTempTargetgroups.entrySet()) {
            targetAlb.replaceTargetGroupInForwardRules((TargetGroup)entry.getValue(), (TargetGroup)entry.getKey());
        }
        for (TargetGroup targetGroup : tempTargetGroups) {
            this.getLandscape().deleteTargetGroup(targetGroup);
        }
    }

    private void createTargetGroupsForMoving(Map<AwsShard<ShardingKey>, TargetGroup<ShardingKey>> shardToTempTargetGroup, Collection<TargetGroup<ShardingKey>> tempTargetGroups, AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> replicaSetToMove, Map<TargetGroup<ShardingKey>, TargetGroup<ShardingKey>> targetGroupsToTempTargetgroups, Collection<TargetGroup<ShardingKey>> originalTargetGroups, Map<TargetGroup<ShardingKey>, Iterable<ShardingKey>> shardingKeysPerTargetGroup) throws Exception {
        TargetGroup<ShardingKey> targetgroupMasterTemp = this.getLandscape().copyTargetGroup(replicaSetToMove.getMasterTargetGroup(), "-TMP");
        TargetGroup<ShardingKey> targetgroupPublicTemp = this.getLandscape().copyTargetGroup(replicaSetToMove.getPublicTargetGroup(), "-TMP");
        tempTargetGroups.add(targetgroupMasterTemp);
        tempTargetGroups.add(targetgroupPublicTemp);
        targetGroupsToTempTargetgroups.put(replicaSetToMove.getMasterTargetGroup(), targetgroupMasterTemp);
        targetGroupsToTempTargetgroups.put(replicaSetToMove.getPublicTargetGroup(), targetgroupPublicTemp);
        originalTargetGroups.add(replicaSetToMove.getMasterTargetGroup());
        originalTargetGroups.add(replicaSetToMove.getPublicTargetGroup());
        for (Map.Entry<AwsShard<ShardingKey>, Iterable<ShardingKey>> shardAndShardingKeys : replicaSetToMove.getShards().entrySet()) {
            TargetGroup<ShardingKey> tempShardTargetGroup = this.getLandscape().copyTargetGroup(shardAndShardingKeys.getKey().getTargetGroup(), "-TMP");
            shardToTempTargetGroup.put(shardAndShardingKeys.getKey(), tempShardTargetGroup);
            shardingKeysPerTargetGroup.put(shardAndShardingKeys.getKey().getTargetGroup(), shardAndShardingKeys.getValue());
            tempTargetGroups.add(tempShardTargetGroup);
            originalTargetGroups.add(shardAndShardingKeys.getKey().getTargetGroup());
            targetGroupsToTempTargetgroups.put(shardAndShardingKeys.getKey().getTargetGroup(), tempShardTargetGroup);
        }
    }

    private void addRulesForMoving(ApplicationLoadBalancer<ShardingKey> targetAlb, Map<AwsShard<ShardingKey>, TargetGroup<ShardingKey>> shardToTempTargetGroup, Collection<Rule> tempRules, AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> replicaSetToMove, Map<TargetGroup<ShardingKey>, TargetGroup<ShardingKey>> targetGroupsToTempTargetgroups, Collection<TargetGroup<ShardingKey>> originalTargetGroups, Map<TargetGroup<ShardingKey>, Iterable<ShardingKey>> shardingKeysPerTargetGroup) throws Exception {
        targetAlb.addRulesAssigningUnusedPriorities(true, Optional.empty(), this.createRules(targetAlb, this.replicaSet.getHostname(), targetGroupsToTempTargetgroups.get(replicaSetToMove.getMasterTargetGroup()), targetGroupsToTempTargetgroups.get(replicaSetToMove.getPublicTargetGroup()))).forEach(t -> {
            boolean bl = tempRules.add((Rule)t);
        });
        for (Map.Entry<AwsShard<ShardingKey>, Iterable<ShardingKey>> shardAndShardingKeys : replicaSetToMove.getShards().entrySet()) {
            this.addShardingRules(targetAlb, shardingKeysPerTargetGroup.get(shardAndShardingKeys.getKey().getTargetGroup()), shardToTempTargetGroup.get(shardAndShardingKeys.getKey())).forEach(t -> {
                boolean bl = tempRules.add((Rule)t);
            });
        }
    }

    protected int numberOfRequiredRules(int numberOfShardingKeys) {
        return numberOfShardingKeys / 3 + (int)Math.signum(numberOfShardingKeys % 3);
    }

    private ApplicationLoadBalancer<ShardingKey> getDNSLoadbalancerWithRulesLeft(Iterable<ApplicationLoadBalancer<ShardingKey>> loadBalancers, int numberOfRules) {
        Iterable loadBalancersFiltered = Util.filter(loadBalancers, t -> t.getName().startsWith("DNSMapped-"));
        ApplicationLoadBalancer res = null;
        for (ApplicationLoadBalancer loadBalancer : loadBalancersFiltered) {
            if (Util.size(loadBalancer.getRules()) >= 100 - numberOfRules) continue;
            res = loadBalancer;
            break;
        }
        return res;
    }

    protected int getHighestAvailableIndex(Iterable<Rule> rules) {
        int i = 50000;
        while (i > 1) {
            String y = "" + i;
            if (!StreamSupport.stream(rules.spliterator(), false).anyMatch(t -> t.priority().contains(y))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private String getAvailableDNSMappedAlbName(Set<String> loadBalancerNames) {
        HashSet<Integer> numbersTaken = new HashSet<Integer>();
        for (String loadBalancerName : loadBalancerNames) {
            Matcher matcher = ApplicationLoadBalancer.ALB_NAME_PATTERN.matcher(loadBalancerName);
            if (!matcher.find()) continue;
            numbersTaken.add(Integer.parseInt(matcher.group(1)));
        }
        return "DNSMapped-" + IntStream.range(0, 20).filter(i -> !numbersTaken.contains(i)).min().getAsInt();
    }

    public static <ShardingKey> String getPathConditionForShardingKey(ShardingKey shardingKey, String pathPrefixForShardingKey) {
        return String.valueOf(pathPrefixForShardingKey) + shardingKey.toString();
    }

    public static <ShardingKey> ShardingKey getShardingKeyFromPathCondition(String path, String pathPrefixForShardingKey) {
        if (!path.startsWith(pathPrefixForShardingKey)) {
            throw new IllegalStateException("path condition \"" + path + "\" does not start with \"" + pathPrefixForShardingKey + "\" which is unexpected");
        }
        String result = path.substring(pathPrefixForShardingKey.length());
        return (ShardingKey)result;
    }

    protected String getPathConditionForShardingKey(ShardingKey shardingKey) {
        return ShardProcedure.getPathConditionForShardingKey(shardingKey, this.pathPrefixForShardingKey);
    }

    protected ShardingKey getShardingKeyFromPathCondition(String path) {
        return ShardProcedure.getShardingKeyFromPathCondition(path, this.pathPrefixForShardingKey);
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends ShardProcedure<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends AbstractAwsProcedureImpl.Builder<BuilderT, T, ShardingKey> {
        public BuilderT setPathPrefixForShardingKey(String var1);

        public BuilderT setShardName(String var1);

        public BuilderT setLandscape(AwsLandscape<String> var1);

        public BuilderT setShardingKeys(Set<ShardingKey> var1);

        public BuilderT setReplicaSet(AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> var1);

        public BuilderT setRegion(Region var1);
    }

    protected static abstract class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT>, T extends ShardProcedure<ShardingKey, MetricsT, ProcessT>, ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends AbstractAwsProcedureImpl.BuilderImpl<BuilderT, T, ShardingKey>
    implements Builder<BuilderT, T, ShardingKey, MetricsT, ProcessT> {
        protected String shardName;
        protected Set<ShardingKey> shardingKeys;
        protected AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> replicaSet;
        protected Region region;
        private String pathPrefixForShardingKey;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT setPathPrefixForShardingKey(String pathPrefixForShardingKey) {
            this.pathPrefixForShardingKey = pathPrefixForShardingKey;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setShardName(String name) {
            this.shardName = name;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setShardingKeys(Set<ShardingKey> shardingkeys) {
            this.shardingKeys = shardingkeys;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setReplicaSet(AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> replicaset) {
            this.replicaSet = replicaset;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setRegion(Region region) {
            this.region = region;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setLandscape(AwsLandscape<String> landscape) {
            super.setLandscape(landscape);
            return (BuilderT)((Builder)this.self());
        }

        @Override
        protected AwsLandscape<ShardingKey> getLandscape() {
            return super.getLandscape();
        }

        Region region() {
            return this.region;
        }

        AwsApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> getReplicaSet() {
            return this.replicaSet;
        }

        Set<ShardingKey> getShardingKeys() {
            return this.shardingKeys;
        }

        String getShardName() {
            return this.shardName;
        }

        Region getRegion() {
            return this.region;
        }

        String getPathPrefixForShardingKey() {
            return this.pathPrefixForShardingKey;
        }
    }
}

