/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.jcraft.jsch.JSchException;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.RotatingFileBasedLog;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.ProcessFactory;
import com.sap.sse.landscape.aws.ApplicationProcessHost;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.ReverseProxy;
import com.sap.sse.landscape.aws.impl.ApacheReverseProxy;
import com.sap.sse.landscape.aws.impl.AwsInstanceImpl;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import com.sap.sse.shared.util.Wait;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ApplicationProcessHostImpl<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, HostT extends ApplicationProcessHost<ShardingKey, MetricsT, ProcessT>>
extends AwsInstanceImpl<ShardingKey>
implements ApplicationProcessHost<ShardingKey, MetricsT, ProcessT> {
    private static final Logger logger = Logger.getLogger(ApplicationProcessHostImpl.class.getName());
    private final ProcessFactory<ShardingKey, MetricsT, ProcessT, HostT> processFactoryFromHostAndServerDirectory;
    private static final String SERVER_DIRECTORY_JSON_PROPERTY = "serverdirectory";
    private static final String SERVER_PORT_JSON_PROPERTY = "port";
    private static final String TELNET_PORT_JSON_PROPERTY = "telnetport";
    private static final String SERVER_NAME_JSON_PROPERTY = "servername";

    public ApplicationProcessHostImpl(String instanceId, AwsAvailabilityZone availabilityZone, InetAddress privateIpAddress, TimePoint launchTimePoint, AwsLandscape<ShardingKey> landscape, ProcessFactory<ShardingKey, MetricsT, ProcessT, HostT> processFactoryFromHostAndServerDirectory) {
        super(instanceId, availabilityZone, privateIpAddress, launchTimePoint, landscape);
        this.processFactoryFromHostAndServerDirectory = processFactoryFromHostAndServerDirectory;
    }

    @Override
    public ReverseProxy<ShardingKey, MetricsT, ProcessT, RotatingFileBasedLog> getReverseProxy() {
        return new ApacheReverseProxy(this.getLandscape(), this);
    }

    protected Map<String, Boolean> getAdditionalEnvironmentPropertiesAndWhetherStringTyped() {
        return Collections.emptyMap();
    }

    @Override
    public Iterable<ProcessT> getApplicationProcesses(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase, boolean rethrowExceptions) throws Exception {
        HashSet<ApplicationProcess> result = new HashSet<ApplicationProcess>();
        SshCommandChannel sshChannel = this.createRootSshChannel(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
        if (sshChannel != null) {
            try {
                JSONArray serverDirectoriesAndPorts = (JSONArray)Wait.wait(() -> this.getServerDirectoriesAndPorts(sshChannel), sdap -> true, (boolean)true, optionalTimeout, (Duration)Duration.ONE_SECOND.times(10L), (Level)Level.INFO, (String)("Parsing JSON response describing application processes on host " + this));
                for (Object serverDirectoryAndPort : serverDirectoriesAndPorts) {
                    JSONObject serverDirectoryAndPortObject = (JSONObject)serverDirectoryAndPort;
                    String relativeServerDirectory = (String)serverDirectoryAndPortObject.get((Object)SERVER_DIRECTORY_JSON_PROPERTY);
                    if (relativeServerDirectory == null) continue;
                    String serverDirectory = "/home/sailing/servers/" + relativeServerDirectory;
                    int port = ((Number)serverDirectoryAndPortObject.get((Object)SERVER_PORT_JSON_PROPERTY)).intValue();
                    int telnetPort = ((Number)serverDirectoryAndPortObject.get((Object)TELNET_PORT_JSON_PROPERTY)).intValue();
                    String serverName = (String)serverDirectoryAndPortObject.get((Object)SERVER_NAME_JSON_PROPERTY);
                    HashMap<String, Object> additionalProperties = new HashMap<String, Object>();
                    for (Map.Entry<String, Boolean> additionalEntryAndWhetherStringTyped : this.getAdditionalEnvironmentPropertiesAndWhetherStringTyped().entrySet()) {
                        additionalProperties.put(additionalEntryAndWhetherStringTyped.getKey(), serverDirectoryAndPortObject.get((Object)additionalEntryAndWhetherStringTyped.getKey().toLowerCase()));
                    }
                    try {
                        ApplicationProcess process = this.processFactoryFromHostAndServerDirectory.createProcess(this.self(), port, serverDirectory, Integer.valueOf(telnetPort), serverName, additionalProperties);
                        result.add(process);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Problem creating application process from directory " + serverDirectory + " on host " + this + "; skipping", e);
                        if (!rethrowExceptions) continue;
                        throw new RuntimeException(e);
                    }
                }
            }
            finally {
                if (sshChannel != null) {
                    sshChannel.disconnect();
                }
            }
        }
        return result;
    }

    @Override
    public Iterable<ProcessT> getApplicationProcesses(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getApplicationProcesses(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase, false);
    }

    private JSONArray getServerDirectoriesAndPorts(SshCommandChannel sshChannel) throws IOException, InterruptedException, JSchException, ParseException {
        StringBuilder commandLine = new StringBuilder("cd /home/sailing/servers; ").append("echo -n \"[\"; ").append("find * -type d -prune -exec bash -c 'cd '{}'; . env.sh >/dev/null; echo \"{ ").append("\\\"serverdirectory\\\":\\\"'{}'\\\", ").append("\\\"port\\\":${SERVER_PORT} ").append("\\\"telnetport\\\":${TELNET_PORT}, ").append("\\\"servername\\\":\\\"${SERVER_NAME}\\\", ");
        for (Map.Entry<String, Boolean> additionalEntryAndWhetherStringTyped : this.getAdditionalEnvironmentPropertiesAndWhetherStringTyped().entrySet()) {
            if (!additionalEntryAndWhetherStringTyped.getValue().booleanValue()) {
                commandLine.append("\"; if [ -n \"${");
                commandLine.append(additionalEntryAndWhetherStringTyped.getKey());
                commandLine.append("}\" ]; then echo \"");
            }
            commandLine.append("\\\"" + additionalEntryAndWhetherStringTyped.getKey().toLowerCase() + "\\\":");
            if (additionalEntryAndWhetherStringTyped.getValue().booleanValue()) {
                commandLine.append("\\\"");
            }
            commandLine.append("${");
            commandLine.append(additionalEntryAndWhetherStringTyped.getKey());
            commandLine.append("}");
            if (additionalEntryAndWhetherStringTyped.getValue().booleanValue()) {
                commandLine.append("\\\"");
            }
            commandLine.append(", ");
            if (additionalEntryAndWhetherStringTyped.getValue().booleanValue()) continue;
            commandLine.append("\"; fi; echo \"");
        }
        commandLine.append("},\"' \\; ; echo \"{}]\"");
        String stdout = sshChannel.runCommandAndReturnStdoutAndLogStderr(commandLine.toString(), "Error(s) during evaluating server processes", Level.SEVERE);
        try {
            JSONArray serverDirectoriesAndPorts = (JSONArray)new JSONParser().parse(stdout);
            return serverDirectoriesAndPorts;
        }
        catch (ParseException e) {
            logger.severe("Failed to parse as JSON: \"" + stdout + "\": " + e.getMessage());
            throw e;
        }
    }

    private HostT self() {
        ApplicationProcessHostImpl result = this;
        return (HostT)result;
    }
}

