/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.aws.AwsLandscapeState;
import com.sap.sse.landscape.aws.common.shared.SecuredAwsLandscapeType;
import com.sap.sse.landscape.aws.impl.AwsLandscapeStateImpl;
import com.sap.sse.landscape.aws.impl.SSHKeyPairListener;
import com.sap.sse.landscape.common.shared.SecuredLandscapeTypes;
import com.sap.sse.landscape.ssh.SSHKeyPair;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.Replicable;
import com.sap.sse.security.PermissionChangeListener;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.HasPermissionsProvider;
import com.sap.sse.security.shared.WildcardPermission;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final String AWS_LANDSCAPE_OBJECT_ID = "AWS";
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static Activator instance;
    private final WildcardPermission landscapeManagerPermission = WildcardPermission.builder().withTypes(new HasPermissions[]{SecuredLandscapeTypes.LANDSCAPE}).withActions(new HasPermissions.Action[]{SecuredLandscapeTypes.LandscapeActions.MANAGE}).withIds(new String[]{"AWS"}).build();
    private TimePoint timePointOfLastChangeOfSetOfLandscapeManagers = TimePoint.now();
    private SSHKeyPairListener sshKeyPairListener = new SSHKeyPairListener(){

        @Override
        public void sshKeyPairAdded(SSHKeyPair sshKeyPair) {
            Activator.this.timePointOfLastChangeOfSetOfLandscapeManagers = TimePoint.now();
        }

        @Override
        public void sshKeyPairRemoved(SSHKeyPair sshKeyPair) {
            Activator.this.timePointOfLastChangeOfSetOfLandscapeManagers = TimePoint.now();
        }
    };
    private PermissionChangeListener permissionChangeListener = (permission, usersNowHavingPermission) -> {
        TimePoint timePoint = this.timePointOfLastChangeOfSetOfLandscapeManagers = TimePoint.now();
    };
    private FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private AwsLandscapeStateImpl landscapeState = new AwsLandscapeStateImpl();

    public Activator() {
        this.landscapeState.addSSHKeyPairListener(this.sshKeyPairListener);
    }

    public void start(final BundleContext context) throws Exception {
        instance = this;
        context.registerService(HasPermissionsProvider.class, SecuredAwsLandscapeType::getAllInstances, null);
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<SecurityService, SecurityService>(){

            public SecurityService addingService(ServiceReference<SecurityService> reference) {
                SecurityService securityService = (SecurityService)context.getService(reference);
                securityService.addPermissionChangeListener(Activator.this.landscapeManagerPermission, Activator.this.permissionChangeListener);
                return securityService;
            }

            public void modifiedService(ServiceReference<SecurityService> reference, SecurityService service) {
            }

            public void removedService(ServiceReference<SecurityService> reference, SecurityService service) {
                service.removePermissionChangeListener(Activator.this.landscapeManagerPermission, Activator.this.permissionChangeListener);
            }
        });
        new Thread(() -> {
            try {
                ((SecurityService)this.securityServiceTracker.getInitializedService(0L)).addPermissionChangeListener(this.landscapeManagerPermission, this.permissionChangeListener);
            }
            catch (InterruptedException e) {
                logger.warning("Problem obtaining SecurityService in " + Activator.class.getName());
            }
        }, "Waiting for SecurityService in " + Activator.class.getName()).start();
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", this.landscapeState.getId().toString());
        context.registerService(Replicable.class, (Object)this.landscapeState, replicableServiceProperties);
    }

    public static Activator getInstance() {
        if (instance == null) {
            instance = new Activator();
        }
        return instance;
    }

    public AwsLandscapeState getLandscapeState() {
        return this.landscapeState;
    }

    public TimePoint getTimePointOfLastChangeOfSetOfLandscapeManagers() {
        return this.timePointOfLastChangeOfSetOfLandscapeManagers;
    }

    public void stop(BundleContext context) throws Exception {
        this.landscapeState.removeSSHKeyPairListener(this.sshKeyPairListener);
        SecurityService securityService = (SecurityService)this.securityServiceTracker.getService();
        if (securityService != null) {
            securityService.removePermissionChangeListener(this.landscapeManagerPermission, this.permissionChangeListener);
        }
    }
}

