/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.ImageData;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.streamlets.Vector;

public abstract class MovingCanvasOverlay
extends FullCanvasOverlay {
    private LatLng upperLeftCornerLatLng;

    public MovingCanvasOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
    }

    public void setCanvasSettings() {
        if (this.getMapProjection() != null) {
            int canvasWidth = this.getMap().getDiv().getClientWidth();
            int canvasHeight = this.getMap().getDiv().getClientHeight();
            Point nwOldDivPx = this.upperLeftCornerLatLng == null ? null : this.getMapProjection().fromLatLngToDivPixel(this.upperLeftCornerLatLng);
            this.upperLeftCornerLatLng = this.getMapProjection().fromContainerPixelToLatLng(Point.newInstance((double)0.0, (double)0.0));
            Point nwNewDivPx = this.getMapProjection().fromLatLngToDivPixel(this.upperLeftCornerLatLng);
            this.widgetPosLeft = Math.round(nwNewDivPx.getX());
            this.widgetPosTop = Math.round(nwNewDivPx.getY());
            if (nwOldDivPx == null) {
                this.diffPx = new Vector(0.0, 0.0);
            } else {
                double oldPosLeft = Math.round(nwOldDivPx.getX());
                double oldPosTop = Math.round(nwOldDivPx.getY());
                this.diffPx = new Vector(oldPosLeft - this.widgetPosLeft, oldPosTop - this.widgetPosTop);
            }
            Context2d ctxt = this.canvas.getContext2d();
            int clientWidth = this.canvas.getElement().getClientWidth();
            int clientHeight = this.canvas.getElement().getClientHeight();
            ImageData canvasContent = null;
            if (clientWidth > 0 && clientHeight > 0) {
                canvasContent = ctxt.getImageData(0.0, 0.0, (double)this.canvas.getElement().getClientWidth(), (double)this.canvas.getElement().getClientHeight());
            }
            this.canvas.setWidth(String.valueOf(Math.max(1, canvasWidth)));
            this.canvas.setHeight(String.valueOf(Math.max(1, canvasHeight)));
            this.canvas.setCoordinateSpaceWidth(Math.max(1, canvasWidth));
            this.canvas.setCoordinateSpaceHeight(Math.max(1, canvasHeight));
            if (clientWidth > 0 && clientHeight > 0) {
                ctxt = this.canvas.getContext2d();
                ctxt.putImageData(canvasContent, this.diffPx.x, this.diffPx.y);
            }
            this.setCanvasPosition(this.widgetPosLeft, this.widgetPosTop);
        }
    }

    public void initCanvasOrigin() {
        this.upperLeftCornerLatLng = null;
    }
}

