/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.server;

import com.sap.sailing.gwt.ui.server.Activator;
import com.sap.sailing.gwt.ui.server.StoredDataMiningQueryPersister;
import com.sap.sailing.gwt.ui.server.StoredDataMiningQueryPersisterImpl;
import com.sap.sailing.gwt.ui.server.StoredDataMiningReportPersister;
import com.sap.sailing.gwt.ui.server.StoredDataMiningReportPersisterImpl;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.DataMiningServer;
import com.sap.sse.datamining.Query;
import com.sap.sse.datamining.StatisticQueryDefinition;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.DataRetrieverChainDefinition;
import com.sap.sse.datamining.data.ExtensibleQueryResult;
import com.sap.sse.datamining.data.QueryResult;
import com.sap.sse.datamining.factories.DataMiningDTOFactory;
import com.sap.sse.datamining.functions.Function;
import com.sap.sse.datamining.impl.components.DataRetrieverLevel;
import com.sap.sse.datamining.impl.components.management.ReducedDimensions;
import com.sap.sse.datamining.impl.data.QueryResultImpl;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.SerializationDummy;
import com.sap.sse.datamining.shared.data.QueryResultState;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.GenericGroupKey;
import com.sap.sse.datamining.shared.impl.PredefinedQueryIdentifier;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.shared.impl.dto.ReducedDimensionsDTO;
import com.sap.sse.datamining.shared.impl.dto.StoredDataMiningQueryDTOImpl;
import com.sap.sse.datamining.shared.impl.dto.StoredDataMiningReportDTOImpl;
import com.sap.sse.datamining.ui.client.DataMiningService;
import com.sap.sse.gwt.server.ProxiedRemoteServiceServlet;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.shiro.authz.UnauthorizedException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DataMiningServiceImpl
extends ProxiedRemoteServiceServlet
implements DataMiningService {
    private static final long serialVersionUID = -7951930891674894528L;
    private static final Logger logger = Logger.getLogger(DataMiningServiceImpl.class.getName());
    private final BundleContext context = Activator.getDefault();
    private final ServiceTracker<DataMiningServer, DataMiningServer> dataMiningServerTracker = this.createAndOpenDataMiningServerTracker(this.context);
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)this.context, SecurityService.class);
    protected final StoredDataMiningQueryPersister storedDataMiningQueryPersistor = new StoredDataMiningQueryPersisterImpl(this.getSecurityService(), this.dataMiningServerTracker);
    protected final StoredDataMiningReportPersister storedDataMiningReportPersistor = new StoredDataMiningReportPersisterImpl(this.getSecurityService(), this.dataMiningServerTracker);
    private final DataMiningDTOFactory dtoFactory = new DataMiningDTOFactory();

    private ServiceTracker<DataMiningServer, DataMiningServer> createAndOpenDataMiningServerTracker(BundleContext context) {
        ServiceTracker result = new ServiceTracker(context, DataMiningServer.class.getName(), null);
        result.open();
        return result;
    }

    private DataMiningServer getDataMiningServer() {
        return (DataMiningServer)this.dataMiningServerTracker.getService();
    }

    private SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Date getComponentsChangedTimepoint() {
        this.checkDataMiningPermission();
        return this.getDataMiningServer().getComponentsChangedTimepoint();
    }

    public FunctionDTO getIdentityFunction(String localeInfoName) {
        this.checkDataMiningPermission();
        DataMiningServer server = this.getDataMiningServer();
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        return this.dtoFactory.createFunctionDTO(server.getIdentityFunction(), server.getStringMessages(), locale);
    }

    public HashSet<FunctionDTO> getAllStatistics(String localeInfoName) {
        this.checkDataMiningPermission();
        Iterable statistics = this.getDataMiningServer().getAllStatistics();
        return this.functionsAsDTOs(statistics, localeInfoName);
    }

    protected void checkDataMiningPermission() {
        this.getSecurityService().checkCurrentUserServerPermission(SecuredSecurityTypes.ServerActions.DATA_MINING);
    }

    public HashSet<FunctionDTO> getStatisticsFor(DataRetrieverChainDefinitionDTO retrieverChainDefinition, String localeInfoName) {
        this.checkDataMiningPermission();
        Class retrievedDataType = this.getDataMiningServer().getDataRetrieverChainDefinitionForDTO(retrieverChainDefinition).getRetrievedDataType();
        Iterable statistics = this.getDataMiningServer().getStatisticsFor(retrievedDataType);
        return this.functionsAsDTOs(statistics, localeInfoName);
    }

    public HashSet<AggregationProcessorDefinitionDTO> getAggregatorDefinitions(String localeInfoName) {
        this.checkDataMiningPermission();
        Iterable definitions = this.getDataMiningServer().getAllAggregationProcessorDefinitions();
        return this.aggregatorDefinitionsAsDTOs(definitions, localeInfoName);
    }

    public HashSet<AggregationProcessorDefinitionDTO> getAggregatorDefinitionsFor(FunctionDTO extractionFunction, String localeInfoName) {
        this.checkDataMiningPermission();
        Class returnType = this.getReturnType(extractionFunction);
        Iterable definitions = this.getDataMiningServer().getAggregationProcessorDefinitions(returnType);
        return this.aggregatorDefinitionsAsDTOs(definitions, localeInfoName);
    }

    private Class<?> getReturnType(FunctionDTO extractionFunction) {
        return this.getDataMiningServer().getFunctionForDTO(extractionFunction).getReturnType();
    }

    private HashSet<AggregationProcessorDefinitionDTO> aggregatorDefinitionsAsDTOs(Iterable<AggregationProcessorDefinition<?, ?>> definitions, String localeInfoName) {
        ResourceBundleStringMessages stringMessages = this.getDataMiningServer().getStringMessages();
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        HashSet<AggregationProcessorDefinitionDTO> definitionDTOs = new HashSet<AggregationProcessorDefinitionDTO>();
        for (AggregationProcessorDefinition<?, ?> definition : definitions) {
            definitionDTOs.add(this.dtoFactory.createAggregationProcessorDefinitionDTO(definition, stringMessages, locale));
        }
        return definitionDTOs;
    }

    public HashSet<FunctionDTO> getDimensionsFor(DataRetrieverChainDefinitionDTO dataRetrieverChainDefinitionDTO, String localeInfoName) {
        this.checkDataMiningPermission();
        Class retrievedType = this.getDataMiningServer().getDataRetrieverChainDefinitionForDTO(dataRetrieverChainDefinitionDTO).getRetrievedDataType();
        Iterable dimensions = this.getDataMiningServer().getDimensionsFor(retrievedType);
        return this.functionsAsDTOs(dimensions, localeInfoName);
    }

    public ReducedDimensionsDTO getReducedDimensionsMappedByLevelFor(DataRetrieverChainDefinitionDTO dataRetrieverChainDefinitionDTO, String localeInfoName) {
        this.checkDataMiningPermission();
        DataRetrieverChainDefinition dataRetrieverChainDefinition = this.getDataMiningServer().getDataRetrieverChainDefinitionForDTO(dataRetrieverChainDefinitionDTO);
        ReducedDimensions reducedDimensions = this.getDataMiningServer().getReducedDimensionsMappedByLevelFor(dataRetrieverChainDefinition);
        return this.reducedDimensionsAsDTO(reducedDimensions, localeInfoName);
    }

    private ReducedDimensionsDTO reducedDimensionsAsDTO(ReducedDimensions dimensions, String localeInfoName) {
        HashMap<DataRetrieverLevelDTO, HashSet> dimensionDTOs = new HashMap<DataRetrieverLevelDTO, HashSet>();
        ResourceBundleStringMessages stringMessages = this.getDataMiningServer().getStringMessages();
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        for (Map.Entry dimensionsEntry : dimensions.getReducedDimensions().entrySet()) {
            dimensionDTOs.put(this.dtoFactory.createDataRetrieverLevelDTO((DataRetrieverLevel)dimensionsEntry.getKey(), stringMessages, locale), this.functionsAsDTOs((Iterable)dimensionsEntry.getValue(), localeInfoName));
        }
        HashMap<FunctionDTO, FunctionDTO> fromOriginalToReducedDTO = new HashMap<FunctionDTO, FunctionDTO>();
        for (Map.Entry fromOriginalToReduced : dimensions.getFromOriginalDimensionToReducedDimension().entrySet()) {
            fromOriginalToReducedDTO.put(this.dtoFactory.createFunctionDTO((Function)fromOriginalToReduced.getKey(), stringMessages, locale), this.dtoFactory.createFunctionDTO((Function)fromOriginalToReduced.getValue(), stringMessages, locale));
        }
        return new ReducedDimensionsDTO(dimensionDTOs, fromOriginalToReducedDTO);
    }

    private HashSet<FunctionDTO> functionsAsDTOs(Iterable<Function<?>> functions, String localeInfoName) {
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        ResourceBundleStringMessages stringMessages = this.getDataMiningServer().getStringMessages();
        HashSet<FunctionDTO> functionDTOs = new HashSet<FunctionDTO>();
        for (Function<?> function : functions) {
            functionDTOs.add(this.dtoFactory.createFunctionDTO(function, stringMessages, locale));
        }
        return functionDTOs;
    }

    public ArrayList<DataRetrieverChainDefinitionDTO> getDataRetrieverChainDefinitions(String localeInfoName) {
        this.checkDataMiningPermission();
        Iterable dataRetrieverChainDefinitions = this.getDataMiningServer().getDataRetrieverChainDefinitions();
        return this.dataRetrieverChainDefinitionsAsDTOs(dataRetrieverChainDefinitions, localeInfoName);
    }

    public ArrayList<DataRetrieverChainDefinitionDTO> getDataRetrieverChainDefinitionsFor(FunctionDTO statisticToCalculate, String localeInfoName) {
        this.checkDataMiningPermission();
        Class baseDataType = this.getBaseDataType(statisticToCalculate);
        Iterable dataRetrieverChainDefinitions = this.getDataMiningServer().getDataRetrieverChainDefinitionsByDataType(baseDataType);
        return this.dataRetrieverChainDefinitionsAsDTOs(dataRetrieverChainDefinitions, localeInfoName);
    }

    private Class<?> getBaseDataType(FunctionDTO statisticToCalculate) {
        Function function = this.getDataMiningServer().getFunctionForDTO(statisticToCalculate);
        return function.getDeclaringType();
    }

    private ArrayList<DataRetrieverChainDefinitionDTO> dataRetrieverChainDefinitionsAsDTOs(Iterable<DataRetrieverChainDefinition<?, ?>> dataRetrieverChainDefinitions, String localeInfoName) {
        ResourceBundleStringMessages serverStringMessages = this.getDataMiningServer().getStringMessages();
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        ArrayList<DataRetrieverChainDefinitionDTO> DTOs = new ArrayList<DataRetrieverChainDefinitionDTO>();
        for (DataRetrieverChainDefinition<?, ?> dataRetrieverChainDefinition : dataRetrieverChainDefinitions) {
            DTOs.add(this.dtoFactory.createDataRetrieverChainDefinitionDTO(dataRetrieverChainDefinition, serverStringMessages, locale));
        }
        return DTOs;
    }

    public QueryResultDTO<HashSet<Object>> getDimensionValuesFor(DataMiningSession session, DataRetrieverChainDefinitionDTO dataRetrieverChainDefinitionDTO, DataRetrieverLevelDTO retrieverLevelDTO, HashSet<FunctionDTO> dimensionDTOs, HashMap<DataRetrieverLevelDTO, SerializableSettings> retrieverSettingsDTO, HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelectionDTO, String localeInfoName) {
        QueryResultImpl result;
        this.checkDataMiningPermission();
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        DataRetrieverChainDefinition retrieverChainDefinition = dataMiningServer.getDataRetrieverChainDefinitionForDTO(dataRetrieverChainDefinitionDTO);
        DataRetrieverLevel retrieverLevel = retrieverChainDefinition.getDataRetrieverLevel(retrieverLevelDTO.getLevel());
        Collection dimensions = this.functionDTOsAsFunctions(dimensionDTOs);
        ArrayList<Function> nonBoolNonEnumResultDimensions = new ArrayList<Function>();
        LinkedHashMap<Function, List<Boolean>> boolOrEnumResultDimensionsWithValues = new LinkedHashMap<Function, List<Boolean>>();
        for (Function dimensionFunction : dimensions) {
            if (dimensionFunction.getReturnType() == Boolean.TYPE || dimensionFunction.getReturnType() == Boolean.class) {
                boolOrEnumResultDimensionsWithValues.put(dimensionFunction, Arrays.asList(true, false));
                continue;
            }
            if (dimensionFunction.getReturnType().isEnum()) {
                boolOrEnumResultDimensionsWithValues.put(dimensionFunction, Arrays.asList(dimensionFunction.getReturnType().getEnumConstants()));
                continue;
            }
            nonBoolNonEnumResultDimensions.add(dimensionFunction);
        }
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        if (!nonBoolNonEnumResultDimensions.isEmpty()) {
            Map retrieverSettings = this.retrieverSettingsDTOAsRetrieverSettings(retrieverSettingsDTO, retrieverChainDefinition);
            Map filterSelection = this.filterSelectionDTOAsFilterSelection(filterSelectionDTO, retrieverChainDefinition);
            Query dimensionValuesQuery = dataMiningServer.createDimensionValuesQuery(retrieverChainDefinition, retrieverLevel, nonBoolNonEnumResultDimensions, retrieverSettings, filterSelection, locale);
            result = (ExtensibleQueryResult)dataMiningServer.runNewQueryAndAbortPreviousQueries(session, dimensionValuesQuery);
        } else {
            Class<?> clazz = new HashSet().getClass();
            result = new QueryResultImpl(QueryResultState.NORMAL, clazz, new HashMap());
        }
        for (Map.Entry e : boolOrEnumResultDimensionsWithValues.entrySet()) {
            result.addResult((GroupKey)new GenericGroupKey((Object)this.dtoFactory.createFunctionDTO((Function)e.getKey(), this.getDataMiningServer().getStringMessages(), locale)), new LinkedHashSet((Collection)e.getValue()));
        }
        return this.dtoFactory.createResultDTO((QueryResult)result);
    }

    private Collection<Function<?>> functionDTOsAsFunctions(Iterable<FunctionDTO> functionDTOs) {
        ArrayList functions = new ArrayList();
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        for (FunctionDTO functionDTO : functionDTOs) {
            Function function = dataMiningServer.getFunctionForDTO(functionDTO);
            if (function == null) continue;
            functions.add(function);
        }
        return functions;
    }

    private Map<DataRetrieverLevel<?, ?>, SerializableSettings> retrieverSettingsDTOAsRetrieverSettings(HashMap<DataRetrieverLevelDTO, SerializableSettings> retrieverSettingsDTO, DataRetrieverChainDefinition<RacingEventService, ?> retrieverChainDefinition) {
        HashMap retrieverSettings = new HashMap();
        for (DataRetrieverLevelDTO retrieverLevelDTO : retrieverSettingsDTO.keySet()) {
            DataRetrieverLevel retrieverLevel = retrieverChainDefinition.getDataRetrieverLevel(retrieverLevelDTO.getLevel());
            retrieverSettings.put(retrieverLevel, retrieverSettingsDTO.get(retrieverLevelDTO));
        }
        return retrieverSettings;
    }

    private Map<DataRetrieverLevel<?, ?>, Map<Function<?>, Collection<?>>> filterSelectionDTOAsFilterSelection(HashMap<DataRetrieverLevelDTO, HashMap<FunctionDTO, HashSet<? extends Serializable>>> filterSelectionDTO, DataRetrieverChainDefinition<?, ?> retrieverChainDefinition) {
        HashMap filterSelection = new HashMap();
        for (DataRetrieverLevelDTO retrieverLevelDTO : filterSelectionDTO.keySet()) {
            HashMap<FunctionDTO, HashSet<? extends Serializable>> retrievalLevelSelection = filterSelectionDTO.get(retrieverLevelDTO);
            for (FunctionDTO dimensionDTO : retrievalLevelSelection.keySet()) {
                if (retrievalLevelSelection.get(dimensionDTO).isEmpty()) continue;
                Function function = this.getDataMiningServer().getFunctionForDTO(dimensionDTO);
                DataRetrieverLevel retrieverLevel = retrieverChainDefinition.getDataRetrieverLevel(retrieverLevelDTO.getLevel());
                if (function == null) continue;
                if (!filterSelection.containsKey(retrieverLevel)) {
                    filterSelection.put(retrieverLevel, new HashMap());
                }
                ((Map)filterSelection.get(retrieverLevel)).put(function, (Collection)retrievalLevelSelection.get(dimensionDTO));
            }
        }
        return filterSelection;
    }

    public <ResultType extends Serializable> QueryResultDTO<ResultType> runQuery(DataMiningSession session, ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO) {
        this.checkDataMiningPermission();
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        StatisticQueryDefinition queryDefinition = dataMiningServer.getQueryDefinitionForDTO((StatisticQueryDefinitionDTO)queryDefinitionDTO);
        Query query = dataMiningServer.createQuery(queryDefinition);
        logger.info("Handing query " + query + " to server for processing on behalf of user " + SessionUtils.getPrincipal());
        QueryResult result = dataMiningServer.runNewQueryAndAbortPreviousQueries(session, query);
        logger.info("Obtained result for query " + query + " from server on behalf of user " + SessionUtils.getPrincipal());
        return this.dtoFactory.createResultDTO(result);
    }

    public HashSet<PredefinedQueryIdentifier> getPredefinedQueryIdentifiers() {
        this.checkDataMiningPermission();
        HashSet<PredefinedQueryIdentifier> predefinedQueryNames = new HashSet<PredefinedQueryIdentifier>();
        for (PredefinedQueryIdentifier predefinedQueryName : this.getDataMiningServer().getPredefinedQueryIdentifiers()) {
            predefinedQueryNames.add(predefinedQueryName);
        }
        return predefinedQueryNames;
    }

    public ModifiableStatisticQueryDefinitionDTO getPredefinedQueryDefinition(PredefinedQueryIdentifier identifier, String localeInfoName) {
        this.checkDataMiningPermission();
        return this.localize(this.getDataMiningServer().getPredefinedQueryDefinitionDTO(identifier), localeInfoName);
    }

    public <ResultType extends Serializable> QueryResultDTO<ResultType> runPredefinedQuery(DataMiningSession session, PredefinedQueryIdentifier identifier, String localeInfoName) {
        this.checkDataMiningPermission();
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO = dataMiningServer.getPredefinedQueryDefinitionDTO(identifier);
        if (queryDefinitionDTO != null) {
            queryDefinitionDTO.setLocaleInfoName(localeInfoName);
            return this.runQuery(session, queryDefinitionDTO);
        }
        return null;
    }

    public ModifiableStatisticQueryDefinitionDTO localize(ModifiableStatisticQueryDefinitionDTO queryDefinitionDTO, String localeInfoName) {
        this.checkDataMiningPermission();
        DataMiningServer dataMiningServer = this.getDataMiningServer();
        StatisticQueryDefinition queryDefinition = dataMiningServer.getQueryDefinitionForDTO((StatisticQueryDefinitionDTO)queryDefinitionDTO);
        Locale locale = ResourceBundleStringMessages.Util.getLocaleFor((String)localeInfoName);
        return (ModifiableStatisticQueryDefinitionDTO)this.dtoFactory.createQueryDefinitionDTO(queryDefinition, dataMiningServer.getStringMessages(), locale, localeInfoName);
    }

    public ArrayList<StoredDataMiningQueryDTOImpl> retrieveStoredQueries() {
        this.checkDataMiningPermission();
        return this.storedDataMiningQueryPersistor.retrieveStoredQueries();
    }

    public ModifiableStatisticQueryDefinitionDTO getDeserializedQuery(String serializedQuery) {
        return (ModifiableStatisticQueryDefinitionDTO)((DataMiningServer)this.dataMiningServerTracker.getService()).fromBase64String(serializedQuery);
    }

    public ArrayList<StoredDataMiningReportDTOImpl> retrieveStoredReports() throws UnauthorizedException {
        this.checkDataMiningPermission();
        return this.storedDataMiningReportPersistor.getStoredReports();
    }

    public SerializationDummy pseudoMethodSoThatSomeClassesAreAddedToTheGWTSerializationPolicy() {
        return null;
    }
}

