/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.FormattedDoubleLeaderboardRowDTODetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.HeelColumn;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.LegColumn;
import com.sap.sailing.gwt.ui.leaderboard.PitchColumn;
import com.sap.sailing.gwt.ui.leaderboard.RankGainColumn;
import com.sap.sailing.gwt.ui.leaderboard.RideHeightColumn;
import com.sap.sailing.gwt.ui.leaderboard.SideToWhichMarkAtLegStartWasRoundedColumn;
import com.sap.sailing.gwt.ui.leaderboard.SortableExpandableColumnHeader;
import com.sap.sailing.gwt.ui.leaderboard.TotalTimeColumn;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.common.SortingOrder;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegColumn
extends ExpandableSortableColumn<String> {
    private final String raceColumnName;
    private final int legIndex;
    private final StringMessages stringMessages;
    private final String headerStyle;
    private final String columnStyle;

    public LegColumn(LeaderboardPanel<?> leaderboardPanel, String raceColumnName, int legIndex, SortingOrder preferredSortingOrder, StringMessages stringMessages, List<DetailType> legDetailSelection, String headerStyle, String columnStyle, String detailHeaderStyle, String detailColumnStyle) {
        super(leaderboardPanel, true, (Cell)new TextCell(), preferredSortingOrder, stringMessages, detailHeaderStyle, detailColumnStyle, legDetailSelection, leaderboardPanel);
        this.setHorizontalAlignment(ALIGN_CENTER);
        this.raceColumnName = raceColumnName;
        this.legIndex = legIndex;
        this.stringMessages = stringMessages;
        this.headerStyle = headerStyle;
        this.columnStyle = columnStyle;
    }

    protected Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getDetailColumnMap(LeaderboardPanel<?> leaderboardPanel, StringMessages stringMessages, String detailHeaderStyle, String detailColumnStyle) {
        HashMap result = new HashMap();
        result.put(DetailType.LEG_DISTANCE_TRAVELED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_DISTANCE_TRAVELED, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.distanceTraveledInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_DISTANCE_TRAVELED_INCLUDING_GATE_START, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_DISTANCE_TRAVELED_INCLUDING_GATE_START, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.distanceTraveledIncludingGateStartInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.averageSpeedOverGroundInKnots), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_CURRENT_SPEED_OVER_GROUND_IN_KNOTS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_CURRENT_SPEED_OVER_GROUND_IN_KNOTS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentSpeedOverGroundInKnots), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.BRAVO_LEG_CURRENT_HEEL_IN_DEGREES, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new HeelColumn(DetailType.BRAVO_LEG_CURRENT_HEEL_IN_DEGREES, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentHeelInDegrees), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.BRAVO_LEG_CURRENT_PITCH_IN_DEGREES, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new PitchColumn(DetailType.BRAVO_LEG_CURRENT_PITCH_IN_DEGREES, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentPitchInDegrees), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.BRAVO_LEG_CURRENT_RIDE_HEIGHT_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new RideHeightColumn(DetailType.BRAVO_LEG_CURRENT_RIDE_HEIGHT_IN_METERS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentRideHeightInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.BRAVOEXTENDED_LEG_CURRENT_DISTANCE_FOILED_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.BRAVOEXTENDED_LEG_CURRENT_DISTANCE_FOILED_IN_METERS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentDistanceFoiledInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.BRAVOEXTENDED_LEG_CURRENT_DURATION_FOILED_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.BRAVOEXTENDED_LEG_CURRENT_DURATION_FOILED_IN_SECONDS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentDurationFoiledInSeconds), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_ESTIMATED_TIME_TO_NEXT_WAYPOINT_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_ESTIMATED_TIME_TO_NEXT_WAYPOINT_IN_SECONDS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.estimatedTimeToNextWaypointInSeconds), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_GAP_TO_LEADER_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_GAP_TO_LEADER_IN_SECONDS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.gapToLeaderInSeconds), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_GAP_CHANGE_SINCE_LEG_START_IN_SECONDS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_GAP_CHANGE_SINCE_LEG_START_IN_SECONDS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.gapChangeSinceLegStartInSeconds), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_SIDE_TO_WHICH_MARK_AT_LEG_START_WAS_ROUNDED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new SideToWhichMarkAtLegStartWasRoundedColumn(stringMessages.sideToWhichMarkAtLegStartWasRounded(), (DetailTypeColumn.DataExtractor)new SideToWhichMarkAtLegStartWasRounded(this, null), detailHeaderStyle, detailColumnStyle, stringMessages, leaderboardPanel));
        result.put(DetailType.LEG_VELOCITY_MADE_GOOD_IN_KNOTS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_VELOCITY_MADE_GOOD_IN_KNOTS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.velocityMadeGoodInKnots), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.windwardDistanceToGoInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_RANK_GAIN, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new RankGainColumn(stringMessages.rankGain(), (DetailTypeColumn.DataExtractor)new RankGain(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.NUMBER_OF_MANEUVERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new ManeuverCountLegDetailsColumn(this, detailHeaderStyle, detailColumnStyle));
        result.put(DetailType.LEG_TIME_TRAVELED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.LEG_TIME_TRAVELED, (DetailTypeColumn.DataExtractor)new TimeTraveledInSeconds(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_CORRECTED_TIME_TRAVELED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.LEG_CORRECTED_TIME_TRAVELED, (DetailTypeColumn.DataExtractor)new DurationAsSecondsDetailTypeExtractor(this, e -> e.correctedTotalTime), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentOrAverageAbsoluteCrossTrackErrorInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.LEG_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.LEG_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, e -> e.currentOrAverageSignedCrossTrackErrorInMeters), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_AWA, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_AWA, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionAWA), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_AWS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_AWS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionAWS), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TWA, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TWA, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTWA), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TWS, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TWS, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTWS), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TWD, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TWD, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTWD), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TARG_TWA, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TARG_TWA, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTargTWA), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_BOAT_SPEED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_BOAT_SPEED, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionBoatSpeed), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TARG_BOAT_SPEED, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TARG_BOAT_SPEED, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTargBoatSpeed), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_SOG, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_SOG, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionSOG), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_COG, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_COG, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionCOG), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_FORESTAY_LOAD, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_FORESTAY_LOAD, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionForestayLoad), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_RAKE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_RAKE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionRake), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_COURSE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_COURSE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionCourseDetail), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_HEADING, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_HEADING, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionHeading), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_VMG, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_VMG, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionVMG), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_VMG_TARG_VMG_DELTA, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_VMG_TARG_VMG_DELTA, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionVMGTargVMGDelta), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_RATE_OF_TURN, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_RATE_OF_TURN, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionRateOfTurn), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_RUDDER_ANGLE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_RUDDER_ANGLE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionRudderAngle), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TARGET_HEEL, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TARGET_HEEL, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTargetHeel), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_PORT_LAYLINE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_PORT_LAYLINE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToPortLayline), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_STB_LAYLINE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_STB_LAYLINE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToStbLayline), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_DIST_TO_PORT_LAYLINE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_DIST_TO_PORT_LAYLINE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionDistToPortLayline), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_DIST_TO_STB_LAYLINE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_DIST_TO_STB_LAYLINE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionDistToStbLayline), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_GUN, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_GUN, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToGUN), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_COMMITTEE_BOAT, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_COMMITTEE_BOAT, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToCommitteeBoat), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_PIN, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_PIN, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToPin), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_LINE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_LINE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToBurnToLineInSeconds), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_COMMITTEE_BOAT, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_COMMITTEE_BOAT, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToBurnToCommitteeBoat), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_PIN, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_TIME_TO_BURN_TO_PIN, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionTimeToBurnToPin), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_DISTANCE_TO_COMMITTEE_BOAT, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_DISTANCE_TO_COMMITTEE_BOAT, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionDistanceToCommitteeBoat), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_DISTANCE_TO_PIN, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_DISTANCE_TO_PIN, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionDistanceToPinDetail), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_DISTANCE_BELOW_LINE, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_DISTANCE_BELOW_LINE, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionDistanceBelowLine), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_LINE_SQUARE_FOR_WIND_DIRECTION, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_LINE_SQUARE_FOR_WIND_DIRECTION, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionLineSquareForWindDirection), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_BARO, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_BARO, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionBaro), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_LOAD_S, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_LOAD_S, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionLoadS), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_LOAD_P, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_LOAD_P, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionLoadP), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_JIB_CAR_PORT, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_JIB_CAR_PORT, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionJibCarPort), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_JIB_CAR_STBD, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_JIB_CAR_STBD, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionJibCarStbd), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_LEG_MAST_BUTT, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_LEG_MAST_BUTT, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionMastButt), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.EXPEDITION_RACE_KICKER_TENSION, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new FormattedDoubleLeaderboardRowDTODetailTypeColumn(DetailType.EXPEDITION_RACE_KICKER_TENSION, (DetailTypeColumn.DataExtractor)new DoubleDetailTypeExtractor(this, LegEntryDTO::getExpeditionKickerTension), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        return result;
    }

    private int getLegIndex() {
        return this.legIndex;
    }

    public String getColumnStyle() {
        return this.columnStyle;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    private String getRaceName() {
        return this.raceColumnName;
    }

    private LegEntryDTO getLegEntry(LeaderboardRowDTO row) {
        int theLegIndex = this.getLegIndex();
        return this.getLegEntry(row, theLegIndex);
    }

    private LegEntryDTO getLegEntry(LeaderboardRowDTO row, int theLegIndex) {
        LegEntryDTO legEntry = null;
        LeaderboardEntryDTO entry = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(this.getRaceName());
        if (entry != null && entry.legDetails != null && entry.legDetails.size() > theLegIndex) {
            legEntry = (LegEntryDTO)entry.legDetails.get(theLegIndex);
        }
        return legEntry;
    }

    public InvertibleComparator<LeaderboardRowDTO> getComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public SortableExpandableColumnHeader getHeader() {
        SortableExpandableColumnHeader result = new SortableExpandableColumnHeader(String.valueOf(this.stringMessages.leg()) + (this.legIndex + 1), null, this.getLeaderboardPanel(), (ExpandableSortableColumn)this, this.stringMessages);
        return result;
    }

    public String getValue(LeaderboardRowDTO row) {
        LeaderboardEntryDTO leaderboardEntryDTO = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(this.raceColumnName);
        LegEntryDTO legEntry = this.getLegEntry(row);
        if (legEntry != null && legEntry.rank != 0) {
            return "" + legEntry.rank;
        }
        if (leaderboardEntryDTO != null && leaderboardEntryDTO.legDetails != null && this.legIndex + 1 > leaderboardEntryDTO.legDetails.size()) {
            return "n/a";
        }
        return "";
    }

    static /* synthetic */ LegEntryDTO access$2(LegColumn legColumn, LeaderboardRowDTO leaderboardRowDTO) {
        return legColumn.getLegEntry(leaderboardRowDTO);
    }

    static /* synthetic */ int access$3(LegColumn legColumn) {
        return legColumn.getLegIndex();
    }

    static /* synthetic */ LegEntryDTO access$4(LegColumn legColumn, LeaderboardRowDTO leaderboardRowDTO, int n) {
        return legColumn.getLegEntry(leaderboardRowDTO, n);
    }

    static /* synthetic */ StringMessages access$5(LegColumn legColumn) {
        return legColumn.stringMessages;
    }
}

