/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.shared.racemap.Colorline;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.FixesAndTails;
import com.sap.sailing.gwt.ui.client.shared.racemap.TailFactory;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegTypeIterable;
import com.sap.sse.common.Duration;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.ValueRangeFlexibleBoundaries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class FixesAndTails {
    private static final Duration MAX_DURATION_FOR_QUICK_REQUESTS = Duration.ONE_SECOND.times(10L);
    private final Map<String, List<GPSFixDTOWithSpeedWindTackAndLegType>> fixesByCompetitorIdsAsStrings;
    private final Map<String, Colorline> tailsByCompetitorIdsAsStrings;
    private final Map<String, Integer> firstShownFixByCompetitorIdsAsStrings;
    private final Map<String, Integer> lastShownFixByCompetitorIdsAsStrings;
    private final Map<String, TimeRange> timeRangesRequestedByCompetitorIdAsString;
    private final Map<String, Integer> minDetailValueFixByCompetitorIdsAsStrings;
    private final Map<String, Integer> maxDetailValueFixByCompetitorIdsAsStrings;
    private ValueRangeFlexibleBoundaries detailValueBoundaries;
    private final CoordinateSystem coordinateSystem;
    private final Map<String, DetailType> detailTypesRequestedByCompetitorIdsAsStrings;
    private final Set<PositionRequest> inFlightRequests;

    public FixesAndTails(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        this.detailTypesRequestedByCompetitorIdsAsStrings = new HashMap();
        this.fixesByCompetitorIdsAsStrings = new HashMap();
        this.tailsByCompetitorIdsAsStrings = new HashMap();
        this.firstShownFixByCompetitorIdsAsStrings = new HashMap();
        this.lastShownFixByCompetitorIdsAsStrings = new HashMap();
        this.minDetailValueFixByCompetitorIdsAsStrings = new HashMap();
        this.maxDetailValueFixByCompetitorIdsAsStrings = new HashMap();
        this.inFlightRequests = new HashSet();
        this.timeRangesRequestedByCompetitorIdAsString = new HashMap();
    }

    public List<GPSFixDTOWithSpeedWindTackAndLegType> getFixes(CompetitorDTO competitor) {
        List competitorFixes = (List)this.fixesByCompetitorIdsAsStrings.get(competitor.getIdAsString());
        return competitorFixes == null ? null : Collections.unmodifiableList(competitorFixes);
    }

    public Colorline getTail(CompetitorDTO competitor) {
        return (Colorline)this.tailsByCompetitorIdsAsStrings.get(competitor.getIdAsString());
    }

    public Integer getFirstShownFix(CompetitorDTO competitor) {
        return (Integer)this.firstShownFixByCompetitorIdsAsStrings.get(competitor.getIdAsString());
    }

    public Set<String> getCompetitorIdsAsStringWithTails() {
        return Collections.unmodifiableSet(this.tailsByCompetitorIdsAsStrings.keySet());
    }

    public boolean hasFixesFor(CompetitorDTO competitor) {
        return this.fixesByCompetitorIdsAsStrings.containsKey(competitor.getIdAsString());
    }

    protected long getMillisecondsBetweenExtrapolatedAndLastNonExtrapolatedFix(CompetitorDTO competitor) {
        long result;
        List competitorFixes = this.getFixes(competitor);
        if (competitorFixes == null || competitorFixes.size() < 2 || !((GPSFixDTOWithSpeedWindTackAndLegType)competitorFixes.get((int)(competitorFixes.size() - 1))).extrapolated) {
            result = 0L;
        } else {
            GPSFixDTOWithSpeedWindTackAndLegType extrapolatedFix = (GPSFixDTOWithSpeedWindTackAndLegType)competitorFixes.get(competitorFixes.size() - 1);
            GPSFixDTOWithSpeedWindTackAndLegType fixBeforeExtrapolated = (GPSFixDTOWithSpeedWindTackAndLegType)competitorFixes.get(competitorFixes.size() - 2);
            result = extrapolatedFix.timepoint.getTime() - fixBeforeExtrapolated.timepoint.getTime();
        }
        return result;
    }

    protected Colorline createTailAndUpdateIndices(CompetitorDTO competitorDTO, Date from, Date to, TailFactory tailFactory, DetailType detailTypeToShow) {
        if (detailTypeToShow != null && this.detailTypesRequestedByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString()) != detailTypeToShow) {
            GWT.log((String)("WARNING: Detail type mismatch in createTailAndUpdateIndices: have " + this.detailTypesRequestedByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString()) + " but caller expected " + detailTypeToShow));
        }
        Colorline result = tailFactory.createTail(competitorDTO, Collections.emptyList());
        this.tailsByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), result);
        this.fillEmptyTail(competitorDTO, from, to, detailTypeToShow != null);
        return result;
    }

    private void updateFixes(CompetitorDTO competitor, GPSFixDTOWithSpeedWindTackAndLegTypeIterable fixesToAddForCompetitor, boolean mustClearCache, long timeForPositionTransitionMillis, DetailType detailTypeForFixes) {
        List fixesForCompetitor = this.fixesByCompetitorIdsAsStrings.computeIfAbsent(competitor.getIdAsString(), c -> {
            ArrayList f = new ArrayList();
            this.fixesByCompetitorIdsAsStrings.put(c, f);
            return f;
        });
        if (mustClearCache) {
            fixesForCompetitor.clear();
            this.detailTypesRequestedByCompetitorIdsAsStrings.put(competitor.getIdAsString(), detailTypeForFixes);
            this.clearTail(competitor);
            Util.addAll((Iterable)fixesToAddForCompetitor, (Collection)fixesForCompetitor);
        } else {
            if (detailTypeForFixes != null && this.detailTypesRequestedByCompetitorIdsAsStrings.get(competitor.getIdAsString()) != detailTypeForFixes) {
                GWT.log((String)("WARNING: Inconsistent detail types when merging fixed for competitor " + competitor + ". Got fixes with " + this.detailTypesRequestedByCompetitorIdsAsStrings.get(competitor.getIdAsString()) + " so far but now received fixes with " + detailTypeForFixes));
            }
            this.mergeFixes(competitor, fixesToAddForCompetitor, timeForPositionTransitionMillis);
        }
    }

    private void mergeFixes(CompetitorDTO competitorDTO, GPSFixDTOWithSpeedWindTackAndLegTypeIterable mergeThis, long timeForPositionTransitionMillis) {
        List intoThis = (List)this.fixesByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        Integer firstShownFixForCompetitor = (Integer)this.firstShownFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        int indexOfFirstShownFix = firstShownFixForCompetitor == null ? -1 : firstShownFixForCompetitor;
        Integer lastShownFixForCompetitor = (Integer)this.lastShownFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        int indexOfLastShownFix = lastShownFixForCompetitor == null ? -2 : lastShownFixForCompetitor;
        Colorline tail = this.getTail(competitorDTO);
        1 fixByTimePointComparator = new /* Unavailable Anonymous Inner Class!! */;
        for (GPSFixDTOWithSpeedWindTackAndLegType mergeThisFix : mergeThis) {
            boolean indicesChanged;
            Integer maxIndex;
            int intoThisIndex = Collections.binarySearch(intoThis, mergeThisFix, fixByTimePointComparator);
            if (intoThisIndex < 0) {
                intoThisIndex = -intoThisIndex - 1;
            }
            if (intoThisIndex < intoThis.size() && ((GPSFixDTOWithSpeedWindTackAndLegType)intoThis.get((int)intoThisIndex)).timepoint.equals(mergeThisFix.timepoint)) {
                if (!mergeThisFix.extrapolated || intoThis.size() == intoThisIndex + 1) {
                    Double oldDetailValue = intoThis.set((int)intoThisIndex, mergeThisFix).detailValue;
                    if (tail == null || intoThisIndex < indexOfFirstShownFix || intoThisIndex > indexOfLastShownFix) continue;
                    this.adjustMinMaxForReplaced(competitorDTO, intoThisIndex, oldDetailValue, intoThis);
                    tail.setAt(intoThisIndex - indexOfFirstShownFix, this.coordinateSystem.toLatLng(mergeThisFix.position));
                    continue;
                }
                intoThis.remove(intoThisIndex);
                if (tail != null && intoThisIndex >= indexOfFirstShownFix && intoThisIndex <= indexOfLastShownFix) {
                    this.adjustMinMaxForRemoved(competitorDTO, intoThisIndex);
                    tail.removeAt(intoThisIndex - indexOfFirstShownFix);
                }
                Integer minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
                maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
                if (minIndex != null) {
                    if (intoThisIndex < minIndex) {
                        this.minDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), minIndex - 1);
                    } else if (intoThisIndex == minIndex) {
                        this.minDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
                    }
                }
                if (maxIndex != null) {
                    if (intoThisIndex < maxIndex) {
                        this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), maxIndex - 1);
                    } else if (intoThisIndex == maxIndex) {
                        this.maxDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
                    }
                }
                indicesChanged = false;
                if (intoThisIndex < indexOfFirstShownFix) {
                    --indexOfFirstShownFix;
                    indicesChanged = true;
                }
                if (intoThisIndex <= indexOfLastShownFix) {
                    --indexOfLastShownFix;
                    indicesChanged = true;
                }
                if (indicesChanged) {
                    this.updateTailBoundaries(competitorDTO, indexOfFirstShownFix, indexOfLastShownFix);
                }
                --intoThisIndex;
                continue;
            }
            if (mergeThisFix.extrapolated && intoThisIndex != intoThis.size()) continue;
            intoThis.add(intoThisIndex, mergeThisFix);
            Integer minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
            maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
            if (minIndex != null && intoThisIndex <= minIndex) {
                this.minDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), minIndex + 1);
            }
            if (maxIndex != null && intoThisIndex <= maxIndex) {
                this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), maxIndex + 1);
            }
            if (tail != null && intoThisIndex >= indexOfFirstShownFix && intoThisIndex <= indexOfLastShownFix) {
                this.adjustMinMaxForInserted(competitorDTO, intoThisIndex, intoThis);
                tail.insertAt(intoThisIndex - indexOfFirstShownFix, this.coordinateSystem.toLatLng(mergeThisFix.position));
            }
            boolean indicesChanged2 = false;
            if (intoThisIndex < indexOfFirstShownFix) {
                ++indexOfFirstShownFix;
                indicesChanged2 = true;
            }
            if (intoThisIndex <= indexOfLastShownFix) {
                ++indexOfLastShownFix;
                indicesChanged2 = true;
            }
            if (indicesChanged2) {
                this.updateTailBoundaries(competitorDTO, indexOfFirstShownFix, indexOfLastShownFix);
            }
            if (intoThisIndex <= 0 || !((GPSFixDTOWithSpeedWindTackAndLegType)intoThis.get((int)(intoThisIndex - 1))).extrapolated) continue;
            intoThis.remove(intoThisIndex - 1);
            if (tail != null && intoThisIndex - 1 >= indexOfFirstShownFix && intoThisIndex - 1 <= indexOfLastShownFix) {
                this.adjustMinMaxForRemoved(competitorDTO, intoThisIndex - 1);
                tail.removeAt(intoThisIndex - 1 - indexOfFirstShownFix);
            }
            minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
            maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
            if (minIndex != null && intoThisIndex - 1 <= minIndex) {
                this.minDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), minIndex - 1);
            }
            if (maxIndex != null && intoThisIndex - 1 <= maxIndex) {
                this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), maxIndex - 1);
            }
            indicesChanged = false;
            if (intoThisIndex - 1 < indexOfFirstShownFix) {
                --indexOfFirstShownFix;
                indicesChanged = true;
            }
            if (intoThisIndex - 1 <= indexOfLastShownFix) {
                --indexOfLastShownFix;
                indicesChanged = true;
            }
            if (!indicesChanged) continue;
            this.updateTailBoundaries(competitorDTO, indexOfFirstShownFix, indexOfLastShownFix);
        }
    }

    private void adjustMinMaxForInserted(CompetitorDTO competitorDTO, int insertedFixIndex, List<GPSFixDTOWithSpeedWindTackAndLegType> competitorFixes) {
        Integer maxIndex;
        GPSFixDTOWithSpeedWindTackAndLegType insertedFix = competitorFixes.get(insertedFixIndex);
        Integer minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        if (minIndex != null) {
            GPSFixDTOWithSpeedWindTackAndLegType minFix = competitorFixes.get(minIndex);
            if (minFix.detailValue != null && insertedFix.detailValue != null && insertedFix.detailValue < minFix.detailValue) {
                this.minDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), insertedFixIndex);
            }
        }
        if ((maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString())) != null) {
            GPSFixDTOWithSpeedWindTackAndLegType maxFix = competitorFixes.get(maxIndex);
            if (maxFix.detailValue != null && insertedFix.detailValue != null && insertedFix.detailValue > maxFix.detailValue) {
                this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), insertedFixIndex);
            }
        }
    }

    private void adjustMinMaxForRemoved(CompetitorDTO competitorDTO, int removedFixIndex) {
        Integer maxIndex;
        Integer minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        if (minIndex != null && minIndex == removedFixIndex) {
            this.minDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
        }
        if ((maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString())) != null && maxIndex == removedFixIndex) {
            this.maxDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
        }
    }

    private void adjustMinMaxForReplaced(CompetitorDTO competitorDTO, int replacedFixIndex, Double oldDetailValue, List<GPSFixDTOWithSpeedWindTackAndLegType> competitorFixes) {
        Integer maxIndex;
        GPSFixDTOWithSpeedWindTackAndLegType newFix = competitorFixes.get(replacedFixIndex);
        Integer minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        if (minIndex != null) {
            if (minIndex == replacedFixIndex) {
                if (newFix.detailValue == null || newFix.detailValue > oldDetailValue) {
                    this.minDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
                }
            } else {
                GPSFixDTOWithSpeedWindTackAndLegType minFix = competitorFixes.get(minIndex);
                if (newFix.detailValue != null && minFix.detailValue != null && newFix.detailValue < minFix.detailValue) {
                    this.minDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), replacedFixIndex);
                }
            }
        }
        if ((maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString())) != null) {
            if (maxIndex == replacedFixIndex) {
                if (newFix.detailValue == null || newFix.detailValue < oldDetailValue) {
                    this.maxDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
                }
            } else {
                GPSFixDTOWithSpeedWindTackAndLegType maxFix = competitorFixes.get(maxIndex);
                if (newFix.detailValue != null && maxFix.detailValue != null && newFix.detailValue > maxFix.detailValue) {
                    this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), replacedFixIndex);
                }
            }
        }
    }

    private void updateTailBoundaries(CompetitorDTO competitorDTO, int indexOfFirstShownFix, int indexOfLastShownFix) {
        if (indexOfFirstShownFix > indexOfLastShownFix || indexOfFirstShownFix < 0 && indexOfLastShownFix < 0) {
            this.firstShownFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
            this.lastShownFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
        } else {
            this.firstShownFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), indexOfFirstShownFix);
            this.lastShownFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), indexOfLastShownFix);
        }
    }

    protected void updateTail(CompetitorDTO competitorDTO, Date from, Date to, int delayForTailChangeInMillis, DetailType selectedDetailType) {
        2 delayedOrImmediateExecutor = new /* Unavailable Anonymous Inner Class!! */;
        this.runDelayedOrImmediately((Timer)delayedOrImmediateExecutor, delayForTailChangeInMillis);
    }

    /*
     * Unable to fully structure code
     */
    private void fillEmptyTail(CompetitorDTO competitorDTO, Date from, Date to, boolean findMinAndMaxDetailValue) {
        block15: {
            first = -1;
            last = -1;
            minIndex = -1;
            maxIndex = -1;
            max = 4.9E-324;
            min = 1.7976931348623157E308;
            tail = this.getTail(competitorDTO);
            vertexCount = tail.getLength();
            if (vertexCount != 0) {
                throw new IllegalStateException("Can call fillEmptyTail only for empty tails; the tail of competitor " + competitorDTO + " contains " + vertexCount + " vertices");
            }
            competitorFixes = this.getFixes(competitorDTO);
            if (competitorFixes == null) break block15;
            i = 0;
            if (true) ** GOTO lbl31
            do {
                if (!fix.timepoint.before(from)) {
                    if (first == -1) {
                        first = i;
                        this.firstShownFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), first);
                    }
                    if (findMinAndMaxDetailValue) {
                        if (fix.detailValue != null && fix.detailValue < min) {
                            minIndex = i;
                            min = fix.detailValue;
                        }
                        if (fix.detailValue != null && fix.detailValue > max) {
                            maxIndex = i;
                            max = fix.detailValue;
                        }
                    }
                    tail.insertAt(vertexCount++, this.coordinateSystem.toLatLng(fix.position));
                    last = i;
                }
                ++i;
lbl31:
                // 2 sources

                if (i >= competitorFixes.size()) break;
                fix = (GPSFixDTOWithSpeedWindTackAndLegType)competitorFixes.get(i);
            } while (!fix.timepoint.after(to));
        }
        if (last < 0 && first >= 0) {
            GWT.log((String)("Inconsistency: last < 0 but first==" + first + " for competitor " + competitorDTO));
        }
        if (last != -1) {
            this.lastShownFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), last);
            if (findMinAndMaxDetailValue) {
                if (minIndex >= 0) {
                    this.minDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), minIndex);
                } else {
                    this.minDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
                }
                if (maxIndex >= 0) {
                    this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitorDTO.getIdAsString(), maxIndex);
                } else {
                    this.maxDetailValueFixByCompetitorIdsAsStrings.remove(competitorDTO.getIdAsString());
                }
            }
        } else {
            this.tailRemoved(competitorDTO.getIdAsString());
        }
    }

    private void runDelayedOrImmediately(Timer runThis, int delayForTailChangeInMillis) {
        if (delayForTailChangeInMillis == -1) {
            runThis.run();
        } else {
            runThis.schedule(delayForTailChangeInMillis);
        }
    }

    protected void removeTail(String competitorIdAsString) {
        Colorline removedTail = (Colorline)this.tailsByCompetitorIdsAsStrings.remove(competitorIdAsString);
        if (removedTail != null) {
            removedTail.setMap(null);
        }
        this.tailRemoved(competitorIdAsString);
    }

    private void tailRemoved(String competitorIdAsString) {
        this.firstShownFixByCompetitorIdsAsStrings.remove(competitorIdAsString);
        this.lastShownFixByCompetitorIdsAsStrings.remove(competitorIdAsString);
        this.minDetailValueFixByCompetitorIdsAsStrings.remove(competitorIdAsString);
        this.maxDetailValueFixByCompetitorIdsAsStrings.remove(competitorIdAsString);
    }

    private void clearTail(CompetitorDTO competitor) {
        Colorline tail = (Colorline)this.tailsByCompetitorIdsAsStrings.get(competitor.getIdAsString());
        if (tail != null) {
            tail.clear();
            this.tailRemoved(competitor.getIdAsString());
        }
    }

    protected Util.Pair<PositionRequest, PositionRequest> computeFromAndTo(Date upTo, Iterable<CompetitorDTO> competitorsToShow, long effectiveTailLengthInMilliseconds, long transitionTimeInMillis, DetailType detailType) {
        TimePoint upToTimePoint = TimePoint.of((Date)upTo);
        TimePoint tailstart = upToTimePoint.minus(effectiveTailLengthInMilliseconds);
        TimeRange quickTipTimeRange = TimeRange.create((TimePoint)upToTimePoint, (TimePoint)upToTimePoint);
        HashSet<String> mustClearCacheForTheseCompetitorIdsAsString = new HashSet<String>();
        TimeRange timeRangeNeeded = TimeRange.create((TimePoint)tailstart, (TimePoint)upToTimePoint);
        HashMap<String, TimeRange> timeRangesForQuickRequest = new HashMap<String, TimeRange>();
        HashMap<String, TimeRange> timeRangesForSlowRequest = new HashMap<String, TimeRange>();
        for (CompetitorDTO competitor : competitorsToShow) {
            TimeRange timeRangeNotToRequestAgain = this.getTimeRangeNotToRequestAgain(competitor);
            if (detailType != null && detailType != this.detailTypesRequestedByCompetitorIdsAsStrings.get(competitor.getIdAsString()) || timeRangeNotToRequestAgain != null && !timeRangeNeeded.touches(timeRangeNotToRequestAgain)) {
                mustClearCacheForTheseCompetitorIdsAsString.add(competitor.getIdAsString());
                this.ignoreResultsForCompetitorInPendingRequests(competitor);
                timeRangesForQuickRequest.put(competitor.getIdAsString(), quickTipTimeRange);
                timeRangesForSlowRequest.put(competitor.getIdAsString(), timeRangeNeeded);
                this.timeRangesRequestedByCompetitorIdAsString.put(competitor.getIdAsString(), timeRangeNeeded);
            } else if (timeRangeNotToRequestAgain == null) {
                timeRangesForQuickRequest.put(competitor.getIdAsString(), quickTipTimeRange);
                timeRangesForSlowRequest.put(competitor.getIdAsString(), timeRangeNeeded);
                this.timeRangesRequestedByCompetitorIdAsString.put(competitor.getIdAsString(), timeRangeNeeded);
            } else {
                MultiTimeRange timeRangesToRequest = timeRangeNeeded.subtract(timeRangeNotToRequestAgain);
                if (Util.size((Iterable)timeRangesToRequest) > 1) {
                    GWT.log((String)("Request for " + competitor + " exceeds cached region at start and end; requesting the full tail"));
                    timeRangesForQuickRequest.put(competitor.getIdAsString(), quickTipTimeRange);
                    timeRangesForSlowRequest.put(competitor.getIdAsString(), timeRangeNeeded);
                    this.timeRangesRequestedByCompetitorIdAsString.put(competitor.getIdAsString(), timeRangeNeeded);
                } else if (!Util.isEmpty((Iterable)timeRangesToRequest)) {
                    TimeRange timeRangeToRequest = (TimeRange)timeRangesToRequest.iterator().next();
                    if (timeRangeToRequest.startsBefore(timeRangeNotToRequestAgain)) {
                        timeRangesForSlowRequest.put(competitor.getIdAsString(), timeRangeToRequest);
                    } else if (timeRangeToRequest.getDuration().compareTo((Object)MAX_DURATION_FOR_QUICK_REQUESTS) <= 0) {
                        timeRangesForQuickRequest.put(competitor.getIdAsString(), timeRangeToRequest);
                    } else {
                        timeRangesForQuickRequest.put(competitor.getIdAsString(), TimeRange.create((TimePoint)timeRangeToRequest.to().minus(MAX_DURATION_FOR_QUICK_REQUESTS), (TimePoint)timeRangeToRequest.to()));
                        timeRangesForSlowRequest.put(competitor.getIdAsString(), TimeRange.create((TimePoint)timeRangeToRequest.from(), (TimePoint)timeRangeToRequest.to().minus(MAX_DURATION_FOR_QUICK_REQUESTS)));
                    }
                    this.timeRangesRequestedByCompetitorIdAsString.put(competitor.getIdAsString(), timeRangeToRequest.extend((TimeRange)this.timeRangesRequestedByCompetitorIdAsString.get(competitor.getIdAsString())));
                }
            }
            this.detailTypesRequestedByCompetitorIdsAsStrings.put(competitor.getIdAsString(), detailType);
        }
        PositionRequest quick = new PositionRequest(this, timeRangesForQuickRequest, mustClearCacheForTheseCompetitorIdsAsString, detailType, transitionTimeInMillis);
        PositionRequest slow = new PositionRequest(this, timeRangesForSlowRequest, quick);
        this.inFlightRequests.add(quick);
        this.inFlightRequests.add(slow);
        return new Util.Pair((Object)quick, (Object)slow);
    }

    private TimeRange getTimeRangeNotToRequestAgain(CompetitorDTO competitor) {
        TimePoint timePointOfLastFix;
        List fixesForCompetitor;
        TimeRange timeRangeRequestedForCompetitor = (TimeRange)this.timeRangesRequestedByCompetitorIdAsString.get(competitor.getIdAsString());
        boolean inFlightRequestWillClearCacheForCompetitor = false;
        for (PositionRequest inFlightRequest : this.inFlightRequests) {
            TimePoint competitorTimeRangeEnd;
            if (inFlightRequest.isMustClearCacheForCompetitor(competitor)) {
                inFlightRequestWillClearCacheForCompetitor = true;
            }
            if ((competitorTimeRangeEnd = inFlightRequest.getToTimepoint(competitor)) == null || !competitorTimeRangeEnd.equals(timeRangeRequestedForCompetitor.to())) continue;
            return timeRangeRequestedForCompetitor;
        }
        TimeRange result = inFlightRequestWillClearCacheForCompetitor ? timeRangeRequestedForCompetitor : ((fixesForCompetitor = this.getFixes(competitor)) == null ? timeRangeRequestedForCompetitor : ((timePointOfLastFix = TimePoint.of((Date)this.getTimepointOfLastNonExtrapolated(fixesForCompetitor))) == null ? timeRangeRequestedForCompetitor : TimeRange.create((TimePoint)timeRangeRequestedForCompetitor.from(), (TimePoint)timePointOfLastFix)));
        return result;
    }

    private void ignoreResultsForCompetitorInPendingRequests(CompetitorDTO competitor) {
        for (PositionRequest inFlightRequest : this.inFlightRequests) {
            inFlightRequest.ignoreFixesFor(competitor);
        }
    }

    private Date getTimepointOfLastNonExtrapolated(List<GPSFixDTOWithSpeedWindTackAndLegType> fixesForCompetitor) {
        if (!fixesForCompetitor.isEmpty()) {
            ListIterator<GPSFixDTOWithSpeedWindTackAndLegType> fixIter = fixesForCompetitor.listIterator(fixesForCompetitor.size() - 1);
            while (fixIter.hasPrevious()) {
                GPSFixDTOWithSpeedWindTackAndLegType fix = fixIter.previous();
                if (fix.extrapolated) continue;
                return fix.timepoint;
            }
        }
        return null;
    }

    protected void searchMinMaxDetailValue(CompetitorDTO competitor) {
        boolean minSet = this.minDetailValueFixByCompetitorIdsAsStrings.containsKey(competitor.getIdAsString());
        boolean maxSet = this.maxDetailValueFixByCompetitorIdsAsStrings.containsKey(competitor.getIdAsString());
        if (!minSet || !maxSet) {
            double min = Double.MAX_VALUE;
            int minIndex = -1;
            double max = Double.MIN_VALUE;
            int maxIndex = -1;
            Integer startIndex = this.getFirstShownFix(competitor);
            if (startIndex != null) {
                int endIndex = (Integer)this.lastShownFixByCompetitorIdsAsStrings.get(competitor.getIdAsString());
                List fixesForCompetitor = (List)this.fixesByCompetitorIdsAsStrings.get(competitor.getIdAsString());
                int i = startIndex;
                for (GPSFixDTOWithSpeedWindTackAndLegType fix : fixesForCompetitor.subList(startIndex, endIndex + 1)) {
                    Double value = fix.detailValue;
                    if (value != null) {
                        double doubleValue = value;
                        if (!minSet && doubleValue <= min) {
                            min = doubleValue;
                            minIndex = i;
                        }
                        if (!maxSet && doubleValue >= max) {
                            max = doubleValue;
                            maxIndex = i;
                        }
                    }
                    ++i;
                }
                if (!minSet && minIndex > -1) {
                    this.minDetailValueFixByCompetitorIdsAsStrings.put(competitor.getIdAsString(), minIndex);
                }
                if (!maxSet && maxIndex > -1) {
                    this.maxDetailValueFixByCompetitorIdsAsStrings.put(competitor.getIdAsString(), maxIndex);
                }
            }
        }
    }

    protected void resetDetailValueSearch() {
        this.minDetailValueFixByCompetitorIdsAsStrings.clear();
        this.maxDetailValueFixByCompetitorIdsAsStrings.clear();
    }

    protected void updateDetailValueBoundaries(Iterable<CompetitorDTO> competitors) {
        double min = Double.MAX_VALUE;
        boolean minSet = false;
        double max = Double.MIN_VALUE;
        boolean maxSet = false;
        for (CompetitorDTO competitor : competitors) {
            Integer maxIndex;
            this.searchMinMaxDetailValue(competitor);
            Integer minIndex = (Integer)this.minDetailValueFixByCompetitorIdsAsStrings.get(competitor.getIdAsString());
            List competitorFixes = (List)this.fixesByCompetitorIdsAsStrings.get(competitor.getIdAsString());
            if (minIndex != null) {
                if (competitorFixes == null || minIndex >= competitorFixes.size()) {
                    this.minDetailValueFixByCompetitorIdsAsStrings.remove(competitor.getIdAsString());
                } else {
                    GPSFixDTOWithSpeedWindTackAndLegType competitorFix = (GPSFixDTOWithSpeedWindTackAndLegType)competitorFixes.get(minIndex);
                    if (!minSet || competitorFix.detailValue != null && competitorFix.detailValue < min) {
                        min = competitorFix.detailValue;
                        minSet = true;
                    }
                }
            }
            if ((maxIndex = (Integer)this.maxDetailValueFixByCompetitorIdsAsStrings.get(competitor.getIdAsString())) == null) continue;
            if (competitorFixes == null || maxIndex >= competitorFixes.size()) {
                this.maxDetailValueFixByCompetitorIdsAsStrings.remove(competitor.getIdAsString());
                continue;
            }
            GPSFixDTOWithSpeedWindTackAndLegType competitorFix = (GPSFixDTOWithSpeedWindTackAndLegType)competitorFixes.get(maxIndex);
            if (maxSet && (competitorFix.detailValue == null || !(competitorFix.detailValue > max))) continue;
            max = competitorFix.detailValue;
            maxSet = true;
        }
        if (minSet && maxSet) {
            this.detailValueBoundaries.setMinMax(min, max);
        }
    }

    protected ValueRangeFlexibleBoundaries getDetailValueBoundaries() {
        return this.detailValueBoundaries;
    }

    protected void setDetailValueBoundaries(ValueRangeFlexibleBoundaries boundaries) {
        this.detailValueBoundaries = boundaries;
    }

    protected Double getDetailValueAt(CompetitorDTO competitorDTO, int fixIndexIntoTail) {
        Integer firstShownFixForCompetitor = (Integer)this.firstShownFixByCompetitorIdsAsStrings.get(competitorDTO.getIdAsString());
        int indexOfFirstShownFix = firstShownFixForCompetitor == null ? -1 : firstShownFixForCompetitor;
        try {
            return ((GPSFixDTOWithSpeedWindTackAndLegType)this.getFixes((CompetitorDTO)competitorDTO).get((int)(indexOfFirstShownFix + fixIndexIntoTail))).detailValue;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected void clearTails() {
        for (Colorline tail : this.tailsByCompetitorIdsAsStrings.values()) {
            tail.clear();
        }
        this.tailsByCompetitorIdsAsStrings.clear();
        this.firstShownFixByCompetitorIdsAsStrings.clear();
        this.lastShownFixByCompetitorIdsAsStrings.clear();
        this.resetDetailValueSearch();
    }

    public boolean hasTail(CompetitorDTO competitor) {
        return this.tailsByCompetitorIdsAsStrings.containsKey(competitor.getIdAsString());
    }

    static /* synthetic */ Set access$0(FixesAndTails fixesAndTails) {
        return fixesAndTails.inFlightRequests;
    }

    static /* synthetic */ void access$1(FixesAndTails fixesAndTails, CompetitorDTO competitorDTO, GPSFixDTOWithSpeedWindTackAndLegTypeIterable gPSFixDTOWithSpeedWindTackAndLegTypeIterable, boolean bl, long l, DetailType detailType) {
        fixesAndTails.updateFixes(competitorDTO, gPSFixDTOWithSpeedWindTackAndLegTypeIterable, bl, l, detailType);
    }

    static /* synthetic */ Map access$2(FixesAndTails fixesAndTails) {
        return fixesAndTails.detailTypesRequestedByCompetitorIdsAsStrings;
    }

    static /* synthetic */ Map access$3(FixesAndTails fixesAndTails) {
        return fixesAndTails.firstShownFixByCompetitorIdsAsStrings;
    }

    static /* synthetic */ Map access$4(FixesAndTails fixesAndTails) {
        return fixesAndTails.lastShownFixByCompetitorIdsAsStrings;
    }

    static /* synthetic */ void access$5(FixesAndTails fixesAndTails, CompetitorDTO competitorDTO, Date date, Date date2, boolean bl) {
        fixesAndTails.fillEmptyTail(competitorDTO, date, date2, bl);
    }

    static /* synthetic */ void access$6(FixesAndTails fixesAndTails, CompetitorDTO competitorDTO) {
        fixesAndTails.clearTail(competitorDTO);
    }

    static /* synthetic */ void access$7(FixesAndTails fixesAndTails, CompetitorDTO competitorDTO, int n) {
        fixesAndTails.adjustMinMaxForRemoved(competitorDTO, n);
    }

    static /* synthetic */ void access$8(FixesAndTails fixesAndTails, CompetitorDTO competitorDTO, int n, List list) {
        fixesAndTails.adjustMinMaxForInserted(competitorDTO, n, list);
    }

    static /* synthetic */ CoordinateSystem access$9(FixesAndTails fixesAndTails) {
        return fixesAndTails.coordinateSystem;
    }
}

