/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.charts;

import com.google.gwt.user.client.Window;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettingsDialogComponent;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.AbstractCompetitorLeaderboardChart;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;

public class MultiCompetitorLeaderboardChart
extends AbstractCompetitorLeaderboardChart<MultiCompetitorLeaderboardChartSettings> {
    private MultiCompetitorLeaderboardChartSettings settings;
    private final boolean isOverall;

    public MultiCompetitorLeaderboardChart(Component<?> parent, ComponentContext<?> context, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, String leaderboardName, DetailType detailType, CompetitorSelectionProvider competitorSelectionProvider, Timer timer, StringMessages stringMessages, boolean isOverall, ErrorReporter errorReporter) {
        super(parent, context, sailingService, asyncActionsExecutor, leaderboardName, detailType, competitorSelectionProvider, timer, stringMessages, errorReporter);
        this.isOverall = isOverall;
        this.settings = MultiCompetitorLeaderboardChartSettings.createWithDefaultDetailType((boolean)isOverall, (DetailType)detailType);
    }

    public boolean hasSettings() {
        return true;
    }

    public MultiCompetitorLeaderboardChartSettings getSettings() {
        return MultiCompetitorLeaderboardChartSettings.createWithDefaultDetailType((boolean)this.isOverall, (DetailType)this.settings.getDetailType());
    }

    public SettingsDialogComponent<MultiCompetitorLeaderboardChartSettings> getSettingsDialogComponent(MultiCompetitorLeaderboardChartSettings settings) {
        return new MultiCompetitorLeaderboardChartSettingsDialogComponent(settings, this.isOverall);
    }

    public void updateSettings(MultiCompetitorLeaderboardChartSettings newSettings) {
        boolean redraw = false;
        if (this.settings.getDetailType() != newSettings.getDetailType()) {
            this.settings = new MultiCompetitorLeaderboardChartSettings(newSettings.getDetailType());
            this.setSelectedDetailType(newSettings.getDetailType());
            redraw = true;
        }
        if (redraw) {
            this.clearChart();
            this.timeChanged(this.timer.getTime(), null);
        }
    }

    public String getLocalizedShortName() {
        return this.stringMessages.showCharts();
    }

    public void forceMaximumChartSize() {
        this.chart.setWidth100();
        this.chart.setHeight100();
        this.chart.redraw();
    }

    public void forceChartToClientHeight() {
        this.chart.setSize(this.chart.getOffsetWidth(), Window.getClientHeight());
        this.chart.redraw();
    }

    public String getId() {
        return "lbc";
    }
}

