/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client;

import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.gwt.ui.client.CompetitorColorProvider;
import com.sap.sailing.gwt.ui.client.CompetitorColorProviderImpl;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.common.filter.FilterSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class CompetitorSelectionModel
implements CompetitorSelectionProvider {
    protected final Set<CompetitorDTO> allCompetitors;
    private final LinkedHashMap<String, CompetitorDTO> selectedCompetitors;
    private final Set<CompetitorSelectionChangeListener> listeners;
    private final boolean hasMultiSelection;
    private FilterSet<CompetitorDTO, Filter<CompetitorDTO>> competitorsFilterSet;
    protected final CompetitorColorProvider competitorColorProvider;

    public CompetitorSelectionModel(boolean hasMultiSelection) {
        this(hasMultiSelection, (CompetitorColorProvider)new CompetitorColorProviderImpl(), null);
    }

    public CompetitorSelectionModel(boolean hasMultiSelection, CompetitorColorProvider competitorColorProvider) {
        this(hasMultiSelection, competitorColorProvider, null);
    }

    private CompetitorSelectionModel(boolean hasMultiSelection, CompetitorColorProvider competitorColorProvider, FilterSet<CompetitorDTO, Filter<CompetitorDTO>> competitorsFilterSet) {
        this.hasMultiSelection = hasMultiSelection;
        this.competitorColorProvider = competitorColorProvider;
        this.competitorsFilterSet = competitorsFilterSet;
        this.allCompetitors = new LinkedHashSet();
        this.selectedCompetitors = new LinkedHashMap();
        this.listeners = new HashSet();
    }

    public void add(CompetitorWithBoatDTO competitor) {
        this.add((CompetitorDTO)competitor, true);
    }

    private void add(CompetitorDTO competitor, boolean notifyListeners) {
        if (competitor.getColor() != null) {
            this.competitorColorProvider.addBlockedColor(competitor.getColor());
        }
        boolean changed = this.allCompetitors.add(competitor);
        if (notifyListeners && changed) {
            this.fireListChanged(this.getAllCompetitors(), new CompetitorSelectionChangeListener[0]);
        }
    }

    public boolean hasMultiSelection() {
        return this.hasMultiSelection;
    }

    public void clear() {
        Iterator selIter = this.getSelectedCompetitors().iterator();
        while (selIter.hasNext()) {
            CompetitorDTO selected = (CompetitorDTO)selIter.next();
            this.setSelected(selected, false, new CompetitorSelectionChangeListener[0]);
            selIter = this.getSelectedCompetitors().iterator();
        }
        assert (this.selectedCompetitors.isEmpty());
        this.allCompetitors.clear();
        this.fireListChanged(this.getAllCompetitors(), new CompetitorSelectionChangeListener[0]);
    }

    public void addAll(Iterable<CompetitorDTO> competitors) {
        boolean changed = false;
        for (CompetitorDTO competitor : competitors) {
            this.add(competitor, false);
            changed = true;
        }
        if (changed) {
            this.fireListChanged(this.getAllCompetitors(), new CompetitorSelectionChangeListener[0]);
        }
    }

    public void remove(CompetitorDTO competitor) {
        boolean changed;
        if (this.isSelected(competitor)) {
            this.setSelected(competitor, false, new CompetitorSelectionChangeListener[0]);
        }
        if (competitor.getColor() != null) {
            this.competitorColorProvider.removeBlockedColor(competitor.getColor());
        }
        if (changed = this.allCompetitors.remove(competitor)) {
            this.fireListChanged(this.getAllCompetitors(), new CompetitorSelectionChangeListener[0]);
        }
    }

    public Iterable<CompetitorDTO> getSelectedCompetitors() {
        return Collections.unmodifiableCollection(this.selectedCompetitors.values());
    }

    public Iterable<CompetitorDTO> getSelectedFilteredCompetitors() {
        return Util.filter((Iterable)this.getFilteredCompetitors(), c -> this.selectedCompetitors.containsKey(c.getIdAsString()));
    }

    public Iterable<CompetitorDTO> getAllCompetitors() {
        return Collections.unmodifiableCollection(this.allCompetitors);
    }

    public Iterable<CompetitorDTO> getFilteredCompetitors() {
        Iterable result = this.competitorsFilterSet == null || this.competitorsFilterSet.getFilters().isEmpty() ? this.allCompetitors : Util.filter((Iterable)this.allCompetitors, competitorDTO -> this.competitorsFilterSet.getFilters().stream().allMatch(filter -> filter.matches(competitorDTO)));
        return result;
    }

    public void setSelected(CompetitorDTO competitor, boolean selected, CompetitorSelectionChangeListener ... listenersNotToNotify) {
        if (selected) {
            if (this.allCompetitors.contains(competitor) && !this.selectedCompetitors.containsKey(competitor.getIdAsString())) {
                this.selectedCompetitors.put(competitor.getIdAsString(), competitor);
                this.fireAddedToSelection(competitor, listenersNotToNotify);
            }
        } else if (this.selectedCompetitors.containsKey(competitor.getIdAsString())) {
            this.selectedCompetitors.remove(competitor.getIdAsString());
            this.fireRemovedFromSelection(competitor, listenersNotToNotify);
        }
    }

    private void fireAddedToSelection(CompetitorDTO competitor, CompetitorSelectionChangeListener ... listenersNotToNotify) {
        for (CompetitorSelectionChangeListener listener : this.listeners) {
            if (listenersNotToNotify != null && Arrays.asList(listenersNotToNotify).contains(listener)) continue;
            listener.addedToSelection(competitor);
        }
    }

    private void fireRemovedFromSelection(CompetitorDTO competitor, CompetitorSelectionChangeListener ... listenersNotToNotify) {
        for (CompetitorSelectionChangeListener listener : this.listeners) {
            if (listenersNotToNotify != null && Arrays.asList(listenersNotToNotify).contains(listener)) continue;
            listener.removedFromSelection(competitor);
        }
    }

    private void fireListChanged(Iterable<CompetitorDTO> competitors, CompetitorSelectionChangeListener ... listenersNotToNotify) {
        for (CompetitorSelectionChangeListener listener : this.listeners) {
            if (listenersNotToNotify != null && Arrays.asList(listenersNotToNotify).contains(listener)) continue;
            listener.competitorsListChanged(competitors);
        }
    }

    public boolean isSelected(CompetitorDTO competitor) {
        return this.selectedCompetitors.containsKey(competitor.getIdAsString());
    }

    public void addCompetitorSelectionChangeListener(CompetitorSelectionChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeCompetitorSelectionChangeListener(CompetitorSelectionChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(Iterable<CompetitorDTO> newSelection, CompetitorSelectionChangeListener ... listenersNotToNotify) {
        HashSet competitorsToRemoveFromSelection = new HashSet(this.selectedCompetitors.values());
        for (CompetitorDTO newSelectedCompetitor : newSelection) {
            this.setSelected(newSelectedCompetitor, true, listenersNotToNotify);
            competitorsToRemoveFromSelection.remove(newSelectedCompetitor);
        }
        for (CompetitorDTO competitorToRemoveFromSelection : competitorsToRemoveFromSelection) {
            this.setSelected(competitorToRemoveFromSelection, false, listenersNotToNotify);
        }
    }

    public void setCompetitors(Iterable<CompetitorDTO> newCompetitors, CompetitorSelectionChangeListener ... listenersNotToNotify) {
        boolean changed = false;
        HashMap<String, CompetitorDTO> oldCompetitorsToRemove = new HashMap<String, CompetitorDTO>();
        for (CompetitorDTO c : this.allCompetitors) {
            oldCompetitorsToRemove.put(c.getIdAsString(), c);
        }
        for (CompetitorDTO newCompetitor : newCompetitors) {
            if (this.allCompetitors.contains(newCompetitor)) {
                oldCompetitorsToRemove.remove(newCompetitor.getIdAsString());
                continue;
            }
            boolean selected = this.isSelected(newCompetitor);
            if (selected) {
                this.remove((CompetitorDTO)oldCompetitorsToRemove.get(newCompetitor.getIdAsString()));
                oldCompetitorsToRemove.remove(newCompetitor.getIdAsString());
            }
            this.add(newCompetitor, false);
            if (selected) {
                this.setSelected(newCompetitor, selected, listenersNotToNotify);
            }
            changed = true;
        }
        for (CompetitorDTO oldCompetitorToRemove : oldCompetitorsToRemove.values()) {
            this.remove(oldCompetitorToRemove);
            changed = true;
        }
        if (changed) {
            this.fireListChanged(this.getAllCompetitors(), listenersNotToNotify);
        }
    }

    public Color getColor(CompetitorDTO competitor) {
        return this.allCompetitors.contains(competitor) ? this.competitorColorProvider.getColor(competitor) : null;
    }

    public FilterSet<CompetitorDTO, Filter<CompetitorDTO>> getCompetitorsFilterSet() {
        return this.competitorsFilterSet;
    }

    public FilterSet<CompetitorDTO, Filter<CompetitorDTO>> getOrCreateCompetitorsFilterSet(String nameToAssignToNewFilterSet) {
        if (this.competitorsFilterSet == null) {
            this.competitorsFilterSet = new FilterSet(nameToAssignToNewFilterSet);
        }
        return this.getCompetitorsFilterSet();
    }

    public void setCompetitorsFilterSet(FilterSet<CompetitorDTO, Filter<CompetitorDTO>> competitorsFilterSet) {
        FilterSet oldFilterSet = this.competitorsFilterSet;
        this.competitorsFilterSet = competitorsFilterSet;
        if (!Util.equalsWithNull(competitorsFilterSet, (Object)oldFilterSet)) {
            for (CompetitorSelectionChangeListener listener : this.listeners) {
                listener.filterChanged(oldFilterSet, competitorsFilterSet);
            }
        }
        for (CompetitorSelectionChangeListener listener : this.listeners) {
            listener.filteredCompetitorsListChanged(this.getFilteredCompetitors());
        }
    }

    public boolean hasActiveFilters() {
        return this.competitorsFilterSet != null && !this.competitorsFilterSet.getFilters().isEmpty() && Util.size((Iterable)this.getFilteredCompetitors()) != this.allCompetitors.size();
    }

    public void clearAllFilters() {
        if (this.hasActiveFilters()) {
            Iterator selIter = this.getSelectedCompetitors().iterator();
            while (selIter.hasNext()) {
                CompetitorDTO selected = (CompetitorDTO)selIter.next();
                this.setSelected(selected, false, new CompetitorSelectionChangeListener[0]);
                selIter = this.getSelectedCompetitors().iterator();
            }
            this.competitorsFilterSet = null;
            this.fireListChanged(this.getAllCompetitors(), new CompetitorSelectionChangeListener[0]);
        }
    }

    public int getFilteredCompetitorsListSize() {
        return Util.size((Iterable)this.getFilteredCompetitors());
    }
}

