/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventBaseDTO;
import com.sap.sailing.gwt.ui.shared.RemoteSailingServerReferenceDTO;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.shared.dto.NamedDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class RemoteSailingServerEventsSelectionDialog
extends DataEntryDialog<RemoteSailingServerReferenceDTO> {
    protected StringMessages stringMessages;
    private Grid eventsSelectionGrid;
    private List<EventBaseDTO> allEvents;
    private List<UUID> selectedEvents;
    private RemoteSailingServerReferenceDTO referenceDTO;
    private RadioButton includeRadio;
    private RadioButton excludeRadio;

    public RemoteSailingServerEventsSelectionDialog(RemoteSailingServerReferenceDTO completeRemoteServerReference, RemoteSailingServerReferenceDTO referenceDTO, StringMessages stringMessages, DataEntryDialog.DialogCallback<RemoteSailingServerReferenceDTO> callback) {
        super(stringMessages.remoteServerEventsSelection(), null, stringMessages.ok(), stringMessages.cancel(), null, callback);
        this.stringMessages = stringMessages;
        this.referenceDTO = referenceDTO;
        this.allEvents = completeRemoteServerReference.getEvents() == null ? Collections.emptyList() : StreamSupport.stream(completeRemoteServerReference.getEvents().spliterator(), false).sorted(Comparator.comparing(NamedDTO::getName)).collect(Collectors.toList());
        this.selectedEvents = referenceDTO.getSelectedEvents();
    }

    protected RemoteSailingServerReferenceDTO getResult() {
        ArrayList<UUID> selectedEvents = new ArrayList<UUID>();
        int i = 0;
        while (i < this.allEvents.size()) {
            CheckBox selectEventCheckBox = (CheckBox)this.eventsSelectionGrid.getWidget(i, 1);
            if (selectEventCheckBox.getValue().booleanValue()) {
                selectedEvents.add(((EventBaseDTO)this.allEvents.get(i)).getId());
            }
            ++i;
        }
        this.referenceDTO.setInclude(this.includeRadio.getValue().booleanValue());
        this.referenceDTO.updateSelectedEvents(selectedEvents);
        return this.referenceDTO;
    }

    protected Widget getAdditionalWidget() {
        if (this.allEvents.isEmpty()) {
            this.getStatusLabel().setText(this.stringMessages.eventsListIsEmpty());
        }
        this.eventsSelectionGrid = new Grid(this.allEvents.size(), 2);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setSpacing(10);
        this.createEventsInclusionTypePanel(mainPanel);
        this.addMultiSelectionPanel(mainPanel);
        this.setupEventsSelectionForm(mainPanel);
        VerticalPanel result = mainPanel;
        return result;
    }

    private void addMultiSelectionPanel(VerticalPanel mainPanel) {
        HorizontalPanel multiSelectionPanel = new HorizontalPanel();
        multiSelectionPanel.setSpacing(3);
        Button selectAllButton = new Button(this.stringMessages.selectAll());
        selectAllButton.addClickHandler(this.createMultiSelectionHandler(true));
        selectAllButton.addStyleName("btn-secondary");
        Button deselectAllButton = new Button(this.stringMessages.deselectAll());
        deselectAllButton.addClickHandler(this.createMultiSelectionHandler(false));
        deselectAllButton.addStyleName("btn-secondary");
        multiSelectionPanel.add((Widget)selectAllButton);
        multiSelectionPanel.add((Widget)deselectAllButton);
        mainPanel.add((Widget)multiSelectionPanel);
    }

    private ClickHandler createMultiSelectionHandler(boolean checked) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void setupEventsSelectionForm(VerticalPanel mainPanel) {
        this.eventsSelectionGrid.setCellSpacing(5);
        int i = 0;
        while (i < this.allEvents.size()) {
            EventBaseDTO eventBaseDTO = (EventBaseDTO)this.allEvents.get(i);
            this.eventsSelectionGrid.setWidget(i, 0, (Widget)new Label(eventBaseDTO.getName()));
            CheckBox eventCheckBox = new CheckBox();
            this.eventsSelectionGrid.setWidget(i, 1, (Widget)eventCheckBox);
            eventCheckBox.setValue(Boolean.valueOf(this.selectedEvents.contains(((EventBaseDTO)this.allEvents.get(i)).getId())));
            ++i;
        }
        mainPanel.add((Widget)this.eventsSelectionGrid);
    }

    private void createEventsInclusionTypePanel(VerticalPanel mainPanel) {
        HorizontalPanel eventsSelectionPanel = new HorizontalPanel();
        String eventsSelectionRadioGroupName = "eventsInclusionRadioGroup";
        this.includeRadio = new RadioButton(eventsSelectionRadioGroupName, this.stringMessages.include());
        this.excludeRadio = new RadioButton(eventsSelectionRadioGroupName, this.stringMessages.exclude());
        eventsSelectionPanel.add((Widget)this.includeRadio);
        eventsSelectionPanel.add((Widget)this.excludeRadio);
        this.includeRadio.setValue(Boolean.valueOf(this.referenceDTO.isInclude()));
        this.excludeRadio.setValue(Boolean.valueOf(!this.referenceDTO.isInclude()));
        mainPanel.add((Widget)eventsSelectionPanel);
    }

    static /* synthetic */ Grid access$1(RemoteSailingServerEventsSelectionDialog remoteSailingServerEventsSelectionDialog) {
        return remoteSailingServerEventsSelectionDialog.eventsSelectionGrid;
    }
}

