/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.PairingListDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PairingListPreviewDialog
extends DataEntryDialog<Void> {
    private final StringMessages stringMessages;
    private final PairingListDTO pairingListDTO;
    private final List<String> raceDisplayNames;
    private final Button print;
    private final String leaderboardName;

    public PairingListPreviewDialog(PairingListDTO pairingListDTO, List<String> raceDisplayNames, StringMessages stringMessages, String leaderboardName) {
        super(String.valueOf(stringMessages.pairingList()) + " " + stringMessages.printView(), "", stringMessages.ok(), stringMessages.cancel(), null, null);
        this.stringMessages = stringMessages;
        this.pairingListDTO = pairingListDTO;
        this.raceDisplayNames = raceDisplayNames;
        this.leaderboardName = leaderboardName;
        this.print = new Button(stringMessages.print());
        this.print.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.getRightButtonPannel().add((Widget)this.print);
    }

    protected Void getResult() {
        return null;
    }

    protected Widget getAdditionalWidget() {
        ScrollPanel scrollPanel = new ScrollPanel(this.getPairingListGrid());
        scrollPanel.setHeight(String.valueOf((double)Window.getClientHeight() * 0.8) + "px");
        scrollPanel.getElement().getStyle().setPadding(15.0, Style.Unit.PX);
        return scrollPanel;
    }

    public Widget getPairingListGrid() {
        ArrayList boats = new ArrayList(this.pairingListDTO.getBoats());
        Collections.sort(boats, this.getBoatsComparator());
        int flightCount = this.pairingListDTO.getPairingList().size();
        int groupCount = ((List)this.pairingListDTO.getPairingList().get(0)).size();
        int boatCount = boats.size();
        Grid pairingListGrid = new Grid(flightCount * groupCount + 1, boatCount + 2);
        pairingListGrid.getElement().setId("grid");
        pairingListGrid.setCellPadding(15);
        pairingListGrid.getElement().setAttribute("style", "border-collapse: collapse");
        int flightIndexInGrid = 1;
        int groupIndex = 1;
        int boatIndex = 0;
        for (BoatDTO boat : boats) {
            pairingListGrid.setWidget(0, boatIndex + 2, (Widget)new Label(this.getBoatDisplayName(boat)));
            pairingListGrid.getCellFormatter().getElement(0, boatIndex + 2).getStyle().setTextAlign(Style.TextAlign.CENTER);
            pairingListGrid.getCellFormatter().getElement(0, boatIndex + 2).getStyle().setPadding(10.0, Style.Unit.PX);
            if (boat.getColor() != null) {
                pairingListGrid.getCellFormatter().getElement(0, boatIndex + 2).getStyle().setBackgroundColor(boat.getColor().getAsHtml());
                if (this.isDark(boat.getColor())) {
                    pairingListGrid.getCellFormatter().getElement(0, boatIndex + 2).getStyle().setColor(Color.WHITE.getAsHtml());
                }
            } else {
                pairingListGrid.getCellFormatter().getElement(0, boatIndex + 2).getStyle().setBackgroundColor("#cecece");
            }
            ++boatIndex;
        }
        String BACKGROUND_SHADE = "#cecece";
        String color = "#cecece";
        pairingListGrid.getCellFormatter().getElement(0, 0).getStyle().setBackgroundColor("#cecece");
        pairingListGrid.getCellFormatter().getElement(0, 1).getStyle().setBackgroundColor("#cecece");
        for (List flight : this.pairingListDTO.getPairingList()) {
            color = color.equals("none") ? "#cecece" : "none";
            int currentRaceInGridCells = (flightIndexInGrid - 1) * groupCount + 1;
            pairingListGrid.setWidget(currentRaceInGridCells, 0, (Widget)new Label((String)this.pairingListDTO.getRaceColumnNames().get(flightIndexInGrid - 1)));
            pairingListGrid.getCellFormatter().getElement(currentRaceInGridCells, 0).getStyle().setPadding(5.0, Style.Unit.PX);
            pairingListGrid.getCellFormatter().getElement(currentRaceInGridCells, 0).getStyle().setBackgroundColor(color);
            for (List group : flight) {
                pairingListGrid.getCellFormatter().getElement(groupIndex, 0).getStyle().setPadding(3.0, Style.Unit.PX);
                pairingListGrid.getCellFormatter().getElement(groupIndex, 0).getStyle().setBackgroundColor(color);
                pairingListGrid.setWidget(groupIndex, 1, (Widget)new Label((String)this.raceDisplayNames.get(groupIndex - 1)));
                pairingListGrid.getCellFormatter().getElement(groupIndex, 1).getStyle().setPadding(3.0, Style.Unit.PX);
                pairingListGrid.getCellFormatter().getElement(groupIndex, 1).getStyle().setBackgroundColor(color);
                if (group.size() < boatCount) {
                    ArrayList unusedBoats = new ArrayList(boats);
                    for (Util.Pair competitorAndBoatPair : group) {
                        unusedBoats.remove(competitorAndBoatPair.getB());
                    }
                    for (BoatDTO unusedBoat : unusedBoats) {
                        group.add(new Util.Pair(null, (Object)unusedBoat));
                    }
                }
                for (Util.Pair competitorAndBoatPair : group) {
                    int boatIndexInGrid = boats.indexOf(competitorAndBoatPair.getB()) + 2;
                    if (competitorAndBoatPair.getA() == null) {
                        pairingListGrid.setWidget(groupIndex, boatIndexInGrid, (Widget)new Label(this.stringMessages.empty()));
                        pairingListGrid.getCellFormatter().getElement(groupIndex, boatIndexInGrid).getStyle().setColor(Color.RED.toString());
                    } else {
                        String shortName = ((CompetitorDTO)competitorAndBoatPair.getA()).getShortName();
                        pairingListGrid.setWidget(groupIndex, boatIndexInGrid, (Widget)new Label(shortName == null ? ((CompetitorDTO)competitorAndBoatPair.getA()).getName() : shortName));
                    }
                    pairingListGrid.getCellFormatter().getElement(groupIndex, boatIndexInGrid).getStyle().setFontWeight(Style.FontWeight.BOLD);
                    pairingListGrid.getCellFormatter().getElement(groupIndex, boatIndexInGrid).getStyle().setTextAlign(Style.TextAlign.CENTER);
                    pairingListGrid.getCellFormatter().getElement(groupIndex, boatIndexInGrid).getStyle().setPadding(5.0, Style.Unit.PX);
                    pairingListGrid.getCellFormatter().getElement(groupIndex, boatIndexInGrid).getStyle().setBackgroundColor(color);
                }
                ++groupIndex;
            }
            ++flightIndexInGrid;
        }
        VerticalPanel pairingListPanel = new VerticalPanel();
        pairingListPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        pairingListPanel.add((Widget)pairingListGrid);
        pairingListPanel.setWidth("100%");
        pairingListPanel.ensureDebugId("PairingListPanel");
        ScrollPanel result = new ScrollPanel();
        result.add((Widget)pairingListPanel);
        return pairingListPanel;
    }

    private String getBoatDisplayName(BoatDTO boat) {
        return boat.getName() == null ? boat.getSailId() : boat.getName();
    }

    private Comparator<BoatDTO> getBoatsComparator() {
        NaturalComparator naturalComparator = new NaturalComparator();
        return (arg_0, arg_1) -> this.lambda$0((Comparator)naturalComparator, arg_0, arg_1);
    }

    private boolean isDark(Color color) {
        Util.Triple rgb = color.getAsRGB();
        return (Integer)rgb.getA() + (Integer)rgb.getB() + (Integer)rgb.getC() < 100;
    }

    private native void printPairingListGrid(String var1);

    static /* synthetic */ void access$1(PairingListPreviewDialog pairingListPreviewDialog, String string) {
        pairingListPreviewDialog.printPairingListGrid(string);
    }

    private /* synthetic */ int lambda$0(Comparator comparator, BoatDTO b1, BoatDTO b2) {
        return comparator.compare(this.getBoatDisplayName(b1), this.getBoatDisplayName(b2));
    }
}

