/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorImportProviderSelectionDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorImportSelectionDialogResult;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.CompetitorProviderDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.busyindicator.BusyDisplay;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompetitorImportProviderSelectionDialog
extends DataEntryDialog<CompetitorImportSelectionDialogResult> {
    private final ListBox competitorListBox;
    private final ListBox competitorProviderListBox;
    private final BusyIndicator busyIndicator;
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private final LinkedHashMap<String, Util.Pair<String, String>> eventRegattaNamesByCompetitorListItem;

    public CompetitorImportProviderSelectionDialog(MatchImportedCompetitorsDialogFactory matchCompetitorsDialogFactory, BusyDisplay busyDisplay, Iterable<String> competitorProviderNames, SailingServiceAsync sailingService, StringMessages stringMessages, ErrorReporter errorReporter) {
        super(stringMessages.importCompetitors(), null, stringMessages.ok(), stringMessages.cancel(), null, (DataEntryDialog.DialogCallback)new Callback(matchCompetitorsDialogFactory, sailingService, busyDisplay, errorReporter, stringMessages));
        this.sailingService = sailingService;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.competitorProviderListBox = this.createListBox(false);
        this.competitorListBox = this.createListBox(false);
        this.competitorListBox.setVisible(false);
        this.busyIndicator = new SimpleBusyIndicator();
        this.eventRegattaNamesByCompetitorListItem = new LinkedHashMap();
        this.competitorProviderListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addProviderNamesToListBox(competitorProviderNames, stringMessages);
    }

    private void addProviderNamesToListBox(Iterable<String> competitorProviderNames, StringMessages stringMessages) {
        List sortedProviderNames = this.getSortedProviderNames(competitorProviderNames);
        this.competitorProviderListBox.addItem(stringMessages.selectCompetitorImportProvider());
        for (String providerName : sortedProviderNames) {
            this.competitorProviderListBox.addItem(providerName);
        }
    }

    private List<String> getSortedProviderNames(Iterable<String> competitorProviderNames) {
        ArrayList<String> sortedProviderNames = new ArrayList<String>();
        for (String providerName : competitorProviderNames) {
            sortedProviderNames.add(providerName);
        }
        Collections.sort(sortedProviderNames);
        return sortedProviderNames;
    }

    private void competitorImportProviderChanged(String selectedProviderName) {
        if (selectedProviderName != null) {
            this.busyIndicator.setBusy(true);
            this.competitorProviderListBox.setEnabled(false);
            this.sailingService.getCompetitorProviderDTOByName(selectedProviderName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.competitorListBox.setVisible(false);
            this.updateCompetitorListBox(null);
        }
    }

    private void updateCompetitorListBox(CompetitorProviderDTO competitorProvider) {
        this.eventRegattaNamesByCompetitorListItem.clear();
        this.competitorListBox.clear();
        if (competitorProvider != null) {
            this.competitorListBox.addItem(this.stringMessages.pleaseSelectAScoringResult());
            List eventAndRegattaNames = this.getEventAndRegattaNamesWhichHasCompetitors(competitorProvider);
            for (Util.Pair pair : eventAndRegattaNames) {
                String eventName = (String)pair.getA();
                String ragattaName = (String)pair.getB();
                String competitorImportSourceName = String.valueOf(eventName) + ", " + ragattaName;
                this.eventRegattaNamesByCompetitorListItem.put(competitorImportSourceName, pair);
                this.competitorListBox.addItem(competitorImportSourceName);
            }
        }
    }

    private List<Util.Pair<String, String>> getEventAndRegattaNamesWhichHasCompetitors(CompetitorProviderDTO competitorProvider) {
        ArrayList<Util.Pair<String, String>> eventAndRegattaNames = new ArrayList<Util.Pair<String, String>>();
        for (Map.Entry entry : competitorProvider.getHasCompetitorsForRegattasInEvent().entrySet()) {
            if (entry.getValue() == null) {
                eventAndRegattaNames.add((Util.Pair<String, String>)new Util.Pair((Object)((String)entry.getKey()), (Object)""));
                continue;
            }
            for (String ragattaName : (Set)entry.getValue()) {
                eventAndRegattaNames.add((Util.Pair<String, String>)new Util.Pair((Object)((String)entry.getKey()), (Object)ragattaName));
            }
        }
        return eventAndRegattaNames;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.add((Widget)this.busyIndicator);
        vPanel.add((Widget)this.competitorProviderListBox);
        vPanel.add((Widget)this.competitorListBox);
        return vPanel;
    }

    protected Focusable getInitialFocusWidget() {
        return this.competitorProviderListBox;
    }

    protected CompetitorImportSelectionDialogResult getResult() {
        CompetitorImportSelectionDialogResult competitorImportDialogResult = null;
        int selectedProviderIndex = this.competitorProviderListBox.getSelectedIndex();
        if (selectedProviderIndex > 0) {
            String selectedProviderName = this.competitorProviderListBox.getItemText(selectedProviderIndex);
            int selectedDocumentIndex = this.competitorListBox.getSelectedIndex();
            if (selectedDocumentIndex > 0) {
                Util.Pair pair = (Util.Pair)this.eventRegattaNamesByCompetitorListItem.get(this.competitorListBox.getValue(selectedDocumentIndex));
                String eventName = (String)pair.getA();
                String regattaName = (String)pair.getB();
                competitorImportDialogResult = new CompetitorImportSelectionDialogResult(selectedProviderName, eventName, regattaName);
            }
        }
        return competitorImportDialogResult;
    }

    static /* synthetic */ ListBox access$1(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog) {
        return competitorImportProviderSelectionDialog.competitorProviderListBox;
    }

    static /* synthetic */ void access$2(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog, String string) {
        competitorImportProviderSelectionDialog.competitorImportProviderChanged(string);
    }

    static /* synthetic */ void access$3(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog, CompetitorProviderDTO competitorProviderDTO) {
        competitorImportProviderSelectionDialog.updateCompetitorListBox(competitorProviderDTO);
    }

    static /* synthetic */ ListBox access$4(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog) {
        return competitorImportProviderSelectionDialog.competitorListBox;
    }

    static /* synthetic */ BusyIndicator access$5(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog) {
        return competitorImportProviderSelectionDialog.busyIndicator;
    }

    static /* synthetic */ ErrorReporter access$6(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog) {
        return competitorImportProviderSelectionDialog.errorReporter;
    }

    static /* synthetic */ StringMessages access$7(CompetitorImportProviderSelectionDialog competitorImportProviderSelectionDialog) {
        return competitorImportProviderSelectionDialog.stringMessages;
    }
}

