/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.gwt.ui.adminconsole.ColorColumn;
import com.sap.sailing.gwt.ui.adminconsole.CompactBoatTableWrapper;
import com.sap.sailing.gwt.ui.adminconsole.TableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.filter.Filter;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.panels.CustomizableFilterablePanel;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class CompactBoatTableWrapper<S extends RefreshableSelectionModel<BoatDTO>>
extends TableWrapper<BoatDTO, S> {
    private final CustomizableFilterablePanel<BoatDTO> filterField;
    private final Set<BoatDTO> boatsRegisteredWithRegatta = new HashSet();

    public CompactBoatTableWrapper(SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager) {
        super(sailingServiceWrite, stringMessages, errorReporter, multiSelection, enablePager, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */);
        ColumnSortEvent.ListHandler boatColumnListHandler = this.getColumnSortHandler();
        2 boatNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatNameColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        4 boatClassColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatClassColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        6 sailIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        sailIdColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)sailIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        ColorColumn boatColorColumn = new ColorColumn((ColorColumn.ColorRetriever)new /* Unavailable Anonymous Inner Class!! */);
        boatColorColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatColorColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        10 boatIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        boatIdColumn.setSortable(true);
        boatColumnListHandler.setComparator((Column)boatIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        CheckBox filterToBoatsRegisteredOnRegatta = new CheckBox(stringMessages.filterToBoatsRegisteredOnRegatta());
        filterToBoatsRegisteredOnRegatta.addValueChangeHandler(checked -> this.filterField.filter());
        this.filterField.add(new Label(""), (Widget)filterToBoatsRegisteredOnRegatta, (Filter)new /* Unavailable Anonymous Inner Class!! */);
        this.filterField.addDefaultTextBox();
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)boatColumnListHandler);
        this.table.addColumn((Column)boatNameColumn, stringMessages.name());
        this.table.addColumn((Column)sailIdColumn, stringMessages.sailNumber());
        this.table.addColumn((Column)boatClassColumn, stringMessages.boatClass());
        this.table.addColumn((Column)boatColorColumn, stringMessages.color());
        this.table.addColumn((Column)boatIdColumn, stringMessages.id());
        this.table.ensureDebugId("BoatsTable");
    }

    public Iterable<BoatDTO> getAllBoats() {
        return this.filterField.getAll();
    }

    public void filterBoats(Iterable<BoatDTO> boats) {
        this.getFilteredBoats(boats);
    }

    public void selectBoat(BoatDTO boatToSelect) {
        for (BoatDTO boat : this.getAllBoats()) {
            if (!boat.getIdAsString().equals(boatToSelect.getIdAsString())) continue;
            this.getSelectionModel().setSelected((Object)boat, true);
            break;
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clear();
    }

    public void refreshBoatListFromRace(String leaderboardName, String raceColumnName, String fleetName) {
        14 myCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.sailingServiceWrite.getCompetitorsAndBoatsOfRace(leaderboardName, raceColumnName, fleetName, (AsyncCallback)myCallback);
        this.updateBoatRegistrationsForLeaderboard(leaderboardName);
    }

    private void updateBoatRegistrationsForLeaderboard(String leaderboardName) {
        this.sailingServiceWrite.getBoatRegistrationsForLeaderboard(leaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshBoatList(String leaderboardName) {
        this.sailingServiceWrite.getAllBoats((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.updateBoatRegistrationsForLeaderboard(leaderboardName);
    }

    private void getFilteredBoats(Iterable<BoatDTO> result) {
        this.filterField.updateAll(result);
    }

    static /* synthetic */ FlushableCellTable access$0(CompactBoatTableWrapper compactBoatTableWrapper) {
        return compactBoatTableWrapper.table;
    }

    static /* synthetic */ Set access$1(CompactBoatTableWrapper compactBoatTableWrapper) {
        return compactBoatTableWrapper.boatsRegisteredWithRegatta;
    }

    static /* synthetic */ ErrorReporter access$2(CompactBoatTableWrapper compactBoatTableWrapper) {
        return compactBoatTableWrapper.errorReporter;
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$3(CompactBoatTableWrapper compactBoatTableWrapper) {
        return compactBoatTableWrapper.getStringMessages();
    }
}

