/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AIAgentConfigurationPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.TableWrapperWithMultiSelectionAndFilterForSecuredDTO;
import java.util.HashSet;
import java.util.Set;

public class AIAgentConfigurationPanel
extends SimplePanel {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final StringMessages stringMessages;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final TableWrapperWithMultiSelectionAndFilterForSecuredDTO<EventDTO, StringMessages, AdminConsoleTableResources> eventsTableWrapper;
    private final Set<EventDTO> selectedEvents;
    private boolean selectionUpdatedAfterEventsHaveLoaded;
    private boolean handleSelectionChangeEvents;
    private String languageModelName;

    public AIAgentConfigurationPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.stringMessages = stringMessages;
        this.userService = presenter.getUserService();
        this.errorReporter = presenter.getErrorReporter();
        this.eventsTableWrapper = this.getEventsTableWrapper();
        this.selectedEvents = new HashSet();
        this.setWidget(this.getMainPanel(presenter));
    }

    private TableWrapperWithMultiSelectionAndFilterForSecuredDTO<EventDTO, StringMessages, AdminConsoleTableResources> getEventsTableWrapper() {
        AdminConsoleTableResources adminConsoleTableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        2 eventsTableWrapper = new /* Unavailable Anonymous Inner Class!! */;
        eventsTableWrapper.addColumn(NamedDTO::getName, this.stringMessages.name());
        SafeHtmlCell descriptionCell = new SafeHtmlCell();
        3 descriptionColumn = new /* Unavailable Anonymous Inner Class!! */;
        descriptionColumn.setCellStyleNames(adminConsoleTableResources.cellTableStyle().cellTableWrapText());
        eventsTableWrapper.addColumn((Column)descriptionColumn, this.stringMessages.description());
        eventsTableWrapper.addColumn(e -> e.getVenue().getName(), this.stringMessages.venue());
        eventsTableWrapper.addColumn(e -> e.getId().toString(), this.stringMessages.id());
        ((RefreshableMultiSelectionModel)eventsTableWrapper.getSelectionModel()).addSelectionChangeHandler(arg_0 -> this.lambda$3((TableWrapperWithMultiSelectionAndFilterForSecuredDTO)eventsTableWrapper, arg_0));
        return eventsTableWrapper;
    }

    private Widget getMainPanel(AdminConsoleView.Presenter presenter) {
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.EVENT);
        Button refresh = buttonPanel.addUnsecuredAction(this.stringMessages.refresh(), () -> presenter.getEventsRefresher().reloadAndCallFillAll());
        refresh.ensureDebugId("RefreshEventsButton");
        CaptionPanel eventsCaptionPanel = new CaptionPanel(this.stringMessages.selectEventsForWhichToUseAICommenting());
        eventsCaptionPanel.setWidth("100%");
        VerticalPanel contents = new VerticalPanel();
        contents.setWidth("100%");
        contents.add((Widget)buttonPanel);
        TextArea credentialsTextArea = new TextArea();
        credentialsTextArea.getElement().setAttribute("placeholder", this.stringMessages.placeholderAICoreCredentialsAsJSON());
        credentialsTextArea.setSize("60em", "15em");
        CaptionPanel credentialsCaptionPanel = new CaptionPanel(this.stringMessages.credentials());
        VerticalPanel credentialsVP = new VerticalPanel();
        credentialsVP.setSpacing(5);
        HorizontalPanel hasOrResetCredentialsHP = new HorizontalPanel();
        hasOrResetCredentialsHP.setSpacing(5);
        hasOrResetCredentialsHP.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        Label hasCredentialsLabel = new Label();
        hasOrResetCredentialsHP.add((Widget)hasCredentialsLabel);
        Label languageModelNameLabel = new Label();
        Button resetCredentialsButton = new Button(this.stringMessages.resetCredentials());
        6 hasAIAgentCredentialsCallback = new /* Unavailable Anonymous Inner Class!! */;
        resetCredentialsButton.addClickHandler(arg_0 -> this.lambda$7((AsyncCallback)hasAIAgentCredentialsCallback, arg_0));
        hasOrResetCredentialsHP.add((Widget)resetCredentialsButton);
        credentialsVP.add((Widget)hasOrResetCredentialsHP);
        HorizontalPanel updateCredentialsHP = new HorizontalPanel();
        updateCredentialsHP.setSpacing(5);
        credentialsCaptionPanel.setContentWidget((Widget)credentialsVP);
        updateCredentialsHP.add((Widget)credentialsTextArea);
        Button credentialsUpdateButton = new Button(this.stringMessages.updateCredentials());
        this.eventsTableWrapper.getTable().setWidth("100%");
        this.sailingServiceWrite.hasAIAgentCredentials((AsyncCallback)hasAIAgentCredentialsCallback);
        credentialsUpdateButton.addClickHandler(arg_0 -> this.lambda$8(credentialsTextArea, (AsyncCallback)hasAIAgentCredentialsCallback, arg_0));
        updateCredentialsHP.add((Widget)credentialsUpdateButton);
        credentialsVP.add((Widget)updateCredentialsHP);
        mainPanel.add((Widget)credentialsCaptionPanel);
        mainPanel.add((Widget)languageModelNameLabel);
        mainPanel.add((Widget)eventsCaptionPanel);
        return mainPanel;
    }

    public Displayer<EventDTO> getEventsDisplayer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void updateHasCredentialsLabelAndSetEventsCaptionVisibility(boolean hasCredentials, Label hasCredentialsLabel, CaptionPanel eventsCaptionPanel, Button resetCredentialsButton, Label languageModelNameLabel) {
        String label = hasCredentials ? this.stringMessages.hasAIAgentCredentials() : this.stringMessages.hasNoAIAgentCredentials();
        hasCredentialsLabel.setText(label);
        eventsCaptionPanel.setVisible(hasCredentials);
        resetCredentialsButton.setVisible(hasCredentials);
        languageModelNameLabel.setVisible(hasCredentials);
    }

    static /* synthetic */ StringMessages access$0(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.stringMessages;
    }

    static /* synthetic */ void access$1(AIAgentConfigurationPanel aIAgentConfigurationPanel, boolean bl, Label label, CaptionPanel captionPanel, Button button, Label label2) {
        aIAgentConfigurationPanel.updateHasCredentialsLabelAndSetEventsCaptionVisibility(bl, label, captionPanel, button, label2);
    }

    static /* synthetic */ SailingServiceWriteAsync access$2(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.sailingServiceWrite;
    }

    static /* synthetic */ void access$3(AIAgentConfigurationPanel aIAgentConfigurationPanel, String string) {
        aIAgentConfigurationPanel.languageModelName = string;
    }

    static /* synthetic */ TableWrapperWithMultiSelectionAndFilterForSecuredDTO access$4(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.eventsTableWrapper;
    }

    static /* synthetic */ boolean access$5(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.selectionUpdatedAfterEventsHaveLoaded;
    }

    static /* synthetic */ void access$6(AIAgentConfigurationPanel aIAgentConfigurationPanel, boolean bl) {
        aIAgentConfigurationPanel.handleSelectionChangeEvents = bl;
    }

    static /* synthetic */ String access$7(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.languageModelName;
    }

    static /* synthetic */ void access$8(AIAgentConfigurationPanel aIAgentConfigurationPanel, boolean bl) {
        aIAgentConfigurationPanel.selectionUpdatedAfterEventsHaveLoaded = bl;
    }

    static /* synthetic */ Set access$9(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.selectedEvents;
    }

    private /* synthetic */ void lambda$3(TableWrapperWithMultiSelectionAndFilterForSecuredDTO tableWrapperWithMultiSelectionAndFilterForSecuredDTO, SelectionChangeEvent selectionChangeEvent) {
        if (this.handleSelectionChangeEvents) {
            Set newSelection = ((RefreshableMultiSelectionModel)tableWrapperWithMultiSelectionAndFilterForSecuredDTO.getSelectionModel()).getSelectedSet();
            HashSet addedToSelection = new HashSet(newSelection);
            addedToSelection.removeAll(this.selectedEvents);
            HashSet removedFromSelection = new HashSet(this.selectedEvents);
            removedFromSelection.removeAll(newSelection);
            this.selectedEvents.clear();
            this.selectedEvents.addAll(((RefreshableMultiSelectionModel)tableWrapperWithMultiSelectionAndFilterForSecuredDTO.getSelectionModel()).getSelectedSet());
            addedToSelection.forEach(e -> this.sailingServiceWrite.startAICommentingOnEvent(e.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
            removedFromSelection.forEach(e -> this.sailingServiceWrite.stopAICommentingOnEvent(e.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        }
    }

    private /* synthetic */ void lambda$7(AsyncCallback asyncCallback, ClickEvent e) {
        this.sailingServiceWrite.resetAIAgentCredentials((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private /* synthetic */ void lambda$8(TextArea textArea, AsyncCallback asyncCallback, ClickEvent e) {
        this.sailingServiceWrite.setAIAgentCredentials(textArea.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

