/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.server;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.gwt.home.communication.start.StageEventType;
import com.sap.sailing.gwt.server.EventHolder;
import com.sap.sailing.gwt.server.FeaturedEventsComparator;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.net.URL;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;

public class EventStageCandidateCalculator
implements HomeServiceUtil.EventVisitor {
    public static final int MAX_STAGE_EVENTS = 5;
    private final TimePoint now = MillisecondsTimePoint.now();
    private final SortedSet<Util.Pair<StageEventType, EventHolder>> featuredEvents = new TreeSet(new FeaturedEventsComparator());

    public void visit(EventBase event, boolean onRemoteServer, URL baseURL) {
        TimePoint startDate = event.getStartDate();
        TimePoint endDate = event.getEndDate();
        if (startDate != null) {
            EventHolder holder = new EventHolder(event, onRemoteServer, baseURL);
            if (this.now.after(startDate) && (endDate == null || this.now.before(endDate))) {
                this.featuredEvents.add(new Util.Pair((Object)StageEventType.RUNNING, (Object)holder));
            } else if (startDate.after(this.now) && startDate.before(this.now.plus(Duration.ONE_WEEK.times(4L)))) {
                if (HomeServiceUtil.hasRegattaData((EventBase)event)) {
                    this.featuredEvents.add(new Util.Pair((Object)StageEventType.UPCOMING_SOON, (Object)holder));
                }
            } else if (endDate != null && endDate.before(this.now) && endDate.after(this.now.minus(Duration.ONE_YEAR))) {
                this.featuredEvents.add(new Util.Pair((Object)StageEventType.POPULAR, (Object)holder));
            }
        }
    }

    public Collection<Util.Pair<StageEventType, EventHolder>> getFeaturedEvents() {
        return this.featuredEvents;
    }
}

