/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.regattacompetition;

import com.google.gwt.dom.client.Element;
import com.google.gwt.text.client.DateTimeFormatRenderer;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.DateUtil;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.desktop.partials.raceviewerlaunchpad.RaceviewerLaunchPadController;
import com.sap.sailing.gwt.home.shared.partials.regattacompetition.RegattaCompetitionPresenter;
import com.sap.sailing.gwt.home.shared.partials.regattacompetition.RegattaCompetitionView;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractRegattaCompetitionFleetRace
extends Widget
implements RegattaCompetitionView.RegattaCompetitionRaceView {
    private static final StringMessages I18N = StringMessages.INSTANCE;
    private final RaceviewerLaunchPadController<SimpleRaceMetadataDTO> launchPadController;
    protected final Element mainElement;
    private final SimpleRaceMetadataDTO race;

    protected AbstractRegattaCompetitionFleetRace(SimpleRaceMetadataDTO race, String fleetName, RegattaCompetitionPresenter presenter) {
        this.race = race;
        this.launchPadController = new RaceviewerLaunchPadController((arg_0, arg_1) -> ((RegattaCompetitionPresenter)presenter).getRaceViewerURL(arg_0, arg_1), r -> presenter.getMapAndWindChartUrl(r.getLeaderboardName(), r.getRaceName(), fleetName), presenter.getPaywallResolver());
        this.mainElement = this.getMainUiElement();
        this.setupRaceState(race);
        this.getRaceNameUiElement().setInnerText(race.getRaceName());
        this.setupRaceStart(race.getStart());
        this.setElement(this.mainElement);
        if (race.hasValidTrackingData()) {
            this.sinkEvents(1);
        }
    }

    public void onBrowserEvent(Event event) {
        if (!this.race.hasValidTrackingData() || event.getTypeInt() != 1) {
            return;
        }
        if (this.launchPadController.renderAsDirectLink(this.race)) {
            Window.open((String)this.launchPadController.getDirectLinkUrl(this.race), (String)"_blank", (String)"");
            return;
        }
        this.launchPadController.showLaunchPad((Object)this.race, (Element)this.getElement());
    }

    private void setupRaceState(SimpleRaceMetadataDTO race) {
        boolean isUntrackedRace;
        boolean bl = isUntrackedRace = !race.hasValidTrackingData();
        if (race.isRunning()) {
            this.mainElement.addClassName(this.getRaceLiveStyleName());
            this.getRaceStateUiElement().setInnerText(isUntrackedRace ? I18N.live() : I18N.actionWatch());
        } else if (race.isFinished()) {
            this.getRaceStateUiElement().setInnerText(isUntrackedRace ? I18N.raceIsFinished() : I18N.tracking());
        } else {
            this.mainElement.addClassName(this.getRacePlannedStyleName());
            if (race.isScheduled()) {
                this.getRaceStateUiElement().setInnerText(I18N.raceIsPlanned());
            } else {
                this.getRaceStateUiElement().setInnerText(race.getViewState().getLabel());
            }
        }
        AbstractRegattaCompetitionFleetRace.setStyleName((Element)this.mainElement, (String)this.getRaceUntrackedStyleName(), (boolean)isUntrackedRace);
    }

    private void setupRaceStart(Date startDate) {
        if (startDate != null) {
            boolean showTime = DateUtil.isSameDayOfMonth((Date)MillisecondsTimePoint.now().asDate(), (Date)startDate);
            DateTimeFormatRenderer renderer = showTime ? DateAndTimeFormatterUtil.shortTimeFormatter : DateAndTimeFormatterUtil.weekdayMonthAbbrDayDateFormatter;
            this.getRaceDateUiElement().setInnerText(renderer.render(startDate));
        }
    }

    protected abstract Element getMainUiElement();

    protected abstract Element getRaceNameUiElement();

    protected abstract Element getRaceStateUiElement();

    protected abstract Element getRaceDateUiElement();

    protected abstract String getRaceLiveStyleName();

    protected abstract String getRacePlannedStyleName();

    protected abstract String getRaceUntrackedStyleName();
}

