/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.partials.filter;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.shared.partials.filter.AbstractFilterWidget;
import com.sap.sailing.gwt.home.shared.partials.filter.AbstractTextInputFilter;
import com.sap.sailing.gwt.home.shared.partials.filter.FilterWidgetResources;
import com.sap.sse.common.filter.Filter;

public abstract class AbstractTextInputFilter<T, C>
extends AbstractFilterWidget<T, C> {
    private final FlowPanel containerUi = new FlowPanel();
    private final Button clearButtonUi = new Button("X");
    private HasValue<String> textInputUi;

    protected <W extends IsWidget & HasValue<String>> AbstractTextInputFilter() {
        FilterWidgetResources.INSTANCE.css().ensureInjected();
        this.containerUi.addStyleName(FilterWidgetResources.INSTANCE.css().input_filter_container());
        this.initWidget((Widget)this.containerUi);
    }

    private void initTextInputWidget(Widget textInputWidget, String placeholderText, KeyUpHandler handler) {
        textInputWidget.getElement().setAttribute("placeholder", placeholderText);
        textInputWidget.addStyleName(FilterWidgetResources.INSTANCE.css().input_filter_text_input());
        textInputWidget.addDomHandler((EventHandler)handler, KeyUpEvent.getType());
        this.containerUi.add(textInputWidget);
    }

    private void initClearButtonWidget(ClickHandler handler) {
        this.clearButtonUi.addStyleName(FilterWidgetResources.INSTANCE.css().input_filter_clear_button());
        this.clearButtonUi.addClickHandler(handler);
        this.containerUi.add((Widget)this.clearButtonUi);
        this.clearButtonUi.setEnabled(false);
    }

    private String getTextInputValue() {
        return this.textInputUi == null ? "" : (String)this.textInputUi.getValue();
    }

    protected <W extends IsWidget & HasValue<String>> void initWidgets(W textInputWidget, String placeholderText) {
        this.textInputUi = textInputWidget;
        TextInputFilterHandler handler = new TextInputFilterHandler(this, null);
        this.initTextInputWidget(textInputWidget.asWidget(), placeholderText, (KeyUpHandler)handler);
        this.initClearButtonWidget((ClickHandler)handler);
    }

    public final Filter<T> getFilter() {
        return this.getFilter(this.getTextInputValue().trim());
    }

    protected void update() {
        this.clearButtonUi.setEnabled(!this.getTextInputValue().isEmpty());
        this.notifyValueChangeHandlers();
    }

    protected void clear() {
        this.textInputUi.setValue(null);
        this.update();
    }

    protected abstract Filter<T> getFilter(String var1);
}

