/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.minileaderboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.MiniLeaderboardItemDTO;
import com.sap.sailing.gwt.home.mobile.partials.minileaderboard.MinileaderboardBoxItem;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;

public class MinileaderboardBoxItem
extends Widget {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    Element competitorNameUi;
    @UiField
    Element competitorRankUi;
    @UiField
    Element competitorPointsUi;
    @UiField
    Element competitorRacesUi;
    @UiField
    Element competitorCountryNameUi;
    @UiField
    ImageElement competitorFlagUi;

    public MinileaderboardBoxItem(MiniLeaderboardItemDTO entry, boolean showRaceCount, FlagImageResolver flagImageResolver) {
        this.setElement((Element)uiBinder.createAndBindUi((Object)this));
        this.competitorNameUi.setInnerText(entry.getCompetitor().getName());
        this.competitorCountryNameUi.setInnerText(String.valueOf(entry.getCompetitor().getShortInfo()));
        this.competitorRankUi.setInnerText(String.valueOf(String.valueOf(entry.getRank())) + ".");
        this.competitorPointsUi.setInnerText(StringMessages.INSTANCE.pointsValue(entry.getNetPoints().doubleValue()));
        if (showRaceCount) {
            this.competitorRacesUi.setInnerText("(" + entry.getRaceCount() + ")");
        }
        SimpleCompetitorDTO competitor = entry.getCompetitor();
        String flagImageURL = competitor.getFlagImageURL();
        String twoLetterIsoCountryCode = competitor.getTwoLetterIsoCountryCode();
        SafeUri imageUri = flagImageResolver.getFlagImageUri(flagImageURL, twoLetterIsoCountryCode);
        this.competitorFlagUi.setSrc(imageUri.asString());
    }
}

