/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.eventsupcoming;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sailing.gwt.home.desktop.app.DesktopPlacesNavigator;
import com.sap.sailing.gwt.home.desktop.partials.eventsupcoming.EventsOverviewUpcoming;
import com.sap.sailing.gwt.home.desktop.partials.eventsupcoming.EventsOverviewUpcomingEvent;
import com.sap.sailing.gwt.home.desktop.partials.eventsupcoming.EventsOverviewUpcomingResources;
import com.sap.sailing.gwt.home.shared.utils.CollapseAnimation;
import com.sap.sailing.gwt.home.shared.utils.EventDatesFormatterUtil;
import com.sap.sailing.gwt.ui.client.StringMessages;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventsOverviewUpcoming
extends Composite {
    private static EventsOverviewUiBinder uiBinder = (EventsOverviewUiBinder)GWT.create(EventsOverviewUiBinder.class);
    private final DesktopPlacesNavigator navigator;
    private final List<String> tickerStrings;
    @UiField
    HTMLPanel header;
    @UiField
    FlowPanel eventsPlaceholder;
    @UiField
    SpanElement eventsCount;
    @UiField
    SpanElement ticker;
    @UiField
    SpanElement colon;
    @UiField
    StringMessages i18n;
    private boolean isContentVisible = true;
    private int currentTickerOffset;
    private final CollapseAnimation eventsAnimation;
    private Timer tickerTimer = new /* Unavailable Anonymous Inner Class!! */;
    private final CollapseAnimation tickerAnimation;

    public EventsOverviewUpcoming(DesktopPlacesNavigator navigator) {
        this.navigator = navigator;
        this.tickerStrings = new ArrayList();
        EventsOverviewUpcomingResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.eventsAnimation = new CollapseAnimation((Element)this.eventsPlaceholder.getElement());
        this.tickerAnimation = new CollapseAnimation((Element)this.ticker);
        this.header.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
    }

    public void updateEvents(ArrayList<EventListEventDTO> arrayList) {
        this.setVisible(arrayList.size() > 0);
        this.eventsPlaceholder.clear();
        this.tickerStrings.clear();
        for (EventListEventDTO event : arrayList) {
            EventsOverviewUpcomingEvent upcomingEvent = new EventsOverviewUpcomingEvent(event, this.navigator);
            this.tickerStrings.add(String.valueOf(event.getDisplayName()) + ", " + event.getVenue() + ", " + EventDatesFormatterUtil.formatDateRangeWithoutYear((Date)event.getStartDate(), (Date)event.getEndDate()));
            this.eventsPlaceholder.getElement().appendChild((Node)upcomingEvent.getElement());
        }
        this.eventsCount.setInnerText(this.i18n.eventsCount(arrayList.size()));
    }

    private void onHeaderCicked() {
        this.isContentVisible = !this.isContentVisible;
        this.updateContentVisibility();
    }

    private void updateContentVisibility() {
        this.eventsAnimation.animate(this.isContentVisible);
        if (this.isContentVisible) {
            this.colon.getStyle().setDisplay(Style.Display.NONE);
            this.getElement().removeClassName(EventsOverviewUpcomingResources.INSTANCE.css().accordioncollapsed());
            this.ticker.setInnerText("");
            this.ticker.getStyle().setDisplay(Style.Display.NONE);
            this.tickerTimer.cancel();
            this.tickerAnimation.cancel();
        } else {
            this.colon.getStyle().clearDisplay();
            this.getElement().addClassName(EventsOverviewUpcomingResources.INSTANCE.css().accordioncollapsed());
            if (this.tickerStrings.isEmpty()) {
                this.ticker.setInnerText("");
                this.ticker.getStyle().setDisplay(Style.Display.NONE);
            } else {
                this.nextTicker(true);
            }
        }
    }

    protected void nextTicker(boolean restart) {
        this.currentTickerOffset = restart ? 0 : (this.currentTickerOffset + 1) % this.tickerStrings.size();
        this.ticker.setInnerText((String)this.tickerStrings.get(this.currentTickerOffset));
        this.ticker.getStyle().clearDisplay();
        this.tickerAnimation.animate(true);
        if (this.tickerStrings.size() > 1) {
            this.tickerTimer.schedule(3000);
        }
    }

    static /* synthetic */ void access$0(EventsOverviewUpcoming eventsOverviewUpcoming) {
        eventsOverviewUpcoming.onHeaderCicked();
    }
}

