/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.user.profile;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.user.profile.FavoriteBoatClassesDTO;
import com.sap.sailing.server.impl.preferences.model.BoatClassNotificationPreference;
import com.sap.sailing.server.impl.preferences.model.BoatClassNotificationPreferences;
import com.sap.sse.gwt.dispatch.shared.commands.HasWriteAction;
import com.sap.sse.gwt.dispatch.shared.commands.VoidResult;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import java.util.ArrayList;

public class SaveFavoriteBoatClassesAction
implements SailingAction<VoidResult>,
HasWriteAction {
    private FavoriteBoatClassesDTO favorites;

    protected SaveFavoriteBoatClassesAction() {
    }

    public SaveFavoriteBoatClassesAction(FavoriteBoatClassesDTO favorites) {
        this.favorites = favorites;
    }

    @GwtIncompatible
    public VoidResult execute(SailingDispatchContext ctx) throws DispatchException {
        BoatClassNotificationPreferences prefs = new BoatClassNotificationPreferences(ctx.getRacingEventService());
        ArrayList<BoatClassNotificationPreference> boatClassPreferences = new ArrayList<BoatClassNotificationPreference>();
        DomainFactory domainFactory = ctx.getRacingEventService().getBaseDomainFactory();
        for (BoatClassDTO boatClassDTO : this.favorites.getSelectedBoatClasses()) {
            BoatClass boatClass = domainFactory.getOrCreateBoatClass(boatClassDTO.getName());
            boatClassPreferences.add(new BoatClassNotificationPreference(domainFactory, boatClass, this.favorites.isNotifyAboutUpcomingRaces(), this.favorites.isNotifyAboutResults()));
        }
        prefs.setBoatClasses(boatClassPreferences);
        ctx.setPreferenceForCurrentUser("sailing.notifications.boatclasses", (Object)prefs);
        return new VoidResult();
    }
}

