/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.eventlist;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListYearDTO;
import com.sap.sse.gwt.dispatch.shared.commands.Result;
import com.sap.sse.gwt.shared.DTO;
import java.util.ArrayList;
import java.util.Map;

public class EventListViewDTO
implements DTO,
Result {
    private ArrayList<EventListEventDTO> upcomingEvents = new ArrayList();
    private ArrayList<EventListYearDTO> recentEvents = new ArrayList();

    public ArrayList<EventListEventDTO> getUpcomingEvents() {
        return this.upcomingEvents;
    }

    private void addUpcomingEvent(EventListEventDTO event) {
        int i = 0;
        while (i < this.upcomingEvents.size()) {
            if (((EventListEventDTO)this.upcomingEvents.get(i)).getStartDate().compareTo(event.getStartDate()) > 0) {
                this.upcomingEvents.add(i, event);
                return;
            }
            ++i;
        }
        this.upcomingEvents.add(event);
    }

    public ArrayList<EventListYearDTO> getRecentEvents() {
        return this.recentEvents;
    }

    @GwtIncompatible
    private EventListYearDTO getYear(int year, boolean ensureYearExists) {
        int i = 0;
        while (i < this.recentEvents.size()) {
            EventListYearDTO yearDTO = (EventListYearDTO)this.recentEvents.get(i);
            if (year == yearDTO.getYear()) {
                return yearDTO;
            }
            if (year > yearDTO.getYear()) {
                if (!ensureYearExists) {
                    return null;
                }
                EventListYearDTO newYear = new EventListYearDTO(year);
                this.recentEvents.add(i, newYear);
                return newYear;
            }
            ++i;
        }
        if (!ensureYearExists) {
            return null;
        }
        EventListYearDTO newYear = new EventListYearDTO(year);
        this.recentEvents.add(newYear);
        return newYear;
    }

    @GwtIncompatible
    public void addEvent(EventListEventDTO event, int year) {
        if (event.getState() == EventState.RUNNING || event.getState() == EventState.FINISHED) {
            this.getYear(year, true).addEvent(event);
        } else {
            this.addUpcomingEvent(event);
        }
    }

    @GwtIncompatible
    public void addStatistics(Map<Integer, Statistics> statisticsByYear) {
        statisticsByYear.forEach((year, statistics) -> {
            EventListYearDTO yearDTO = this.getYear(year.intValue(), false);
            if (yearDTO != null) {
                yearDTO.addStatistics(statistics);
            }
        });
    }
}

