/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.common.client.controls.tabbar;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.controls.tabbar.TabBarResources;
import com.sap.sse.gwt.client.LinkUtil;
import java.util.ArrayList;
import java.util.List;

public class TabBar<T>
extends Widget
implements HasSelectionHandlers<T> {
    private final TabBarResources.LocalCss style = TabBarResources.INSTANCE.css();
    private final List<T> tabObjects = new ArrayList();
    private final DivElement tabBarDiv;

    public TabBar() {
        this.style.ensureInjected();
        this.tabBarDiv = Document.get().createDivElement();
        this.tabBarDiv.addClassName(this.style.navbar());
        this.setElement((Element)this.tabBarDiv);
        this.sinkEvents(1);
    }

    public void onBrowserEvent(Event event) {
        EventTarget eventTarget = event.getEventTarget();
        if (Element.is((JavaScriptObject)eventTarget)) {
            Element element = (Element)eventTarget.cast();
            if (LinkUtil.handleLinkClick((Event)event)) {
                int i = 0;
                while (i < this.tabBarDiv.getChildCount()) {
                    if (this.tabBarDiv.getChild(i).isOrHasChild((Node)element)) {
                        event.stopPropagation();
                        event.preventDefault();
                        GWT.log((String)("Found " + this.tabObjects.get(i)));
                        SelectionEvent.fire((HasSelectionHandlers)this, this.tabObjects.get(i));
                        break;
                    }
                    ++i;
                }
            }
        }
        super.onBrowserEvent(event);
    }

    public void select(T tabObject) {
        GWT.log((String)("Should activate: " + tabObject));
        int i = 0;
        while (i < this.tabBarDiv.getChildCount()) {
            Element.as((Node)this.tabBarDiv.getChild(i)).removeClassName(this.style.navbar_buttonactive());
            ++i;
        }
        i = 0;
        while (i < this.tabObjects.size()) {
            if (tabObject.equals(this.tabObjects.get(i))) {
                GWT.log((String)("Activate: " + tabObject));
                Element.as((Node)this.tabBarDiv.getChild(i)).addClassName(this.style.navbar_buttonactive());
            }
            ++i;
        }
    }

    public void addTab(String title, T place, String link) {
        AnchorElement tabElement = Document.get().createAnchorElement();
        tabElement.setHref(link);
        tabElement.setInnerText(title);
        tabElement.addClassName(this.style.navbar_button());
        this.tabBarDiv.appendChild((Node)tabElement);
        this.tabObjects.add(place);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<T> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }
}

