/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.persistence.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.coursetemplate.ControlPointTemplate;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBuilder;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkRolePair;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.WaypointTemplate;
import com.sap.sailing.domain.coursetemplate.impl.CourseTemplateImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkRoleImpl;
import com.sap.sailing.domain.coursetemplate.impl.MarkTemplateImpl;
import com.sap.sailing.domain.coursetemplate.impl.WaypointTemplateImpl;
import com.sap.sailing.domain.racelogtracking.impl.PlaceHolderDeviceIdentifierSerializationHandler;
import com.sap.sailing.shared.persistence.DomainObjectFactory;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.device.impl.PlaceHolderDeviceIdentifierMongoHandler;
import com.sap.sailing.shared.persistence.impl.CollectionNames;
import com.sap.sailing.shared.persistence.impl.FieldNames;
import com.sap.sse.common.Color;
import com.sap.sse.common.NoCorrespondingServiceRegisteredException;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.RepeatablePartImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.Document;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoDatabase database;
    private final TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder;

    public DomainObjectFactoryImpl(MongoDatabase mongoDatabase) {
        this(mongoDatabase, null);
    }

    public DomainObjectFactoryImpl(MongoDatabase mongoDatabase, TypeBasedServiceFinderFactory serviceFinderFactory) {
        this.database = mongoDatabase;
        if (serviceFinderFactory != null) {
            this.deviceIdentifierServiceFinder = serviceFinderFactory.createServiceFinder(DeviceIdentifierMongoHandler.class);
            this.deviceIdentifierServiceFinder.setFallbackService((Object)new PlaceHolderDeviceIdentifierMongoHandler());
        } else {
            this.deviceIdentifierServiceFinder = null;
        }
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public Iterable<MarkProperties> loadAllMarkProperties(Function<UUID, MarkTemplate> markTemplateResolver, Function<UUID, MarkRole> markRoleResolver) {
        ArrayList<MarkProperties> result = new ArrayList<MarkProperties>();
        MongoCollection configurationCollection = this.database.getCollection(CollectionNames.MARK_PROPERTIES.name());
        try {
            for (Document dbObject : configurationCollection.find()) {
                MarkProperties entry = this.loadMarkPropertiesEntry(dbObject, markTemplateResolver, markRoleResolver);
                result.add(entry);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load mark properties.");
            logger.log(Level.SEVERE, "loadAllMarkProperties", e);
        }
        return result;
    }

    private MarkProperties loadMarkPropertiesEntry(Document dbObject, Function<UUID, MarkTemplate> markTemplateResolver, Function<UUID, MarkRole> markRoleResolver) {
        UUID id = UUID.fromString(dbObject.getString((Object)FieldNames.MARK_PROPERTIES_ID.name()));
        String name = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_NAME.name());
        String shortName = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_SHORT_NAME.name());
        String pattern = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_PATTERN.name());
        String shape = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_SHAPE.name());
        String type = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_TYPE.name());
        MarkType markType = type == null ? null : MarkType.valueOf((String)type);
        String storedColor = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_COLOR.name());
        Color color = AbstractColor.getCssColor((String)storedColor);
        Document positionDocument = (Document)dbObject.get((Object)FieldNames.MARK_PROPERTIES_FIXED_POSITION.name(), Document.class);
        Position fixedPosition = positionDocument == null ? null : DomainObjectFactoryImpl.loadPosition(positionDocument);
        ArrayList tagsList = (ArrayList)dbObject.get((Object)FieldNames.MARK_PROPERTIES_TAGS.name(), ArrayList.class);
        List tags = tagsList == null ? Collections.emptyList() : (Collection)tagsList.stream().map(t -> t.toString()).collect(Collectors.toList());
        MarkPropertiesBuilder builder = new MarkPropertiesBuilder(id, name, shortName, color, shape, pattern, markType).withTags(tags);
        if (fixedPosition != null) {
            builder.withFixedPosition(fixedPosition);
        } else {
            try {
                DeviceIdentifier deviceIdentifier;
                Document deviceIdDocument = (Document)dbObject.get((Object)FieldNames.MARK_PROPERTIES_TRACKING_DEVICE_IDENTIFIER.name(), Document.class);
                DeviceIdentifier deviceIdentifier2 = deviceIdentifier = deviceIdDocument == null ? null : DomainObjectFactoryImpl.loadDeviceId(this.deviceIdentifierServiceFinder, deviceIdDocument);
                if (deviceIdentifier != null) {
                    builder.withDeviceId(deviceIdentifier);
                }
            }
            catch (NoCorrespondingServiceRegisteredException | TransformationException e) {
                logger.log(Level.WARNING, "Could not load deviceId for MarkProperties", e);
            }
        }
        Document lastUsedTemplateObject = (Document)dbObject.get((Object)FieldNames.MARK_PROPERTIES_USED_TEMPLATE.name(), Document.class);
        HashMap mapLastUsedTemplate = new HashMap();
        lastUsedTemplateObject.forEach((k, v) -> {
            Object object = mapLastUsedTemplate.put(k, v);
        });
        HashMap<MarkTemplate, TimePoint> lastUsedTemplate = new HashMap<MarkTemplate, TimePoint>();
        for (Map.Entry e : mapLastUsedTemplate.entrySet()) {
            MarkTemplate markTemplate = markTemplateResolver.apply(UUID.fromString(e.getKey().toString()));
            if (markTemplate != null) {
                lastUsedTemplate.put(markTemplate, this.parseTimePoint(e.getValue()));
                continue;
            }
            logger.warning(String.format("Could not resolve MarkTemplate with id %s for MarkProperties %s.", e.getKey().toString(), id));
        }
        builder.withLastUsedTemplate(lastUsedTemplate);
        Document lastUsedRoleObject = (Document)dbObject.get((Object)FieldNames.MARK_PROPERTIES_USED_ROLE.name(), Document.class);
        HashMap mapUsedRole = new HashMap();
        lastUsedRoleObject.forEach((k, v) -> {
            Object object = mapUsedRole.put(k, v);
        });
        Map<MarkRole, TimePoint> lastUsedRole = mapUsedRole.entrySet().stream().collect(Collectors.toMap(markRoleIdObject -> (MarkRole)markRoleResolver.apply(UUID.fromString((String)markRoleIdObject)), v -> this.parseTimePoint(v)));
        builder.withLastUsedRole(lastUsedRole);
        return builder.build();
    }

    public static DeviceIdentifier loadDeviceId(TypeBasedServiceFinder<DeviceIdentifierMongoHandler> deviceIdentifierServiceFinder, Document deviceId) throws TransformationException, NoCorrespondingServiceRegisteredException {
        String deviceType = (String)deviceId.get((Object)FieldNames.DEVICE_TYPE.name());
        Object deviceTypeId = deviceId.get((Object)FieldNames.DEVICE_TYPE_SPECIFIC_ID.name());
        String stringRepresentation = (String)deviceId.get((Object)FieldNames.DEVICE_STRING_REPRESENTATION.name());
        try {
            return ((DeviceIdentifierMongoHandler)deviceIdentifierServiceFinder.findService(deviceType)).deserialize(deviceTypeId, deviceType, stringRepresentation);
        }
        catch (TransformationException e) {
            return new PlaceHolderDeviceIdentifierSerializationHandler().deserialize(stringRepresentation, deviceType, stringRepresentation);
        }
    }

    public static Position loadPosition(Document object) {
        Double lng;
        Number latNumber = (Number)object.get((Object)FieldNames.LAT_DEG.name());
        Double lat = latNumber == null ? null : Double.valueOf(latNumber.doubleValue());
        Number lngNumber = (Number)object.get((Object)FieldNames.LNG_DEG.name());
        Double d = lng = lngNumber == null ? null : Double.valueOf(lngNumber.doubleValue());
        if (lat != null && lng != null) {
            return new DegreePosition(lat.doubleValue(), lng.doubleValue());
        }
        return null;
    }

    private TimePoint parseTimePoint(Object timePointAsNumber) {
        return timePointAsNumber != null ? new MillisecondsTimePoint(((Number)timePointAsNumber).longValue()) : null;
    }

    @Override
    public Iterable<MarkTemplate> loadAllMarkTemplates() {
        ArrayList<MarkTemplate> result = new ArrayList<MarkTemplate>();
        MongoCollection configurationCollection = this.database.getCollection(CollectionNames.MARK_TEMPLATES.name());
        try {
            for (Document dbObject : configurationCollection.find()) {
                MarkTemplate entry = this.loadMarkTemplateEntry(dbObject);
                result.add(entry);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load mark templates.");
            logger.log(Level.SEVERE, "loadAllMarkTemplates", e);
        }
        return result;
    }

    private MarkTemplate loadMarkTemplateEntry(Document dbObject) {
        UUID id = UUID.fromString(dbObject.getString((Object)FieldNames.MARK_TEMPLATE_ID.name()));
        String name = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_NAME.name());
        String shortName = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_SHORT_NAME.name());
        String pattern = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_PATTERN.name());
        String shape = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_SHAPE.name());
        String type = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_TYPE.name());
        MarkType markType = type != null ? MarkType.valueOf((String)type) : null;
        String storedColor = dbObject.getString((Object)FieldNames.COMMON_MARK_PROPERTIES_COLOR.name());
        Color color = AbstractColor.getCssColor((String)storedColor);
        return new MarkTemplateImpl(id, name, shortName, color, shape, pattern, markType);
    }

    @Override
    public Iterable<MarkRole> loadAllMarkRoles() {
        ArrayList<MarkRole> result = new ArrayList<MarkRole>();
        MongoCollection configurationCollection = this.database.getCollection(CollectionNames.MARK_ROLES.name());
        try {
            for (Document dbObject : configurationCollection.find()) {
                MarkRole entry = this.loadMarkRoleEntry(dbObject);
                result.add(entry);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load mark roles.");
            logger.log(Level.SEVERE, "loadAllMarkRoles", e);
        }
        return result;
    }

    private MarkRole loadMarkRoleEntry(Document dbObject) {
        UUID id = UUID.fromString(dbObject.getString((Object)FieldNames.MARK_ROLE_ID.name()));
        String name = dbObject.getString((Object)FieldNames.MARK_ROLE_NAME.name());
        String shortName = dbObject.getString((Object)FieldNames.MARK_ROLE_SHORT_NAME.name());
        return new MarkRoleImpl(id, name, shortName);
    }

    @Override
    public Iterable<CourseTemplate> loadAllCourseTemplates(Function<UUID, MarkTemplate> markTemplateResolver, Function<UUID, MarkRole> markRoleResolver) {
        ArrayList<CourseTemplate> result = new ArrayList<CourseTemplate>();
        MongoCollection configurationCollection = this.database.getCollection(CollectionNames.COURSE_TEMPLATES.name());
        for (Document dbObject : configurationCollection.find()) {
            try {
                CourseTemplate entry = this.loadCourseTemplateEntry(dbObject, markTemplateResolver, markRoleResolver);
                result.add(entry);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load a course template. Continuing with other course templates...", e);
            }
        }
        return result;
    }

    private CourseTemplate loadCourseTemplateEntry(Document dbObject, Function<UUID, MarkTemplate> markTemplateResolver, Function<UUID, MarkRole> markRoleResolver) {
        RepeatablePartImpl optionalRepeatablePart;
        UUID id = UUID.fromString(dbObject.getString((Object)FieldNames.COURSE_TEMPLATE_ID.name()));
        String name = dbObject.getString((Object)FieldNames.COURSE_TEMPLATE_NAME.name());
        String shortName = dbObject.getString((Object)FieldNames.COURSE_TEMPLATE_SHORT_NAME.name());
        String imageURLString = dbObject.getString((Object)FieldNames.COURSE_TEMPLATE_IMAGE_URL.name());
        Integer defaultNumberOfLaps = dbObject.getInteger((Object)FieldNames.COURSE_TEMPLATE_DEFAULT_NUMBER_OF_LAPS.name());
        URL optionalImageURL = null;
        if (imageURLString != null) {
            try {
                optionalImageURL = new URL(imageURLString);
            }
            catch (MalformedURLException e) {
                logger.warning(String.format("Error parsing image URL %s for course template %s", imageURLString, id));
            }
        }
        ArrayList markTemplatesList = (ArrayList)dbObject.get((Object)FieldNames.COURSE_TEMPLATE_MARK_TEMPLATES.name(), ArrayList.class);
        HashSet<MarkTemplate> markTemplates = new HashSet<MarkTemplate>();
        HashMap<MarkTemplate, MarkRole> associatedRoles = new HashMap<MarkTemplate, MarkRole>();
        for (Object entry : markTemplatesList) {
            if (entry instanceof Document) {
                Document entryObject = (Document)entry;
                UUID markTemplateUUID = UUID.fromString(entryObject.getString((Object)FieldNames.COURSE_TEMPLATE_MARK_TEMPLATE_ID.name()));
                MarkTemplate markTemplate = markTemplateResolver.apply(markTemplateUUID);
                if (markTemplate != null) {
                    MarkRole markRoleOrNull;
                    markTemplates.add(markTemplate);
                    String roleIdAsStringOrNull = entryObject.getString((Object)FieldNames.COURSE_TEMPLATE_MARK_TEMPLATE_ROLE_ID.name());
                    MarkRole markRole = markRoleOrNull = roleIdAsStringOrNull == null ? null : markRoleResolver.apply(UUID.fromString(roleIdAsStringOrNull));
                    if (markRoleOrNull == null) continue;
                    associatedRoles.put(markTemplate, markRoleOrNull);
                    continue;
                }
                logger.warning(String.format("Could not resolve MarkTemplate with id %s for CourseTemplate %s.", markTemplateUUID, id));
                continue;
            }
            logger.warning(String.format("Unexpected entry for MarkTemplate found for CourseTemplate %s.", id));
        }
        HashMap<MarkRole, MarkTemplate> defaultMarkTemplatesForRoles = new HashMap<MarkRole, MarkTemplate>();
        ArrayList markRolesList = (ArrayList)dbObject.get((Object)FieldNames.COURSE_TEMPLATE_MARK_ROLES.name(), ArrayList.class);
        HashSet<MarkRole> markRoles = new HashSet<MarkRole>();
        for (Object entry : markRolesList) {
            if (entry instanceof Document) {
                Document entryObject = (Document)entry;
                UUID markRoleUUID = UUID.fromString(entryObject.getString((Object)FieldNames.COURSE_TEMPLATE_MARK_ROLE_ID.name()));
                MarkRole markRole = markRoleResolver.apply(markRoleUUID);
                if (markRole != null) {
                    MarkTemplate markTemplate;
                    markRoles.add(markRole);
                    String markTemplateIdAsString = entryObject.getString((Object)FieldNames.COURSE_TEMPLATE_MARK_ROLE_DEFAULT_MARK_TEMPLATE_ID.name());
                    MarkTemplate markTemplate2 = markTemplate = markTemplateIdAsString == null ? null : markTemplateResolver.apply(UUID.fromString(markTemplateIdAsString));
                    if (markTemplate == null) continue;
                    defaultMarkTemplatesForRoles.put(markRole, markTemplate);
                    continue;
                }
                logger.warning(String.format("Could not resolve MarkTemplate with id %s for CourseTemplate %s.", markRoleUUID, id));
                continue;
            }
            logger.warning(String.format("Unexpected entry for MarkTemplate found for CourseTemplate %s.", id));
        }
        ArrayList waypointTemplatesList = (ArrayList)dbObject.get((Object)FieldNames.COURSE_TEMPLATE_WAYPOINTS.name(), ArrayList.class);
        ArrayList<WaypointTemplate> waypointTemplates = new ArrayList<WaypointTemplate>();
        MarkRolePair.MarkRolePairFactory markRolePairFactory = new MarkRolePair.MarkRolePairFactory();
        for (Object o : waypointTemplatesList) {
            if (o instanceof Document) {
                Document bdo = (Document)o;
                waypointTemplates.add(this.loadWaypointTemplate(bdo, markRoleResolver, markRolePairFactory));
                continue;
            }
            logger.warning(String.format("Could not load document for CourseTemplate %s.", id));
        }
        BasicDBObject dbRepPart = (BasicDBObject)dbObject.get((Object)FieldNames.COURSE_TEMPLATE_REPEATABLE_PART.name());
        if (dbRepPart == null) {
            optionalRepeatablePart = null;
        } else {
            int zeroBasedIndexOfRepeatablePartStart = dbRepPart.getInt(FieldNames.REPEATABLE_PART_START.name());
            int zeroBasedIndexOfRepeatablePartEnd = dbRepPart.getInt(FieldNames.REPEATABLE_PART_END.name());
            optionalRepeatablePart = new RepeatablePartImpl(zeroBasedIndexOfRepeatablePartStart, zeroBasedIndexOfRepeatablePartEnd);
        }
        ArrayList tagsDbObject = (ArrayList)dbObject.get((Object)FieldNames.COURSE_TEMPLATE_TAGS.name(), ArrayList.class);
        ArrayList tags = new ArrayList();
        tagsDbObject.forEach(t -> {
            boolean bl = tags.add(t.toString());
        });
        CourseTemplateImpl courseTemplateImpl = new CourseTemplateImpl(id, name, shortName, markTemplates, waypointTemplates, defaultMarkTemplatesForRoles, associatedRoles, optionalImageURL, (RepeatablePart)optionalRepeatablePart, defaultNumberOfLaps);
        courseTemplateImpl.setTags(tags);
        return courseTemplateImpl;
    }

    private WaypointTemplate loadWaypointTemplate(Document bdo, Function<UUID, MarkRole> markRoleResolver, MarkRolePair.MarkRolePairFactory markRolePairResolver) {
        PassingInstruction passingInstruction = PassingInstruction.valueOf((String)bdo.get((Object)FieldNames.WAYPOINT_TEMPLATE_PASSINGINSTRUCTION.name()).toString());
        String name = bdo.getString((Object)FieldNames.WAYPOINT_TEMPLATE_CONTROL_POINT_NAME.name());
        String shortName = bdo.getString((Object)FieldNames.WAYPOINT_TEMPLATE_CONTROL_POINT_SHORT_NAME.name());
        ArrayList markRoleUUIDsDbList = (ArrayList)bdo.get((Object)FieldNames.WAYPOINT_TEMPLATE_MARK_ROLES.name(), ArrayList.class);
        ArrayList<MarkRole> markRoles = new ArrayList<MarkRole>();
        for (Object obj : markRoleUUIDsDbList) {
            MarkRole markRole = markRoleResolver.apply(UUID.fromString(obj.toString()));
            if (markRole == null) {
                logger.warning(String.format("Could not resolve MarkRole with id %s for WaypointTemplate.", obj.toString()));
                continue;
            }
            markRoles.add(markRole);
        }
        Object controlPointTemplate = markRoles.size() == 2 ? markRolePairResolver.create(name, shortName, (MarkRole)markRoles.get(0), (MarkRole)markRoles.get(1)) : (ControlPointTemplate)markRoles.get(0);
        return new WaypointTemplateImpl(controlPointTemplate, passingInstruction);
    }
}

