/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.persistence.impl;

import com.mongodb.BasicDBList;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.swisstimingadapter.Competitor;
import com.sap.sailing.domain.swisstimingadapter.CrewMember;
import com.sap.sailing.domain.swisstimingadapter.DomainFactory;
import com.sap.sailing.domain.swisstimingadapter.StartList;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingConfiguration;
import com.sap.sailing.domain.swisstimingadapter.SwissTimingFactory;
import com.sap.sailing.domain.swisstimingadapter.impl.CompetitorWithID;
import com.sap.sailing.domain.swisstimingadapter.impl.CompetitorWithoutID;
import com.sap.sailing.domain.swisstimingadapter.impl.CrewMemberImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.StartListImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingTrackingConnectivityParameters;
import com.sap.sailing.domain.swisstimingadapter.persistence.SwissTimingAdapterPersistence;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.impl.AbstractRaceTrackingConnectivityParametersHandler;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class SwissTimingConnectivityParamsHandler
extends AbstractRaceTrackingConnectivityParametersHandler {
    private static final String CREW_MEMBER_POSITION = "crewMemberPosition";
    private static final String CREW_MEMBER_NATIONALITY = "crewMemberNationality";
    private static final String CREW_MEMBER_NAME = "crewMemberName";
    private static final String COMPETITOR_CREW = "competitorCrew";
    private static final String COMPETITOR_THREE_LETTER_IOC_CODE = "competitorThreeLetterIocCode";
    private static final String COMPETITOR_NAME = "competitorName";
    private static final String COMPETITOR_BOAT_ID = "competitorBoatId";
    private static final String COMPETITOR_ID_AS_STRING = "competitorId";
    private static final String USE_INTERNAL_MARK_PASSING_ALGORITHM = "useInternalMarkPassingAlgorithm";
    private static final String DELAY_TO_LIVE_IN_MILLIS = "delayToLiveInMillis";
    private static final String START_LIST = "startList";
    private static final String RACE_NAME = "raceName";
    private static final String RACE_ID = "raceID";
    private static final String RACE_DESCRIPTION = "raceDescription";
    private static final String PORT = "port";
    private static final String BOAT_CLASS_NAME = "boatClassName";
    private static final String HOSTNAME = "hostname";
    private static final String UPDATE_URL = "updateURL";
    private static final String API_TOKEN = "apiToken";
    private static final String EVENT_NAME = "eventName";
    private static final String MANAGE2SAIL_EVENT_URL = "manage2SailEventUrl";
    private final RaceLogStore raceLogStore;
    private final RegattaLogStore regattaLogStore;
    private final DomainFactory domainFactory;
    private final SwissTimingFactory swissTimingFactory;
    private final SecurityService securityService;

    public SwissTimingConnectivityParamsHandler(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, DomainFactory domainFactory, SecurityService securityService) {
        this.raceLogStore = raceLogStore;
        this.regattaLogStore = regattaLogStore;
        this.domainFactory = domainFactory;
        this.securityService = securityService;
        this.swissTimingFactory = SwissTimingFactory.INSTANCE;
    }

    public Map<String, Object> mapFrom(RaceTrackingConnectivityParameters params) {
        assert (params instanceof SwissTimingTrackingConnectivityParameters);
        SwissTimingTrackingConnectivityParameters stParams = (SwissTimingTrackingConnectivityParameters)params;
        Map<String, Object> result = this.getKey(params);
        result.put(BOAT_CLASS_NAME, stParams.getBoatClass() == null ? null : stParams.getBoatClass().getName());
        result.put(RACE_DESCRIPTION, stParams.getRaceDescription());
        result.put(RACE_NAME, stParams.getRaceName());
        result.put(START_LIST, this.createStartListDBObject(stParams));
        result.put(DELAY_TO_LIVE_IN_MILLIS, stParams.getDelayToLiveInMillis());
        result.put(USE_INTERNAL_MARK_PASSING_ALGORITHM, stParams.isUseInternalMarkPassingAlgorithm());
        result.put(UPDATE_URL, stParams.getUpdateURL());
        result.put(API_TOKEN, stParams.getApiToken());
        result.put(EVENT_NAME, stParams.getEventName());
        result.put(MANAGE2SAIL_EVENT_URL, stParams.getManage2SailEventUrl());
        this.addWindTrackingParameters((RaceTrackingConnectivityParameters)stParams, result);
        return result;
    }

    private BasicDBList createStartListDBObject(SwissTimingTrackingConnectivityParameters stParams) {
        BasicDBList startListDbObject;
        if (stParams.getStartList() != null) {
            startListDbObject = new BasicDBList();
            for (Competitor competitor : stParams.getStartList().getCompetitors()) {
                Document competitorDBObject = this.createCompetitorDBObject(competitor);
                startListDbObject.add((Object)competitorDBObject);
            }
        } else {
            startListDbObject = null;
        }
        return startListDbObject;
    }

    private StartList createStartListFromDBObject(String raceId, Iterable<?> startListDBObject) {
        ArrayList<Competitor> competitors = new ArrayList<Competitor>();
        for (Object competitorObject : startListDBObject) {
            Document competitorDBObject = (Document)competitorObject;
            competitors.add(this.createCompetitorFromDBObject(competitorDBObject));
        }
        return new StartListImpl(raceId, competitors);
    }

    private Document createCompetitorDBObject(Competitor competitor) {
        Document result = new Document();
        result.put(COMPETITOR_ID_AS_STRING, (Object)competitor.getIdAsString());
        result.put(COMPETITOR_BOAT_ID, (Object)competitor.getBoatID());
        result.put(COMPETITOR_NAME, (Object)competitor.getName());
        result.put(COMPETITOR_THREE_LETTER_IOC_CODE, (Object)competitor.getThreeLetterIOCCode());
        result.put(COMPETITOR_CREW, (Object)this.createCrewDbObject(competitor.getCrew()));
        return result;
    }

    private BasicDBList createCrewDbObject(List<CrewMember> crew) {
        BasicDBList result;
        if (crew == null) {
            result = null;
        } else {
            result = new BasicDBList();
            for (CrewMember crewMember : crew) {
                Document crewMemberDBObject = new Document();
                crewMemberDBObject.put(CREW_MEMBER_NAME, (Object)crewMember.getName());
                crewMemberDBObject.put(CREW_MEMBER_NATIONALITY, (Object)crewMember.getNationality());
                crewMemberDBObject.put(CREW_MEMBER_POSITION, (Object)crewMember.getPosition());
                result.add((Object)crewMemberDBObject);
            }
        }
        return result;
    }

    private List<CrewMember> createCrewFromDBObject(Iterable<?> crewDBObject) {
        ArrayList<CrewMember> result;
        if (crewDBObject == null) {
            result = null;
        } else {
            result = new ArrayList<CrewMember>();
            for (Object o : crewDBObject) {
                Document crewMemberDBObject = (Document)o;
                result.add((CrewMember)new CrewMemberImpl((String)crewMemberDBObject.get((Object)CREW_MEMBER_NAME), (String)crewMemberDBObject.get((Object)CREW_MEMBER_NATIONALITY), (String)crewMemberDBObject.get((Object)CREW_MEMBER_POSITION)));
            }
        }
        return result;
    }

    private Competitor createCompetitorFromDBObject(Document competitorDBObject) {
        String competitorIdAsString = (String)competitorDBObject.get((Object)COMPETITOR_ID_AS_STRING);
        String boatID = (String)competitorDBObject.get((Object)COMPETITOR_BOAT_ID);
        String threeLetterIOCCode = (String)competitorDBObject.get((Object)COMPETITOR_THREE_LETTER_IOC_CODE);
        String name = (String)competitorDBObject.get((Object)COMPETITOR_NAME);
        Iterable crewDBObject = (Iterable)competitorDBObject.get((Object)COMPETITOR_CREW);
        Object result = competitorIdAsString == null ? new CompetitorWithoutID(boatID, threeLetterIOCCode, name) : new CompetitorWithID(competitorIdAsString, boatID, threeLetterIOCCode, name, this.createCrewFromDBObject(crewDBObject));
        return result;
    }

    public RaceTrackingConnectivityParameters mapTo(Map<String, Object> map) throws MalformedURLException, URISyntaxException {
        return new SwissTimingTrackingConnectivityParameters((String)map.get(HOSTNAME), ((Number)map.get(PORT)).intValue(), (String)map.get(RACE_ID), (String)map.get(RACE_NAME), (String)map.get(RACE_DESCRIPTION), this.domainFactory.getBaseDomainFactory().getOrCreateBoatClass((String)map.get(BOAT_CLASS_NAME)), map.get(START_LIST) == null ? null : this.createStartListFromDBObject((String)map.get(RACE_ID), (Iterable)map.get(START_LIST)), ((Number)map.get(DELAY_TO_LIVE_IN_MILLIS)).longValue(), this.swissTimingFactory, this.domainFactory, this.raceLogStore, this.regattaLogStore, ((Boolean)map.get(USE_INTERNAL_MARK_PASSING_ALGORITHM)).booleanValue(), this.isTrackWind(map), this.isCorrectWindDirectionByMagneticDeclination(map), (String)map.get(UPDATE_URL), (String)map.get(API_TOKEN), (String)map.get(EVENT_NAME), (String)map.get(MANAGE2SAIL_EVENT_URL));
    }

    public Map<String, Object> getKey(RaceTrackingConnectivityParameters params) {
        assert (params instanceof SwissTimingTrackingConnectivityParameters);
        SwissTimingTrackingConnectivityParameters stParams = (SwissTimingTrackingConnectivityParameters)params;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", params.getTypeIdentifier());
        result.put(HOSTNAME, stParams.getHostname());
        result.put(PORT, stParams.getPort());
        result.put(RACE_ID, stParams.getRaceID());
        return result;
    }

    public RaceTrackingConnectivityParameters resolve(RaceTrackingConnectivityParameters params) throws Exception {
        assert (params instanceof SwissTimingTrackingConnectivityParameters);
        SwissTimingTrackingConnectivityParameters stParams = (SwissTimingTrackingConnectivityParameters)params;
        SwissTimingTrackingConnectivityParameters result = new SwissTimingTrackingConnectivityParameters(stParams.getHostname(), stParams.getPort(), stParams.getRaceID(), stParams.getRaceName(), stParams.getRaceDescription(), stParams.getBoatClass(), stParams.getStartList(), stParams.getDelayToLiveInMillis(), this.swissTimingFactory, this.domainFactory, this.raceLogStore, this.regattaLogStore, stParams.isUseInternalMarkPassingAlgorithm(), stParams.isTrackWind(), stParams.isCorrectWindDirectionByMagneticDeclination(), stParams.getUpdateURL(), stParams.getApiToken(), stParams.getEventName(), stParams.getManage2SailEventUrl());
        String creatorName = SessionUtils.getPrincipal().toString();
        if (result.getManage2SailEventUrl() != null) {
            SwissTimingConfiguration swissTimingConfiguration = SwissTimingFactory.INSTANCE.createSwissTimingConfiguration(result.getEventName(), result.getManage2SailEventUrl(), result.getHostname(), Integer.valueOf(result.getPort()), result.getUpdateURL(), result.getApiToken(), creatorName);
            SwissTimingAdapterPersistence.INSTANCE.updateSwissTimingConfiguration(swissTimingConfiguration, true);
            this.securityService.setDefaultOwnershipIfNotSet(swissTimingConfiguration.getIdentifier());
        }
        return result;
    }
}

