/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.sailwave.resultimport.impl;

import com.sap.sailing.resultimport.CompetitorRow;
import com.sap.sailing.resultimport.RegattaResults;
import com.sap.sailing.resultimport.impl.CompetitorRowImpl;
import com.sap.sailing.resultimport.impl.DefaultCompetitorEntryImpl;
import com.sap.sailing.sailwave.resultimport.CsvParser;
import com.sap.sse.common.TimePoint;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CsvParserImpl
implements CsvParser {
    private final InputStream inputStream;
    private final String filename;
    private final TimePoint lastModified;
    private final String SEPARATOR = ";";

    public CsvParserImpl(InputStream inputStream, String filename, TimePoint lastModified) {
        this.inputStream = inputStream;
        this.filename = filename;
        this.lastModified = lastModified;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getBoatClass() {
        String result = "Unknown Boatclass";
        int underScoreIndex = this.filename.lastIndexOf("_");
        if (underScoreIndex > 0) {
            result = this.filename.substring(0, underScoreIndex);
        }
        return result;
    }

    @Override
    public RegattaResults parseResults() throws Exception {
        Pattern totalRankPattern = Pattern.compile("([0-9]+)((st)|(nd)|(rd)|(th))?");
        final ArrayList<CompetitorRowImpl> competitorRows = new ArrayList<CompetitorRowImpl>();
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream, "cp1252"));
        String line = br.readLine();
        int startIndexForRacePoints = -1;
        int endIndexForRacePoints = -1;
        while (line != null) {
            int firstSeparator = line.indexOf(";");
            if (!line.startsWith("DNQ") && firstSeparator > 0) {
                String firstEntry = line.substring(0, firstSeparator);
                if (firstEntry.startsWith("Rank")) {
                    String[] splittedHeadline = line.split(";");
                    int i = 0;
                    while (i < splittedHeadline.length) {
                        if (splittedHeadline[i].equals("CrewName")) {
                            startIndexForRacePoints = i + 1;
                        } else if (splittedHeadline[i].equals("Total")) {
                            endIndexForRacePoints = i - 1;
                        }
                        ++i;
                    }
                } else {
                    Matcher totalRankMatcher = totalRankPattern.matcher(firstEntry);
                    if (totalRankMatcher.matches()) {
                        String[] splittedRow = line.split(";");
                        String sailID = String.valueOf(splittedRow[1]) + " " + splittedRow[2];
                        Integer totalRank = Integer.parseInt(totalRankMatcher.group(1));
                        ArrayList<String> names = new ArrayList<String>();
                        ArrayList<DefaultCompetitorEntryImpl> rankAndMaxPointsReasonAndPointsAndDiscarded = new ArrayList<DefaultCompetitorEntryImpl>();
                        names.add(splittedRow[4]);
                        names.add(splittedRow[5]);
                        int index = startIndexForRacePoints;
                        while (index <= endIndexForRacePoints) {
                            String pointsAndMaxPointsReasonAndDiscard = splittedRow[index];
                            if (pointsAndMaxPointsReasonAndDiscard != null && !pointsAndMaxPointsReasonAndDiscard.isEmpty()) {
                                String maxPointsReason;
                                Double points;
                                Integer rank = null;
                                boolean discarded = false;
                                if (pointsAndMaxPointsReasonAndDiscard.startsWith("(") && pointsAndMaxPointsReasonAndDiscard.endsWith(")")) {
                                    pointsAndMaxPointsReasonAndDiscard = pointsAndMaxPointsReasonAndDiscard.substring(1, pointsAndMaxPointsReasonAndDiscard.length() - 1);
                                    discarded = true;
                                }
                                if (pointsAndMaxPointsReasonAndDiscard.indexOf(32) >= 0 || pointsAndMaxPointsReasonAndDiscard.indexOf(44) >= 0) {
                                    String[] splittedPointsAndMaxPointReason = pointsAndMaxPointsReasonAndDiscard.split(",| ");
                                    points = Double.valueOf(splittedPointsAndMaxPointReason[0]);
                                    maxPointsReason = splittedPointsAndMaxPointReason[1];
                                } else {
                                    points = Double.valueOf(pointsAndMaxPointsReasonAndDiscard);
                                    maxPointsReason = null;
                                }
                                if (points != 0.0) {
                                    DefaultCompetitorEntryImpl entry = new DefaultCompetitorEntryImpl(rank, maxPointsReason, points, discarded);
                                    rankAndMaxPointsReasonAndPointsAndDiscarded.add(entry);
                                } else {
                                    rankAndMaxPointsReasonAndPointsAndDiscarded.add(null);
                                }
                            }
                            ++index;
                        }
                        CompetitorRowImpl competitorRow = new CompetitorRowImpl(totalRank, sailID, names, null, null, rankAndMaxPointsReasonAndPointsAndDiscarded);
                        competitorRows.add(competitorRow);
                    }
                }
            }
            line = br.readLine();
        }
        return new RegattaResults(){

            public Map<String, String> getMetadata() {
                HashMap<String, String> result = new HashMap<String, String>();
                return result;
            }

            public List<CompetitorRow> getCompetitorResults() {
                return competitorRows;
            }
        };
    }

    @Override
    public TimePoint getLastModified() {
        return this.lastModified;
    }
}

